/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.actions.NewProjectAction;
import com.intellij.ide.actions.NewProjectOrModuleAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkout.CheckoutAction;
import com.intellij.openapi.vcs.checkout.CheckoutActionGroup;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class NewProjectFromVCSGroup
extends CheckoutActionGroup
implements NewProjectOrModuleAction {
    public NewProjectFromVCSGroup() {
        super("NewProjectFromVCS");
    }

    @NotNull
    protected AnAction createAction(CheckoutProvider provider2) {
        return new CheckoutAction(provider2, this.myIdPrefix){

            protected CheckoutProvider.Listener getListener(Project project2) {
                return new CheckoutProvider.Listener(){

                    public void directoryCheckedOut(File directory, VcsKey vcs) {
                        VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directory);
                        if (dir != null) {
                            PlatformProjectOpenProcessor.getInstance().doOpenProject(dir, null, false);
                        }
                    }

                    public void checkoutCompleted() {
                    }
                };
            }
        };
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        NewProjectAction.updateActionText(this, e);
    }

    @Override
    @NotNull
    public String getActionText(boolean isInNewSubmenu, boolean isInJavaIde) {
        return ProjectBundle.message((String)"import.project.from.vcs.action.text", (Object[])new Object[]{isInNewSubmenu ? 1 : 0, isInJavaIde ? 1 : 0});
    }
}

