/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactImpl
extends UserDataHolderBase
implements ModifiableArtifact {
    private CompositePackagingElement<?> myRootElement;
    private String myName;
    private boolean myBuildOnMake;
    private String myOutputPath;
    private final EventDispatcher<? extends ArtifactListener> myDispatcher;
    private ArtifactType myArtifactType;
    private Map<ArtifactPropertiesProvider, ArtifactProperties<?>> myProperties;
    private final ProjectModelExternalSource myExternalSource;

    public ArtifactImpl(@NotNull String name2, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath, @Nullable ProjectModelExternalSource externalSource) {
        this(name2, artifactType, buildOnMake, rootElement, outputPath, externalSource, null);
    }

    public ArtifactImpl(@NotNull String name2, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath, @Nullable ProjectModelExternalSource externalSource, EventDispatcher<? extends ArtifactListener> dispatcher) {
        this.myName = name2;
        this.myArtifactType = artifactType;
        this.myBuildOnMake = buildOnMake;
        this.myRootElement = rootElement;
        this.myOutputPath = outputPath;
        this.myDispatcher = dispatcher;
        this.myExternalSource = externalSource;
        this.myProperties = new HashMap();
        this.resetProperties();
    }

    private void resetProperties() {
        this.myProperties.clear();
        for (ArtifactPropertiesProvider provider2 : ArtifactPropertiesProvider.getProviders()) {
            if (!provider2.isAvailableFor(this.myArtifactType)) continue;
            this.myProperties.put(provider2, provider2.createProperties(this.myArtifactType));
        }
    }

    @NotNull
    public ArtifactType getArtifactType() {
        return this.myArtifactType;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    @NotNull
    public CompositePackagingElement<?> getRootElement() {
        return this.myRootElement;
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    public Collection<? extends ArtifactPropertiesProvider> getPropertiesProviders() {
        return Collections.unmodifiableCollection(this.myProperties.keySet());
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myExternalSource;
    }

    public ArtifactImpl createCopy(EventDispatcher<? extends ArtifactListener> dispatcher) {
        ArtifactImpl artifact = new ArtifactImpl(this.myName, this.myArtifactType, this.myBuildOnMake, this.myRootElement, this.myOutputPath, this.myExternalSource, dispatcher);
        for (Map.Entry<ArtifactPropertiesProvider, ArtifactProperties<?>> entry : this.myProperties.entrySet()) {
            ArtifactProperties<?> newProperties = artifact.myProperties.get(entry.getKey());
            newProperties.loadState(entry.getValue().getState());
        }
        return artifact;
    }

    public void setName(@NotNull String name2) {
        String oldName = this.myName;
        this.myName = name2;
        if (this.myDispatcher != null) {
            ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged((Artifact)this, oldName);
        }
    }

    @NonNls
    public String toString() {
        return "artifact:" + this.myName;
    }

    public void setRootElement(CompositePackagingElement<?> root) {
        this.myRootElement = root;
    }

    public void setProperties(ArtifactPropertiesProvider provider2, ArtifactProperties<?> properties) {
        if (properties != null) {
            this.myProperties.put(provider2, properties);
        } else {
            this.myProperties.remove(provider2);
        }
    }

    public void setArtifactType(@NotNull ArtifactType selected) {
        this.myArtifactType = selected;
        this.resetProperties();
    }

    public void setBuildOnMake(boolean buildOnMake) {
        this.myBuildOnMake = buildOnMake;
    }

    public void setOutputPath(String outputPath) {
        this.myOutputPath = outputPath;
    }

    public ArtifactProperties<?> getProperties(@NotNull ArtifactPropertiesProvider provider2) {
        return this.myProperties.get(provider2);
    }

    public VirtualFile getOutputFile() {
        String filePath2 = this.getOutputFilePath();
        return !StringUtil.isEmpty((String)filePath2) ? LocalFileSystem.getInstance().findFileByPath(filePath2) : null;
    }

    public String getOutputFilePath() {
        if (StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        String filePath2 = this.myRootElement instanceof ArchivePackagingElement ? this.myOutputPath + "/" + ((ArchivePackagingElement)this.myRootElement).getArchiveFileName() : this.myOutputPath;
        return filePath2;
    }

    public void copyFrom(ArtifactImpl modified) {
        this.myName = modified.getName();
        this.myOutputPath = modified.getOutputPath();
        this.myBuildOnMake = modified.isBuildOnMake();
        this.myRootElement = modified.getRootElement();
        this.myProperties = modified.myProperties;
        this.myArtifactType = modified.getArtifactType();
    }
}

