/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.server.BuildManager;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.ArtifactLoadingErrorDescription;
import com.intellij.packaging.impl.artifacts.ArtifactManagerStateSplitter;
import com.intellij.packaging.impl.artifacts.ArtifactModelBase;
import com.intellij.packaging.impl.artifacts.ArtifactModelImpl;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactVirtualFileListener;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.UnknownPackagingElementTypeException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.artifact.ArtifactManagerState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

@State(name="ArtifactManager", storages={@Storage(value="artifacts", stateSplitter=ArtifactManagerStateSplitter.class)})
public class ArtifactManagerImpl
extends ArtifactManager
implements BaseComponent,
PersistentStateComponent<ArtifactManagerState>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.artifacts.ArtifactManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ArtifactManager";
    @NonNls
    public static final String PACKAGING_ELEMENT_NAME = "element";
    @NonNls
    public static final String TYPE_ID_ATTRIBUTE = "id";
    private final ArtifactManagerModel myModel;
    private final Project myProject;
    private final DefaultPackagingElementResolvingContext myResolvingContext;
    private boolean myInsideCommit = false;
    private boolean myLoaded;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private final Map<String, LocalFileSystem.WatchRequest> myWatchedOutputs = new HashMap<String, LocalFileSystem.WatchRequest>();

    public ArtifactManagerImpl(Project project2) {
        this.myProject = project2;
        this.myModel = new ArtifactManagerModel();
        this.myResolvingContext = new DefaultPackagingElementResolvingContext(this.myProject);
        ((ArtifactPointerManagerImpl)ArtifactPointerManager.getInstance((Project)project2)).setArtifactManager(this);
    }

    @NotNull
    public Artifact[] getArtifacts() {
        return this.myModel.getArtifacts();
    }

    public Artifact findArtifact(@NotNull String name2) {
        return this.myModel.findArtifact(name2);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        return this.myModel.getArtifactByOriginal(artifact);
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        return this.myModel.getOriginalArtifact(artifact);
    }

    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type) {
        return this.myModel.getArtifactsByType(type);
    }

    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return this.myModel.getAllArtifactsIncludingInvalid();
    }

    public ArtifactManagerState getState() {
        ArtifactManagerState state = new ArtifactManagerState();
        for (Artifact artifact : this.getAllArtifactsIncludingInvalid()) {
            ArtifactState artifactState;
            if (artifact instanceof InvalidArtifact) {
                artifactState = ((InvalidArtifact)artifact).getState();
            } else {
                artifactState = new ArtifactState();
                artifactState.setBuildOnMake(artifact.isBuildOnMake());
                artifactState.setName(artifact.getName());
                artifactState.setOutputPath(artifact.getOutputPath());
                artifactState.setRootElement(ArtifactManagerImpl.serializePackagingElement(artifact.getRootElement()));
                artifactState.setArtifactType(artifact.getArtifactType().getId());
                ProjectModelExternalSource externalSource = artifact.getExternalSource();
                if (externalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)this.myProject)) {
                    artifactState.setExternalSystemId(externalSource.getId());
                }
                for (ArtifactPropertiesProvider provider2 : artifact.getPropertiesProviders()) {
                    ArtifactPropertiesState propertiesState = ArtifactManagerImpl.serializeProperties(provider2, artifact.getProperties(provider2));
                    if (propertiesState == null) continue;
                    artifactState.getPropertiesList().add(propertiesState);
                }
                Collections.sort(artifactState.getPropertiesList(), Comparator.comparing(ArtifactPropertiesState::getId));
            }
            state.getArtifacts().add(artifactState);
        }
        return state;
    }

    @Nullable
    private static <S> ArtifactPropertiesState serializeProperties(ArtifactPropertiesProvider provider2, ArtifactProperties<S> properties) {
        Element options = XmlSerializer.serialize((Object)properties.getState());
        if (options == null) {
            return null;
        }
        options.setName("options");
        ArtifactPropertiesState state = new ArtifactPropertiesState();
        state.setId(provider2.getId());
        state.setOptions(options);
        return state;
    }

    private static Element serializePackagingElement(PackagingElement<?> packagingElement) {
        Element element = new Element(PACKAGING_ELEMENT_NAME);
        element.setAttribute(TYPE_ID_ATTRIBUTE, packagingElement.getType().getId());
        Object bean = packagingElement.getState();
        if (bean != null) {
            XmlSerializer.serializeObjectInto((Object)bean, (Element)element);
        }
        if (packagingElement instanceof CompositePackagingElement) {
            for (PackagingElement child : ((CompositePackagingElement)packagingElement).getChildren()) {
                element.addContent(ArtifactManagerImpl.serializePackagingElement(child));
            }
        }
        return element;
    }

    private <T> PackagingElement<T> deserializeElement(Element element) throws UnknownPackagingElementTypeException {
        String id = element.getAttributeValue(TYPE_ID_ATTRIBUTE);
        PackagingElementType type = PackagingElementFactory.getInstance().findElementType(id);
        if (type == null) {
            throw new UnknownPackagingElementTypeException(id);
        }
        PackagingElement packagingElement = type.createEmpty(this.myProject);
        Object state = packagingElement.getState();
        if (state != null) {
            XmlSerializer.deserializeInto((Element)element, (Object)state);
            packagingElement.loadState(state);
        }
        List children = element.getChildren(PACKAGING_ELEMENT_NAME);
        for (Element child : children) {
            ((CompositePackagingElement)packagingElement).addOrFindChild(this.deserializeElement(child));
        }
        return packagingElement;
    }

    public void loadState(@NotNull ArtifactManagerState managerState) {
        List artifactStates = managerState.getArtifacts();
        ArrayList artifacts = new ArrayList(artifactStates.size());
        if (!artifactStates.isEmpty()) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (ArtifactState state : artifactStates) {
                    artifacts.add(this.loadArtifact(state));
                }
            });
        }
        if (this.myLoaded) {
            ArtifactModelImpl model = new ArtifactModelImpl(this, artifacts);
            this.doCommit(model);
        } else {
            this.myModel.setArtifactsList(artifacts);
            this.myLoaded = true;
        }
    }

    private ArtifactImpl loadArtifact(ArtifactState state) {
        CompositePackagingElement rootElement;
        ArtifactType type = ArtifactType.findById((String)state.getArtifactType());
        ProjectModelExternalSource externalSource = ArtifactManagerImpl.findExternalSource(state.getExternalSystemId());
        if (type == null) {
            return this.createInvalidArtifact(state, externalSource, "Unknown artifact type: " + state.getArtifactType());
        }
        Element element = state.getRootElement();
        String artifactName = state.getName();
        if (element != null) {
            try {
                rootElement = (CompositePackagingElement)this.deserializeElement(element);
            }
            catch (UnknownPackagingElementTypeException e) {
                return this.createInvalidArtifact(state, externalSource, "Unknown element: " + e.getTypeId());
            }
        } else {
            rootElement = type.createRootElement(artifactName);
        }
        ArtifactImpl artifact = new ArtifactImpl(artifactName, type, state.isBuildOnMake(), rootElement, state.getOutputPath(), externalSource);
        List propertiesList = state.getPropertiesList();
        for (ArtifactPropertiesState propertiesState : propertiesList) {
            ArtifactPropertiesProvider provider2 = ArtifactPropertiesProvider.findById((String)propertiesState.getId());
            if (provider2 != null) {
                ArtifactManagerImpl.deserializeProperties(artifact.getProperties(provider2), propertiesState);
                continue;
            }
            return this.createInvalidArtifact(state, externalSource, "Unknown artifact properties: " + propertiesState.getId());
        }
        return artifact;
    }

    private InvalidArtifact createInvalidArtifact(ArtifactState state, ProjectModelExternalSource externalSource, String errorMessage) {
        InvalidArtifact artifact = new InvalidArtifact(state, errorMessage, externalSource);
        ProjectLoadingErrorsNotifier.getInstance((Project)this.myProject).registerError((ConfigurationErrorDescription)new ArtifactLoadingErrorDescription(this.myProject, artifact));
        UnknownFeaturesCollector.getInstance((Project)this.myProject).registerUnknownFeature("com.intellij.packaging.artifacts.ArtifactType", state.getArtifactType(), "Artifact");
        return artifact;
    }

    @Nullable
    private static ProjectModelExternalSource findExternalSource(@Nullable String externalSourceId) {
        return externalSourceId != null ? ExternalProjectSystemRegistry.getInstance().getSourceById(externalSourceId) : null;
    }

    private static <S> void deserializeProperties(ArtifactProperties<S> artifactProperties, ArtifactPropertiesState propertiesState) {
        Element options = propertiesState.getOptions();
        if (artifactProperties == null || options == null) {
            return;
        }
        Object state = artifactProperties.getState();
        if (state != null) {
            XmlSerializer.deserializeInto((Element)options, (Object)state);
            artifactProperties.loadState(state);
        }
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedOutputs.values());
    }

    @NotNull
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void initComponent() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new ArtifactVirtualFileListener(this.myProject, this));
        this.updateWatchedRoots();
    }

    private void updateWatchedRoots() {
        HashSet<String> pathsToRemove = new HashSet<String>(this.myWatchedOutputs.keySet());
        HashSet<String> toAdd = new HashSet<String>();
        for (Artifact artifact : this.getArtifacts()) {
            String path = artifact.getOutputPath();
            if (path == null || path.length() <= 0) continue;
            pathsToRemove.remove(path);
            if (this.myWatchedOutputs.containsKey(path)) continue;
            toAdd.add(path);
        }
        ArrayList requestsToRemove = new ArrayList();
        for (String path : pathsToRemove) {
            LocalFileSystem.WatchRequest request = this.myWatchedOutputs.remove(path);
            ContainerUtil.addIfNotNull(requestsToRemove, (Object)request);
        }
        Set newRequests = LocalFileSystem.getInstance().replaceWatchedRoots(requestsToRemove, toAdd, null);
        for (LocalFileSystem.WatchRequest request : newRequests) {
            this.myWatchedOutputs.put(request.getRootPath(), request);
        }
    }

    public Artifact[] getSortedArtifacts() {
        return this.myModel.getSortedArtifacts();
    }

    public ModifiableArtifactModel createModifiableModel() {
        return new ArtifactModelImpl(this, this.getArtifactsList());
    }

    public PackagingElementResolvingContext getResolvingContext() {
        return this.myResolvingContext;
    }

    public List<? extends ArtifactImpl> getArtifactsList() {
        return this.myModel.myArtifactsList;
    }

    public void commit(ArtifactModelImpl artifactModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doCommit(artifactModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(ArtifactModelImpl artifactModel) {
        boolean hasChanges;
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        this.myInsideCommit = true;
        try {
            List<ArtifactImpl> allArtifacts = artifactModel.getOriginalArtifacts();
            THashSet removed = new THashSet((Collection)this.myModel.myArtifactsList);
            ArrayList<ArtifactImpl> added = new ArrayList<ArtifactImpl>();
            ArrayList<Pair> changed = new ArrayList<Pair>();
            for (ArtifactImpl artifact : allArtifacts) {
                boolean isAdded = !removed.remove((Object)artifact);
                ArtifactImpl modifiableCopy = artifactModel.getModifiableCopy((Artifact)artifact);
                if (isAdded) {
                    added.add(artifact);
                    continue;
                }
                if (modifiableCopy == null || ((Object)((Object)modifiableCopy)).equals((Object)artifact)) continue;
                String oldName = artifact.getName();
                artifact.copyFrom(modifiableCopy);
                changed.add(Pair.create((Object)((Object)artifact), (Object)oldName));
            }
            this.myModel.setArtifactsList(allArtifacts);
            this.myModificationTracker.incModificationCount();
            ArtifactListener publisher = (ArtifactListener)this.myProject.getMessageBus().syncPublisher(TOPIC);
            hasChanges = !removed.isEmpty() || !added.isEmpty() || !changed.isEmpty();
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> ArtifactManagerImpl.lambda$doCommit$1((Set)removed, publisher, added, changed));
        }
        finally {
            this.myInsideCommit = false;
        }
        this.updateWatchedRoots();
        if (hasChanges) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Artifact addArtifact(@NotNull String name2, @NotNull ArtifactType type, CompositePackagingElement<?> root) {
        return (Artifact)WriteAction.compute(() -> {
            ModifiableArtifactModel model = this.createModifiableModel();
            ModifiableArtifact artifact = model.addArtifact(name2, type);
            if (root != null) {
                artifact.setRootElement(root);
            }
            model.commit();
            return artifact;
        });
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull PackagingElement<?> element) {
        this.addElementsToDirectory(artifact, relativePath, Collections.singletonList(element));
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull Collection<? extends PackagingElement<?>> elements) {
        ModifiableArtifactModel model = this.createModifiableModel();
        CompositePackagingElement root = model.getOrCreateModifiableArtifact(artifact).getRootElement();
        PackagingElementFactory.getInstance().getOrCreateDirectory(root, relativePath).addOrFindChildren(elements);
        WriteAction.run(() -> model.commit());
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    private static /* synthetic */ void lambda$doCommit$1(Set removed, ArtifactListener publisher, List added, List changed) {
        for (ArtifactImpl artifact : removed) {
            publisher.artifactRemoved((Artifact)artifact);
        }
        for (ArtifactImpl artifact : added) {
            publisher.artifactAdded((Artifact)artifact);
        }
        for (Pair pair2 : changed) {
            publisher.artifactChanged((Artifact)pair2.getFirst(), (String)pair2.getSecond());
        }
    }

    private static class ArtifactManagerModel
    extends ArtifactModelBase {
        private List<? extends ArtifactImpl> myArtifactsList = new ArrayList<ArtifactImpl>();
        private Artifact[] mySortedArtifacts;

        private ArtifactManagerModel() {
        }

        public void setArtifactsList(List<? extends ArtifactImpl> artifactsList) {
            this.myArtifactsList = artifactsList;
            this.artifactsChanged();
        }

        @Override
        protected void artifactsChanged() {
            super.artifactsChanged();
            this.mySortedArtifacts = null;
        }

        @Override
        protected List<? extends Artifact> getArtifactsList() {
            return this.myArtifactsList;
        }

        public Artifact[] getSortedArtifacts() {
            if (this.mySortedArtifacts == null) {
                this.mySortedArtifacts = (Artifact[])this.getArtifacts().clone();
                Arrays.sort(this.mySortedArtifacts, ArtifactManager.ARTIFACT_COMPARATOR);
            }
            return this.mySortedArtifacts;
        }
    }
}

