/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.ModulePackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactUtil {
    private ArtifactUtil() {
    }

    public static CompositePackagingElement<?> copyFromRoot(@NotNull CompositePackagingElement<?> oldRoot, @NotNull Project project2) {
        CompositePackagingElement newRoot = (CompositePackagingElement)ArtifactUtil.copyElement(oldRoot, project2);
        ArtifactUtil.copyChildren(oldRoot, newRoot, project2);
        return newRoot;
    }

    public static void copyChildren(CompositePackagingElement<?> oldParent, CompositePackagingElement<?> newParent, @NotNull Project project2) {
        for (PackagingElement child : oldParent.getChildren()) {
            newParent.addOrFindChild(ArtifactUtil.copyWithChildren(child, project2));
        }
    }

    @NotNull
    public static <S> PackagingElement<S> copyWithChildren(@NotNull PackagingElement<? extends S> element, @NotNull Project project2) {
        PackagingElement<? extends S> copy = ArtifactUtil.copyElement(element, project2);
        if (element instanceof CompositePackagingElement) {
            ArtifactUtil.copyChildren((CompositePackagingElement)element, (CompositePackagingElement)copy, project2);
        }
        return copy;
    }

    @NotNull
    private static <S> PackagingElement<S> copyElement(@NotNull PackagingElement<? extends S> element, @NotNull Project project2) {
        PackagingElement copy = element.getType().createEmpty(project2);
        Object state = element.getState();
        if (state != null) {
            copy.loadState(state);
        } else {
            copy.noStateLoaded();
        }
        return copy;
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, final @NotNull Processor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        return ArtifactUtil.processPackagingElements(artifact, type, new PackagingElementProcessor<E>(){

            @Override
            public boolean process(@NotNull E e, @NotNull PackagingElementPath path) {
                return processor2.process(e);
            }
        }, resolvingContext, processSubstitutions);
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        return ArtifactUtil.processPackagingElements(artifact.getRootElement(), type, processor2, resolvingContext, processSubstitutions, artifact.getArtifactType());
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(PackagingElement<?> rootElement, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType) {
        return ArtifactUtil.processElementRecursively(rootElement, type, processor2, resolvingContext, processSubstitutions, artifactType, PackagingElementPath.EMPTY, new HashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsRecursively(List<? extends PackagingElement<?>> elements, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        for (PackagingElement<?> element : elements) {
            if (ArtifactUtil.processElementRecursively(element, type, processor2, resolvingContext, processSubstitutions, artifactType, path, processed)) continue;
            return false;
        }
        return true;
    }

    public static void processRecursivelySkippingIncludedArtifacts(Artifact artifact, final Processor<? super PackagingElement<?>> processor2, PackagingElementResolvingContext context) {
        ArtifactUtil.processPackagingElements(artifact.getRootElement(), null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                return processor2.process(element);
            }

            @Override
            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                return !(element instanceof ArtifactPackagingElement);
            }
        }, context, true, artifact.getArtifactType());
    }

    private static <E extends PackagingElement<?>> boolean processElementRecursively(@NotNull PackagingElement<?> element, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        List substitution;
        ComplexPackagingElement complexElement;
        if (!processor2.shouldProcess(element) || !processed.add(element)) {
            return true;
        }
        if ((type == null || element.getType().equals(type)) && !processor2.process(element, path)) {
            return false;
        }
        if (element instanceof CompositePackagingElement) {
            CompositePackagingElement composite = (CompositePackagingElement)element;
            return ArtifactUtil.processElementsRecursively(composite.getChildren(), type, processor2, resolvingContext, processSubstitutions, artifactType, path.appendComposite(composite), processed);
        }
        if (element instanceof ComplexPackagingElement && processSubstitutions && processor2.shouldProcessSubstitution(complexElement = (ComplexPackagingElement)element) && (substitution = complexElement.getSubstitution(resolvingContext, artifactType)) != null) {
            return ArtifactUtil.processElementsRecursively(substitution, type, processor2, resolvingContext, processSubstitutions, artifactType, path.appendComplex(complexElement), processed);
        }
        return true;
    }

    public static void removeDuplicates(@NotNull CompositePackagingElement<?> parent) {
        ArrayList<PackagingElement> prevChildren = new ArrayList<PackagingElement>();
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : parent.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                ArtifactUtil.removeDuplicates((CompositePackagingElement)child);
            }
            boolean merged = false;
            for (PackagingElement prevChild : prevChildren) {
                if (!child.isEqualTo(prevChild)) continue;
                if (child instanceof CompositePackagingElement) {
                    for (PackagingElement childElement : ((CompositePackagingElement)child).getChildren()) {
                        ((CompositePackagingElement)prevChild).addOrFindChild(childElement);
                    }
                }
                merged = true;
                break;
            }
            if (merged) {
                toRemove.add(child);
                continue;
            }
            prevChildren.add(child);
        }
        for (PackagingElement child : toRemove) {
            parent.removeChild(child);
        }
    }

    public static <S> void copyProperties(ArtifactProperties<?> from, ArtifactProperties<S> to) {
        to.loadState(from.getState());
    }

    @Nullable
    public static String getDefaultArtifactOutputPath(@NotNull String artifactName, @NotNull Project project2) {
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)project2);
        if (extension == null) {
            return null;
        }
        String outputUrl = extension.getCompilerOutputUrl();
        if (outputUrl == null || outputUrl.length() == 0) {
            VirtualFile baseDir = project2.getBaseDir();
            if (baseDir == null) {
                return null;
            }
            outputUrl = baseDir.getUrl() + "/out";
        }
        return VfsUtilCore.urlToPath((String)outputUrl) + "/artifacts/" + FileUtil.sanitizeFileName((String)artifactName);
    }

    public static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor2) {
        return ArtifactUtil.processElementsWithSubstitutions(elements, context, artifactType, parentPath, processor2, new THashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor2, Set<? super PackagingElement<?>> processed) {
        for (PackagingElement<?> element : elements) {
            ComplexPackagingElement complexElement;
            List substitution;
            if (!processed.add(element) || !(element instanceof ComplexPackagingElement && processor2.shouldProcessSubstitution((ComplexPackagingElement)element) ? (substitution = (complexElement = (ComplexPackagingElement)element).getSubstitution(context, artifactType)) != null && !ArtifactUtil.processElementsWithSubstitutions(substitution, context, artifactType, parentPath.appendComplex(complexElement), processor2, processed) : !processor2.process(element, parentPath))) continue;
            return false;
        }
        return true;
    }

    public static List<PackagingElement<?>> findByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        final ArrayList result = new ArrayList();
        ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath path) {
                result.add(packagingElement);
                return true;
            }
        });
        return result;
    }

    public static boolean processElementsByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, final @NotNull PackagingElementProcessor<? super PackagingElement<?>> processor2) {
        if ((relativePath = StringUtil.trimStart((String)relativePath, (String)"/")).isEmpty()) {
            return true;
        }
        int i = relativePath.indexOf(47);
        final String firstName = i != -1 ? relativePath.substring(0, i) : relativePath;
        final String tail = i != -1 ? relativePath.substring(i + 1) : "";
        return ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, parentPath.appendComposite(parent), new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                FileCopyPackagingElement fileCopy;
                boolean process2 = false;
                if (element instanceof CompositePackagingElement && firstName.equals(((CompositePackagingElement)element).getName())) {
                    process2 = true;
                } else if (element instanceof FileCopyPackagingElement && firstName.equals((fileCopy = (FileCopyPackagingElement)element).getOutputFileName())) {
                    process2 = true;
                }
                if (process2) {
                    if (tail.length() == 0) {
                        if (!processor2.process(element, path)) {
                            return false;
                        }
                    } else if (element instanceof CompositePackagingElement) {
                        return ArtifactUtil.processElementsByRelativePath((CompositePackagingElement)element, tail, context, artifactType, path, processor2);
                    }
                }
                return true;
            }
        });
    }

    public static boolean processDirectoryChildren(@NotNull CompositePackagingElement<?> parent, @NotNull PackagingElementPath pathToParent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, final @NotNull PackagingElementProcessor<PackagingElement<?>> processor2) {
        return ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, pathToParent, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                List children;
                return !(element instanceof DirectoryPackagingElement) || ArtifactUtil.processElementsWithSubstitutions(children = ((DirectoryPackagingElement)element).getChildren(), context, artifactType, path.appendComposite((DirectoryPackagingElement)element), processor2);
            }
        });
    }

    public static void processFileOrDirectoryCopyElements(Artifact artifact, PackagingElementProcessor<? super FileOrDirectoryCopyPackagingElement<?>> processor2, PackagingElementResolvingContext context, boolean processSubstitutions) {
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, processor2, context, processSubstitutions);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE, processor2, context, processSubstitutions);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, processor2, context, processSubstitutions);
    }

    public static Collection<Trinity<Artifact, PackagingElementPath, String>> findContainingArtifactsWithOutputPaths(final @NotNull VirtualFile file, @NotNull Project project2, Artifact[] artifacts) {
        final boolean isResourceFile = CompilerConfiguration.getInstance((Project)project2).isResourceFile(file);
        final ArrayList<Trinity<Artifact, PackagingElementPath, String>> result = new ArrayList<Trinity<Artifact, PackagingElementPath, String>>();
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project2).getResolvingContext();
        for (final Artifact artifact : artifacts) {
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    String relativePath;
                    if (element instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile root = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                        if (root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
                            String relativePath2 = root.equals(file) && element instanceof FileCopyPackagingElement ? ((FileCopyPackagingElement)element).getOutputFileName() : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
                            result.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath2));
                            return false;
                        }
                    } else if (isResourceFile && element instanceof ModuleOutputPackagingElement && (relativePath = ArtifactUtil.getRelativePathInSources(file, (ModuleOutputPackagingElement)element, context)) != null) {
                        result.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath));
                        return false;
                    }
                    return true;
                }
            }, context, true);
        }
        return result;
    }

    @Nullable
    private static String getRelativePathInSources(@NotNull VirtualFile file, @NotNull ModuleOutputPackagingElement moduleElement, @NotNull PackagingElementResolvingContext context) {
        for (VirtualFile sourceRoot : moduleElement.getSourceRoots(context)) {
            if (!VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)file, (boolean)true)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(Artifact artifact, String outputPath, PackagingElementResolvingContext context) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(artifact.getRootElement(), outputPath, context, artifact.getArtifactType());
        return files.isEmpty() ? null : files.get(0);
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(parent, outputPath, context, artifactType);
        return files.isEmpty() ? null : files.get(0);
    }

    public static List<VirtualFile> findSourceFilesByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        String path = StringUtil.trimStart((String)outputPath, (String)"/");
        if (path.isEmpty()) {
            return Collections.emptyList();
        }
        int i = path.indexOf(47);
        final String firstName = i != -1 ? path.substring(0, i) : path;
        String tail = i != -1 ? path.substring(i + 1) : "";
        SmartList result = new SmartList();
        ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>((List)result, tail, context, artifactType, path){
            final /* synthetic */ List val$result;
            final /* synthetic */ String val$tail;
            final /* synthetic */ PackagingElementResolvingContext val$context;
            final /* synthetic */ ArtifactType val$artifactType;
            final /* synthetic */ String val$path;
            {
                this.val$result = list;
                this.val$tail = string2;
                this.val$context = packagingElementResolvingContext;
                this.val$artifactType = artifactType;
                this.val$path = string3;
            }

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath elementPath) {
                if (element instanceof CompositePackagingElement) {
                    CompositePackagingElement compositeElement = (CompositePackagingElement)element;
                    if (firstName.equals(compositeElement.getName())) {
                        this.val$result.addAll(ArtifactUtil.findSourceFilesByOutputPath(compositeElement, this.val$tail, this.val$context, this.val$artifactType));
                    }
                } else if (element instanceof FileCopyPackagingElement) {
                    FileCopyPackagingElement fileCopyElement = (FileCopyPackagingElement)element;
                    if (firstName.equals(fileCopyElement.getOutputFileName()) && this.val$tail.isEmpty()) {
                        ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)fileCopyElement.findFile());
                    }
                } else if (element instanceof DirectoryCopyPackagingElement || element instanceof ExtractedDirectoryPackagingElement) {
                    VirtualFile sourceRoot = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                    if (sourceRoot != null) {
                        ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)sourceRoot.findFileByRelativePath(this.val$path));
                    }
                } else if (element instanceof ModulePackagingElement) {
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.val$context.getProject());
                    for (VirtualFile sourceRoot : ((ModulePackagingElement)element).getSourceRoots(this.val$context)) {
                        VirtualFile sourceFile = sourceRoot.findFileByRelativePath(this.val$path);
                        if (sourceFile == null || !compilerConfiguration.isResourceFile(sourceFile)) continue;
                        this.val$result.add(sourceFile);
                    }
                }
                return true;
            }
        });
        return result;
    }

    public static boolean processParents(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ParentElementProcessor processor2, int maxLevel) {
        return ArtifactUtil.processParents(artifact, context, processor2, FList.emptyList(), maxLevel, (Set<? super Artifact>)new THashSet());
    }

    private static boolean processParents(final @NotNull Artifact artifact, final @NotNull PackagingElementResolvingContext context, final @NotNull ParentElementProcessor processor2, FList<Pair<Artifact, CompositePackagingElement<?>>> pathToElement, final int maxLevel, final Set<? super Artifact> processed) {
        FList pathFromRoot;
        if (!processed.add((Artifact)artifact)) {
            return true;
        }
        CompositePackagingElement rootElement = artifact.getRootElement();
        if (rootElement instanceof ArtifactRootElement) {
            pathFromRoot = pathToElement;
        } else {
            if (!processor2.process((CompositePackagingElement<?>)rootElement, (List<Pair<Artifact, CompositePackagingElement<?>>>)pathToElement, artifact)) {
                return false;
            }
            pathFromRoot = pathToElement.prepend((Object)new Pair((Object)artifact, (Object)rootElement));
        }
        if (pathFromRoot.size() > maxLevel) {
            return true;
        }
        for (final Artifact anArtifact : context.getArtifactModel().getArtifacts()) {
            PackagingElementProcessor<ArtifactPackagingElement> elementProcessor;
            if (processed.contains(anArtifact) || ArtifactUtil.processPackagingElements(anArtifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, elementProcessor = new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                    return !(element instanceof ArtifactPackagingElement);
                }

                @Override
                public boolean process(@NotNull ArtifactPackagingElement element, @NotNull PackagingElementPath path) {
                    if (artifact.getName().equals(element.getArtifactName())) {
                        CompositePackagingElement<?> lastParent;
                        FList currentPath = pathFromRoot;
                        List<CompositePackagingElement<?>> parents = path.getParents();
                        int parentsSize = parents.size();
                        for (int i = 0; i < parentsSize - 1; ++i) {
                            CompositePackagingElement<?> parent = parents.get(i);
                            if (!processor2.process(parent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                                return false;
                            }
                            if ((currentPath = currentPath.prepend((Object)new Pair((Object)anArtifact, parent))).size() <= maxLevel) continue;
                            return true;
                        }
                        if (!parents.isEmpty() && (lastParent = parents.get(parents.size() - 1)) instanceof ArtifactRootElement && !processor2.process(lastParent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                            return false;
                        }
                        return ArtifactUtil.processParents(anArtifact, context, processor2, currentPath, maxLevel, processed);
                    }
                    return true;
                }
            }, context, true)) continue;
            return false;
        }
        return true;
    }

    public static void removeChildrenRecursively(@NotNull CompositePackagingElement<?> element, @NotNull Condition<? super PackagingElement<?>> condition) {
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : element.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                CompositePackagingElement compositeChild = (CompositePackagingElement)child;
                ArtifactUtil.removeChildrenRecursively(compositeChild, condition);
                if (!compositeChild.getChildren().isEmpty()) continue;
                toRemove.add(child);
                continue;
            }
            if (!condition.value((Object)child)) continue;
            toRemove.add(child);
        }
        element.removeChildren(toRemove);
    }

    public static boolean shouldClearArtifactOutputBeforeRebuild(Artifact artifact) {
        String outputPath = artifact.getOutputPath();
        return !StringUtil.isEmpty((String)outputPath) && artifact.getRootElement() instanceof ArtifactRootElement;
    }

    public static Set<Module> getModulesIncludedInArtifacts(@NotNull Collection<? extends Artifact> artifacts, @NotNull Project project2) {
        THashSet modules = new THashSet();
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project2).getResolvingContext();
        for (Artifact artifact : artifacts) {
            ArtifactUtil.processPackagingElements(artifact, null, arg_0 -> ArtifactUtil.lambda$getModulesIncludedInArtifacts$0((Set)modules, resolvingContext, arg_0), resolvingContext, true);
        }
        return modules;
    }

    public static Collection<Artifact> getArtifactsContainingModuleOutput(@NotNull Module module2) {
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)module2.getProject());
        PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        HashSet<Artifact> result = new HashSet<Artifact>();
        Processor processor2 = element -> {
            if (element instanceof ProductionModuleOutputPackagingElement && module2.equals(((ProductionModuleOutputPackagingElement)element).findModule(context))) {
                return false;
            }
            return !(element instanceof ArtifactPackagingElement) || !result.contains(((ArtifactPackagingElement)((Object)element)).findArtifact(context));
        };
        for (Artifact artifact : artifactManager.getSortedArtifacts()) {
            boolean contains;
            boolean bl = contains = !ArtifactUtil.processPackagingElements(artifact, null, processor2, context, true);
            if (!contains) continue;
            result.add(artifact);
        }
        return result;
    }

    public static List<Artifact> getArtifactWithOutputPaths(Project project2) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project2).getSortedArtifacts()) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            result.add(artifact);
        }
        return result;
    }

    public static String suggestArtifactFileName(String artifactName) {
        return PathUtil.suggestFileName((String)artifactName, (boolean)true, (boolean)true);
    }

    @Nullable
    public static Artifact addArtifact(@NotNull ModifiableArtifactModel artifactModel, @NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate) {
        ArtifactTemplate.NewArtifactConfiguration configuration = artifactTemplate.createArtifact();
        if (configuration == null) {
            return null;
        }
        String baseName = configuration.getArtifactName();
        String name2 = ArtifactUtil.generateUniqueArtifactName(baseName, artifactModel);
        ArtifactType actualType = configuration.getArtifactType();
        if (actualType == null) {
            actualType = type;
        }
        ModifiableArtifact artifact = artifactModel.addArtifact(name2, actualType, configuration.getRootElement());
        artifactTemplate.setUpArtifact((Artifact)artifact, configuration);
        return artifact;
    }

    @NotNull
    public static String generateUniqueArtifactName(String baseName, @NotNull ModifiableArtifactModel artifactModel) {
        return UniqueNameGenerator.generateUniqueName((String)baseName, name2 -> artifactModel.findArtifact(name2) == null);
    }

    private static /* synthetic */ boolean lambda$getModulesIncludedInArtifacts$0(Set modules, PackagingElementResolvingContext resolvingContext, PackagingElement element) {
        if (element instanceof ModuleOutputPackagingElement) {
            ContainerUtil.addIfNotNull((Collection)modules, (Object)((ModuleOutputPackagingElement)element).findModule(resolvingContext));
        }
        return true;
    }
}

