/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.impl.artifacts.ArtifactManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ArtifactVirtualFileListener
implements BulkFileListener {
    private final CachedValue<MultiValuesMap<String, Artifact>> myParentPathsToArtifacts;
    private final ArtifactManagerImpl myArtifactManager;

    ArtifactVirtualFileListener(@NotNull Project project2, @NotNull ArtifactManagerImpl artifactManager) {
        this.myArtifactManager = artifactManager;
        this.myParentPathsToArtifacts = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
            MultiValuesMap<String, Artifact> result = this.computeParentPathToArtifactMap();
            return CachedValueProvider.Result.createSingleDependency(result, (Object)artifactManager.getModificationTracker());
        }, false);
    }

    private MultiValuesMap<String, Artifact> computeParentPathToArtifactMap() {
        final MultiValuesMap result = new MultiValuesMap();
        for (final Artifact artifact : this.myArtifactManager.getArtifacts()) {
            ArtifactUtil.processFileOrDirectoryCopyElements(artifact, new PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>>(){

                @Override
                public boolean process(@NotNull FileOrDirectoryCopyPackagingElement<?> element, @NotNull PackagingElementPath pathToElement) {
                    String path = element.getFilePath();
                    while (path.length() > 0) {
                        result.put((Object)path, (Object)artifact);
                        path = PathUtil.getParentPath((String)path);
                    }
                    return true;
                }
            }, this.myArtifactManager.getResolvingContext(), false);
        }
        return result;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileMoveEvent) {
                this.filePathChanged(((VFileMoveEvent)vFileEvent).getOldPath(), vFileEvent.getPath());
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            this.propertyChanged((VFilePropertyChangeEvent)vFileEvent);
        }
    }

    private void filePathChanged(final @NotNull String oldPath, final @NotNull String newPath) {
        Collection artifacts = ((MultiValuesMap)this.myParentPathsToArtifacts.getValue()).get((Object)oldPath);
        if (artifacts != null) {
            ModifiableArtifactModel model = this.myArtifactManager.createModifiableModel();
            for (Artifact artifact : artifacts) {
                ModifiableArtifact copy = model.getOrCreateModifiableArtifact(artifact);
                ArtifactUtil.processFileOrDirectoryCopyElements((Artifact)copy, new PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>>(){

                    @Override
                    public boolean process(@NotNull FileOrDirectoryCopyPackagingElement<?> element, @NotNull PackagingElementPath pathToElement) {
                        String path = element.getFilePath();
                        if (FileUtil.startsWith((String)path, (String)oldPath)) {
                            element.setFilePath(newPath + path.substring(oldPath.length()));
                        }
                        return true;
                    }
                }, this.myArtifactManager.getResolvingContext(), false);
            }
            model.commit();
        }
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        VirtualFile parent;
        if ("name".equals(event.getPropertyName()) && (parent = event.getFile().getParent()) != null) {
            String parentPath = parent.getPath();
            this.filePathChanged(parentPath + "/" + event.getOldValue(), parentPath + "/" + event.getNewValue());
        }
    }
}

