/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.icons.AllIcons;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.JarFromModulesTemplate;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JarArtifactType
extends ArtifactType {
    public JarArtifactType() {
        super("jar", "JAR");
    }

    public static JarArtifactType getInstance() {
        return (JarArtifactType)((Object)EP_NAME.findExtension(JarArtifactType.class));
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        return "/";
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        return PackagingElementFactory.getInstance().createArchive(ArtifactUtil.suggestArtifactFileName(artifactName) + ".jar");
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        return Collections.singletonList(new JarFromModulesTemplate(context));
    }
}

