/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsCompiler
implements Compiler {
    private static final Key<Set<String>> WRITTEN_PATHS_KEY = Key.create((String)"artifacts_written_paths");

    public boolean validateConfiguration(CompileScope scope) {
        return false;
    }

    @Nullable
    public static ArtifactsCompiler getInstance(@NotNull Project project2) {
        ArtifactsCompiler[] compilers = (ArtifactsCompiler[])CompilerManager.getInstance((Project)project2).getCompilers(ArtifactsCompiler.class);
        return compilers.length == 1 ? compilers[0] : null;
    }

    public static void addWrittenPaths(CompileContext context, Set<String> writtenPaths) {
        Set paths = (Set)context.getUserData(WRITTEN_PATHS_KEY);
        if (paths == null) {
            paths = new THashSet();
            context.putUserData(WRITTEN_PATHS_KEY, (Object)paths);
        }
        paths.addAll(writtenPaths);
    }

    @NotNull
    public String getDescription() {
        return "Artifacts Packaging Compiler";
    }

    @Nullable
    public static Set<String> getWrittenPaths(@NotNull CompileContext context) {
        return (Set)context.getUserData(WRITTEN_PATHS_KEY);
    }
}

