/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ExtractedDirectoryElementType
extends PackagingElementType<ExtractedDirectoryPackagingElement> {
    ExtractedDirectoryElementType() {
        super("extracted-dir", "Extracted Directory");
    }

    public Icon getCreateElementIcon() {
        return AllIcons.Nodes.ExtractedFolder;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        return true;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, true, false, true, true){

            public boolean isFileSelectable(VirtualFile file) {
                if (file.isInLocalFileSystem() && file.isDirectory()) {
                    return false;
                }
                return super.isFileSelectable(file);
            }
        };
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)context.getProject(), null);
        ArrayList<PackagingElement> list = new ArrayList<PackagingElement>();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        for (VirtualFile file : files) {
            list.add(factory.createExtractedDirectory(file));
        }
        return list;
    }

    @NotNull
    public ExtractedDirectoryPackagingElement createEmpty(@NotNull Project project2) {
        return new ExtractedDirectoryPackagingElement();
    }
}

