/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileOrDirectoryCopyPackagingElement<T extends FileOrDirectoryCopyPackagingElement>
extends PackagingElement<T> {
    @NonNls
    public static final String PATH_ATTRIBUTE = "path";
    protected String myFilePath;

    public FileOrDirectoryCopyPackagingElement(PackagingElementType type) {
        super(type);
    }

    protected FileOrDirectoryCopyPackagingElement(PackagingElementType type, String filePath2) {
        super(type);
        this.myFilePath = filePath2;
    }

    @Nullable
    public VirtualFile findFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myFilePath);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        return element instanceof FileOrDirectoryCopyPackagingElement && this.myFilePath != null && this.myFilePath.equals(((FileOrDirectoryCopyPackagingElement)element).getFilePath());
    }

    @Attribute(value="path")
    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(String filePath2) {
        this.myFilePath = filePath2;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        VirtualFile file = this.findFile();
        if (file == null) {
            return PackagingElementOutputKind.OTHER;
        }
        if (file.isDirectory() && file.isInLocalFileSystem()) {
            boolean containsDirectories = false;
            boolean containsJars = false;
            for (VirtualFile child : file.getChildren()) {
                if (child.isDirectory() && child.isInLocalFileSystem()) {
                    containsDirectories |= true;
                } else {
                    containsJars |= FileOrDirectoryCopyPackagingElement.isJar(child);
                }
                if (containsDirectories && containsJars) break;
            }
            return new PackagingElementOutputKind(containsDirectories, containsJars);
        }
        return FileOrDirectoryCopyPackagingElement.isJar(file) ? PackagingElementOutputKind.JAR_FILES : PackagingElementOutputKind.OTHER;
    }

    private static boolean isJar(VirtualFile file) {
        String ext = file.getExtension();
        return ext != null && ext.equalsIgnoreCase("jar");
    }
}

