/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModulePackagingElementBase;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleElementTypeBase<E extends ModulePackagingElementBase>
extends PackagingElementType<E> {
    public ModuleElementTypeBase(String id, String presentableName) {
        super(id, presentableName);
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        return !this.getSuitableModules(context).isEmpty();
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        List<Module> suitableModules = this.getSuitableModules(context);
        List selected = context.chooseModules(suitableModules, ProjectBundle.message((String)"dialog.title.packaging.choose.module", (Object[])new Object[0]));
        ArrayList<ModulePackagingElementBase> elements = new ArrayList<ModulePackagingElementBase>();
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)context.getProject());
        for (Module module2 : selected) {
            elements.add(this.createElement(context.getProject(), pointerManager.create(module2)));
        }
        return elements;
    }

    protected abstract ModulePackagingElementBase createElement(@NotNull Project var1, @NotNull ModulePointer var2);

    private List<Module> getSuitableModules(ArtifactEditorContext context) {
        ModulesProvider modulesProvider = context.getModulesProvider();
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module2 : modulesProvider.getModules()) {
            if (!this.isSuitableModule(modulesProvider, module2)) continue;
            modules.add(module2);
        }
        return modules;
    }

    public abstract boolean isSuitableModule(@NotNull ModulesProvider var1, @NotNull Module var2);

    @NotNull
    public abstract String getElementText(@NotNull String var1);

    public Icon getElementIcon(@Nullable Module module2) {
        return module2 != null ? ModuleType.get((Module)module2).getIcon() : AllIcons.Modules.Output;
    }
}

