/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactChooser
extends ElementsChooser<ArtifactPointer> {
    private static final Comparator<ArtifactPointer> ARTIFACT_COMPARATOR = (o1, o2) -> o1.getArtifactName().compareToIgnoreCase(o2.getArtifactName());
    private static final MultiStateElementsChooser.ElementProperties INVALID_ARTIFACT_PROPERTIES = new MultiStateElementsChooser.ElementProperties(){

        public Icon getIcon() {
            return AllIcons.Nodes.Artifact;
        }

        public Color getColor() {
            return JBColor.RED;
        }
    };

    public ArtifactChooser(List<ArtifactPointer> pointers) {
        super(pointers, false);
        for (ArtifactPointer pointer : pointers) {
            if (pointer.getArtifact() != null) continue;
            this.setElementProperties(pointer, INVALID_ARTIFACT_PROPERTIES);
        }
        this.sort(ARTIFACT_COMPARATOR);
    }

    protected String getItemText(@NotNull ArtifactPointer value) {
        return value.getArtifactName();
    }

    protected Icon getItemIcon(@NotNull ArtifactPointer value) {
        Artifact artifact = value.getArtifact();
        return artifact != null ? artifact.getArtifactType().getIcon() : null;
    }
}

