/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BuildArtifactsBeforeRunTaskBase<Self extends BuildArtifactsBeforeRunTaskBase>
extends BeforeRunTask<Self> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    private List<ArtifactPointer> myArtifactPointers = new ArrayList<ArtifactPointer>();
    private final Project myProject;
    private final String myElementName;

    protected BuildArtifactsBeforeRunTaskBase(@NotNull Key<Self> providerId, Project project2, String elementName) {
        super(providerId);
        this.myProject = project2;
        this.myElementName = elementName;
    }

    public void readExternal(@NotNull Element element) {
        super.readExternal(element);
        List children = element.getChildren(this.myElementName);
        ArtifactPointerManager pointerManager = ArtifactPointerManager.getInstance((Project)this.myProject);
        for (Element child : children) {
            this.myArtifactPointers.add(pointerManager.createPointer(child.getAttributeValue(NAME_ATTRIBUTE)));
        }
    }

    public BeforeRunTask clone() {
        BuildArtifactsBeforeRunTaskBase task = (BuildArtifactsBeforeRunTaskBase)super.clone();
        task.myArtifactPointers = new ArrayList<ArtifactPointer>(this.myArtifactPointers);
        return task;
    }

    public void writeExternal(@NotNull Element element) {
        super.writeExternal(element);
        for (ArtifactPointer pointer : this.myArtifactPointers) {
            element.addContent(new Element(this.myElementName).setAttribute(NAME_ATTRIBUTE, pointer.getArtifactName()));
        }
    }

    public int getItemsCount() {
        return this.myArtifactPointers.size();
    }

    public List<ArtifactPointer> getArtifactPointers() {
        return Collections.unmodifiableList(this.myArtifactPointers);
    }

    public void setArtifactPointers(List<? extends ArtifactPointer> artifactPointers) {
        this.myArtifactPointers = new ArrayList<ArtifactPointer>(artifactPointers);
    }

    public void addArtifact(Artifact artifact) {
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact);
        if (!this.myArtifactPointers.contains(pointer)) {
            this.myArtifactPointers.add(pointer);
        }
    }

    public void removeArtifact(@NotNull Artifact artifact) {
        this.removeArtifact(ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact));
    }

    public void removeArtifact(@NotNull ArtifactPointer pointer) {
        this.myArtifactPointers.remove(pointer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildArtifactsBeforeRunTaskBase that = (BuildArtifactsBeforeRunTaskBase)((Object)o);
        if (!this.myArtifactPointers.equals(that.myArtifactPointers)) {
            return false;
        }
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myArtifactPointers.hashCode();
        result = 31 * result + this.myProject.hashCode();
        return result;
    }
}

