/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertFieldToAtomicIntention
extends PsiElementBaseIntentionAction
implements PriorityAction {
    private static final Logger LOG = Logger.getInstance(ConvertFieldToAtomicIntention.class);
    private final Map<PsiType, String> myFromToMap = ContainerUtil.newHashMap();

    public ConvertFieldToAtomicIntention() {
        this.myFromToMap.put((PsiType)PsiType.INT, AtomicInteger.class.getName());
        this.myFromToMap.put((PsiType)PsiType.LONG, AtomicLong.class.getName());
        this.myFromToMap.put((PsiType)PsiType.BOOLEAN, AtomicBoolean.class.getName());
        this.myFromToMap.put((PsiType)PsiType.INT.createArrayType(), AtomicIntegerArray.class.getName());
        this.myFromToMap.put((PsiType)PsiType.LONG.createArrayType(), AtomicLongArray.class.getName());
    }

    @NotNull
    public String getText() {
        return "Convert to atomic";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.LOW;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        String qualifiedName;
        PsiVariable psiVariable = this.getVariable(element);
        if (psiVariable == null || psiVariable instanceof PsiResourceVariable) {
            return false;
        }
        if (psiVariable.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (psiVariable.getTypeElement() == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiVariable)) {
            return false;
        }
        PsiType psiType = psiVariable.getType();
        PsiClass psiTypeClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiTypeClass != null ? (qualifiedName = psiTypeClass.getQualifiedName()) != null && (this.myFromToMap.values().contains(qualifiedName) || qualifiedName.equals(AtomicReference.class.getName()) || qualifiedName.equals(AtomicReferenceArray.class.getName())) : !this.myFromToMap.containsKey(psiType)) {
            return false;
        }
        return AllowedApiFilterExtension.isClassAllowed((String)AtomicReference.class.getName(), (PsiElement)element);
    }

    PsiVariable getVariable(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiIdentifier && ((parent = element.getParent()) instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return (PsiVariable)parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiVariable var = this.getVariable(element);
        LOG.assertTrue(var != null);
        PsiType fromType = var.getType();
        PsiClassType toType = this.getMigrationTargetType(project2, element, fromType);
        if (toType == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{var})) {
            return;
        }
        ConvertFieldToAtomicIntention.addExplicitInitializer(var);
        String toTypeCanonicalText = toType.getCanonicalText();
        TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable(var, (PsiType)toType, editor, false, false);
        ConvertFieldToAtomicIntention.postProcessVariable(var, toTypeCanonicalText);
    }

    static void addExplicitInitializer(@NotNull PsiVariable var) {
        PsiExpression currentInitializer = var.getInitializer();
        if (currentInitializer != null) {
            return;
        }
        PsiType type = var.getType();
        String initializerText = PsiTypesUtil.getDefaultValueOfType((PsiType)type);
        if (!"null".equals(initializerText)) {
            WriteAction.run(() -> {
                PsiExpression initializer = JavaPsiFacade.getElementFactory((Project)var.getProject()).createExpressionFromText(initializerText, (PsiElement)var);
                var.setInitializer(initializer);
            });
        }
    }

    static void postProcessVariable(@NotNull PsiVariable var, @NotNull String toType) {
        Project project2 = var.getProject();
        if (var instanceof PsiField || JavaCodeStyleSettings.getInstance((PsiFile)var.getContainingFile()).GENERATE_FINAL_LOCALS) {
            PsiModifierList modifierList = (PsiModifierList)ObjectUtils.assertNotNull((Object)var.getModifierList());
            WriteAction.run(() -> {
                if (var.getInitializer() == null) {
                    PsiExpression newInitializer = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("new " + toType + "()", (PsiElement)var);
                    var.setInitializer(newInitializer);
                }
                modifierList.setModifierProperty("final", true);
                modifierList.setModifierProperty("volatile", false);
                JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)var);
                CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)var);
            });
        }
    }

    @Nullable
    private PsiClassType getMigrationTargetType(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiType fromType) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        String atomicQualifiedName = this.myFromToMap.get(fromType);
        if (atomicQualifiedName != null) {
            PsiClass atomicClass = psiFacade.findClass(atomicQualifiedName, GlobalSearchScope.allScope((Project)project2));
            if (atomicClass == null) {
                return null;
            }
            return factory.createType(atomicClass);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass atomicReferenceArrayClass = psiFacade.findClass(AtomicReferenceArray.class.getName(), GlobalSearchScope.allScope((Project)project2));
            if (atomicReferenceArrayClass == null) {
                return null;
            }
            HashMap substitutor = ContainerUtil.newHashMap();
            PsiTypeParameter[] typeParameters = atomicReferenceArrayClass.getTypeParameters();
            if (typeParameters.length == 1) {
                PsiType componentType = ((PsiArrayType)fromType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    componentType = ((PsiPrimitiveType)componentType).getBoxedType(element);
                }
                substitutor.put(typeParameters[0], componentType);
            }
            return factory.createType(atomicReferenceArrayClass, factory.createSubstitutor((Map)substitutor));
        }
        PsiClass atomicReferenceClass = psiFacade.findClass(AtomicReference.class.getName(), GlobalSearchScope.allScope((Project)project2));
        if (atomicReferenceClass == null) {
            return null;
        }
        HashMap substitutor = ContainerUtil.newHashMap();
        PsiTypeParameter[] typeParameters = atomicReferenceClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiType type = fromType;
            if (type instanceof PsiPrimitiveType) {
                type = ((PsiPrimitiveType)fromType).getBoxedType(element);
            }
            substitutor.put(typeParameters[0], type);
        }
        return factory.createType(atomicReferenceClass, factory.createSubstitutor((Map)substitutor));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static class ConvertNonFinalLocalToAtomicFix
    extends ConvertFieldToAtomicIntention {
        private final PsiElement myContext;

        public ConvertNonFinalLocalToAtomicFix(PsiElement context) {
            this.myContext = context;
        }

        @Override
        @NotNull
        public PriorityAction.Priority getPriority() {
            return PriorityAction.Priority.HIGH;
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
            return this.getVariable(element) != null;
        }

        @Override
        PsiVariable getVariable(PsiElement element) {
            PsiReferenceExpression ref;
            if (this.myContext instanceof PsiReferenceExpression && this.myContext.isValid() && PsiUtil.isAccessedForWriting((PsiExpression)(ref = (PsiReferenceExpression)this.myContext))) {
                return (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiLocalVariable.class);
            }
            return null;
        }
    }
}

