/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGuavaTypeConversionRule
extends TypeConversionRule {
    private final SoftLazyValue<Map<String, TypeConversionDescriptorBase>> mySimpleDescriptors = new SoftLazyValue<Map<String, TypeConversionDescriptorBase>>(){

        @NotNull
        protected Map<String, TypeConversionDescriptorBase> compute() {
            HashMap map2 = new HashMap();
            BaseGuavaTypeConversionRule.this.fillSimpleDescriptors((Map<String, TypeConversionDescriptorBase>)map2);
            return map2;
        }
    };

    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        return null;
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@Nullable PsiExpression context) {
        return null;
    }

    @NotNull
    public abstract String ruleFromClass();

    @NotNull
    public abstract String ruleToClass();

    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        return Collections.emptySet();
    }

    @Nullable
    public final TypeConversionDescriptorBase findConversion(@Nullable PsiType from, @Nullable PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiElement resolvedElement;
        if (from != null && to != null && !BaseGuavaTypeConversionRule.canConvert(from, to, this.ruleFromClass(), this.ruleToClass())) {
            return null;
        }
        if (member instanceof PsiMethod) {
            TypeConversionDescriptorBase descriptor2;
            PsiMethod method = (PsiMethod)member;
            String methodName = method.getName();
            PsiClass aClass = method.getContainingClass();
            if (this.isValidMethodQualifierToConvert(aClass) && (descriptor2 = (TypeConversionDescriptorBase)((Map)this.mySimpleDescriptors.getValue()).get(methodName)) != null) {
                return descriptor2;
            }
            TypeConversionDescriptorBase conversionForMethod = this.findConversionForMethod(from, to, method, methodName, context, labeler);
            return conversionForMethod != null ? conversionForMethod : this.getUnknownMethodConversion();
        }
        if (context instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)context).getAnonymousClass();
            return anonymousClass == null ? null : this.findConversionForAnonymous(anonymousClass, (GuavaConversionSettings)labeler.getSettings(GuavaConversionSettings.class));
        }
        if (context instanceof PsiMethodReferenceExpression) {
            PsiType methodReferenceType = context.getType();
            if (methodReferenceType != null && to != null && to.isAssignableFrom(methodReferenceType)) {
                return new TypeConversionDescriptorBase();
            }
        } else if (context instanceof PsiReferenceExpression && (resolvedElement = ((PsiReferenceExpression)context).resolve()) instanceof PsiVariable) {
            return this.findConversionForVariableReference(context);
        }
        return null;
    }

    protected abstract TypeConversionDescriptorBase getUnknownMethodConversion();

    @Nullable
    protected TypeConversionDescriptorBase findConversionForAnonymous(@NotNull PsiAnonymousClass anonymousClass, @Nullable GuavaConversionSettings settings) {
        Set<Object> ignoredAnnotations;
        Set<Object> set = ignoredAnnotations = settings != null ? settings.getIgnoredAnnotations() : Collections.emptySet();
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda((PsiAnonymousClass)anonymousClass, (boolean)false, ignoredAnnotations)) {
            return new TypeConversionDescriptorBase(){

                public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, (boolean)false, (boolean)true);
                }
            };
        }
        return null;
    }

    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return aClass != null && (this.ruleFromClass().equals(aClass.getQualifiedName()) || this.getAdditionalUtilityClasses().contains(aClass.getQualifiedName()));
    }

    static boolean canConvert(@Nullable PsiType from, @Nullable PsiType to, @NotNull String fromClassName, @NotNull String toClassName) {
        if (!(from instanceof PsiClassType)) {
            return false;
        }
        if (!(to instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult fromResolveResult = ((PsiClassType)from).resolveGenerics();
        PsiClass fromClass = fromResolveResult.getElement();
        if (fromClass instanceof PsiAnonymousClass) {
            fromClass = ((PsiAnonymousClass)fromClass).getBaseClassType().resolve();
        }
        if (fromClass == null || !fromClassName.equals(fromClass.getQualifiedName())) {
            return false;
        }
        PsiClassType.ClassResolveResult toResolveResult = ((PsiClassType)to).resolveGenerics();
        PsiClass toClass = toResolveResult.getElement();
        return toClass != null && toClassName.equals(toClass.getQualifiedName());
    }
}

