/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaFluentIterableConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaOptionalConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaTypeConversionDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaOptionalConversionRule
extends BaseGuavaTypeConversionRule {
    private static final Logger LOG = Logger.getInstance(GuavaOptionalConversionRule.class);
    public static final String OPTIONAL_CONVERTOR_PATTERN = "Optional.fromNullable($o$.orElse(null))";
    public static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    public static final String JAVA_OPTIONAL = "java.util.Optional";

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(@Nullable PsiType from, @Nullable PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        if (!(context instanceof PsiMethodCallExpression)) {
            if ("or".equals(methodName)) {
                PsiMethodCallExpression methodCallExpression = null;
                if (context.getParent() instanceof PsiMethodCallExpression) {
                    methodCallExpression = (PsiMethodCallExpression)context.getParent();
                }
                if (methodCallExpression == null) {
                    return null;
                }
                PsiClass aClass = GuavaOptionalConversionRule.getParameterClass(method);
                if (aClass != null) {
                    String qName = aClass.getQualifiedName();
                    if (GUAVA_OPTIONAL.equals(qName)) {
                        TypeConversionDescriptor descriptor2 = new TypeConversionDescriptor(null, "java.util.Optional.ofNullable($val$.orElseGet($o$::get))"){

                            @Override
                            public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                                this.setStringToReplace("$val$.or(" + GuavaOptionalConversionUtil.simplifyParameterPattern((PsiMethodCallExpression)expression) + ")");
                                return super.replace(expression, evaluator);
                            }
                        };
                        if (to != null) {
                            descriptor2.withConversionType(to);
                        }
                        return descriptor2;
                    }
                    return GuavaLambda.SUPPLIER.getClassQName().equals(qName) ? new GuavaTypeConversionDescriptor("$val$.or($other$)", "$val$.orElseGet($other$)", context) : new TypeConversionDescriptor("$val$.or($other$)", "$val$.orElse($other$)");
                }
                return null;
            }
            if ("transform".equals(methodName)) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)context.getParent();
                PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
                if (arguments.length != 1) {
                    return null;
                }
                PsiExpression functionArgument = arguments[0];
                GuavaTypeConversionDescriptor descriptor3 = new GuavaTypeConversionDescriptor("$val$.transform($fun$)", "$val$.map($fun$)", context);
                PsiType typeParameter = GuavaConversionUtil.getFunctionReturnType(functionArgument);
                if (typeParameter == null) {
                    return descriptor3;
                }
                String rawOptionalType = "java.util.Optional<" + typeParameter.getCanonicalText(false) + ">";
                return descriptor3.withConversionType(JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText(rawOptionalType, (PsiElement)context));
            }
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !"com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName()) && !GUAVA_OPTIONAL.equals(aClass.getQualifiedName())) {
            return null;
        }
        return GuavaFluentIterableConversionRule.buildCompoundDescriptor((PsiMethodCallExpression)context, to, labeler);
    }

    @Override
    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return super.isValidMethodQualifierToConvert(aClass) || aClass != null && "com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName());
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@Nullable PsiExpression context) {
        if (GuavaOptionalConversionUtil.isOptionalOrContext(context)) {
            return new TypeConversionDescriptor("$o$", "com.google.common.base.Optional.fromNullable($o$.orElse(null))");
        }
        return new TypeConversionDescriptor("$o$", "$o$::get");
    }

    private static PsiClass getParameterClass(PsiMethod method) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return null;
        }
        return PsiTypesUtil.getPsiClass((PsiType)parameters[0].getType());
    }

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put("absent", new TypeConversionDescriptor("'_Optional?.absent()", "java.util.Optional.empty()"){

            @Override
            public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                LOG.assertTrue(expression instanceof PsiMethodCallExpression);
                PsiReferenceParameterList typeArguments = ((PsiMethodCallExpression)expression).getTypeArgumentList();
                PsiReferenceParameterList typeArgumentsCopy = typeArguments.getTypeArguments().length == 0 ? null : (PsiReferenceParameterList)typeArguments.copy();
                PsiMethodCallExpression replacedExpression = (PsiMethodCallExpression)super.replace(expression, evaluator);
                if (typeArgumentsCopy != null) {
                    replacedExpression.getTypeArgumentList().replace((PsiElement)typeArgumentsCopy);
                }
                return replacedExpression;
            }
        });
        descriptorsMap.put("of", new TypeConversionDescriptor("'_Optional?.of($ref$)", "java.util.Optional.of($ref$)"));
        descriptorsMap.put("fromNullable", new TypeConversionDescriptor("'_Optional?.fromNullable($ref$)", "java.util.Optional.ofNullable($ref$)"));
        descriptorsMap.put("presentInstances", new TypeConversionDescriptor("'_Optional?.presentInstances($it$)", "java.util.stream.StreamSupport.stream($it$.spliterator(), false).map(java.util.Optional::get).collect(java.util.Collectors.toList())"));
        TypeConversionDescriptorBase identity = new TypeConversionDescriptorBase();
        descriptorsMap.put("get", identity);
        descriptorsMap.put("isPresent", identity);
        descriptorsMap.put("orNull", new TypeConversionDescriptor("$val$.orNull()", "$val$.orElse(null)"));
        descriptorsMap.put("asSet", new TypeConversionDescriptor("$val$.asSet()", "$val$.map(java.util.Collections::singleton).orElse(java.util.Collections.emptySet())"));
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        return GUAVA_OPTIONAL;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        return JAVA_OPTIONAL;
    }

    @Override
    protected TypeConversionDescriptorBase getUnknownMethodConversion() {
        return null;
    }
}

