/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambdaConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaPredicatesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaPredicateConversionRule
extends GuavaLambdaConversionRule {
    private static final String GUAVA_PREDICATES_UTILITY = "com.google.common.base.Predicates";

    protected GuavaPredicateConversionRule() {
        super(GuavaLambda.PREDICATE);
    }

    @Override
    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        return Collections.singleton(GUAVA_PREDICATES_UTILITY);
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        TypeConversionDescriptorBase descriptor2;
        if (!(context instanceof PsiMethodCallExpression)) {
            return null;
        }
        if (GuavaPredicateConversionRule.isPredicates((PsiMethodCallExpression)context) && (descriptor2 = GuavaPredicatesUtil.tryConvertIfPredicates(method, context)) != null) {
            return descriptor2;
        }
        return new TypeConversionDescriptorBase(){

            public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                return (PsiExpression)expression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::apply", (PsiElement)expression));
            }
        };
    }

    public static boolean isPredicates(PsiMethodCallExpression expression) {
        String methodName = expression.getMethodExpression().getReferenceName();
        if (GuavaPredicatesUtil.PREDICATES_METHOD_NAMES.contains(methodName)) {
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass != null && GUAVA_PREDICATES_UTILITY.equals(aClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }
}

