/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceImpl;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ArtifactDeploymentSourceType
extends DeploymentSourceType<ArtifactDeploymentSource> {
    private static final String NAME_ATTRIBUTE = "name";

    public ArtifactDeploymentSourceType() {
        super("artifact");
    }

    @NotNull
    public ArtifactDeploymentSource load(@NotNull Element tag, @NotNull Project project2) {
        return new ArtifactDeploymentSourceImpl(ArtifactPointerManager.getInstance((Project)project2).createPointer(tag.getAttributeValue(NAME_ATTRIBUTE)));
    }

    public void save(@NotNull ArtifactDeploymentSource source, @NotNull Element tag) {
        tag.setAttribute(NAME_ATTRIBUTE, source.getArtifactPointer().getArtifactName());
    }

    public void setBuildBeforeRunTask(@NotNull RunConfiguration configuration, @NotNull ArtifactDeploymentSource source) {
        Artifact artifact = source.getArtifact();
        if (artifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun(configuration.getProject(), configuration, artifact);
        }
    }

    public void updateBuildBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, @NotNull Project project2, @NotNull ArtifactDeploymentSource source, boolean select) {
        Artifact artifact = source.getArtifact();
        if (artifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption(runConfigurationEditorComponent, project2, artifact, select);
        }
    }
}

