/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment.debug;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugServerModeHandler;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebuggerLauncher;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerLauncherImpl
extends JavaDebuggerLauncher {
    private static final Logger LOG = Logger.getInstance(JavaDebuggerLauncherImpl.class);

    public void startDebugSession(@NotNull JavaDebugConnectionData info, @NotNull ExecutionEnvironment executionEnvironment, @NotNull RemoteServer<?> server) throws ExecutionException {
        Project project2 = executionEnvironment.getProject();
        DebuggerPanelsManager manager = DebuggerPanelsManager.getInstance(project2);
        final JavaDebugServerModeHandler serverModeHandler = info.getServerModeHandler();
        boolean serverMode = serverModeHandler != null;
        RemoteConnection remoteConnection = new RemoteConnection(true, info.getHost(), String.valueOf(info.getPort()), serverMode);
        RemoteServerDebugEnvironment debugEnvironment = new RemoteServerDebugEnvironment(project2, remoteConnection, executionEnvironment.getRunProfile());
        RemoteServerDebugUIEnvironment debugUIEnvironment = new RemoteServerDebugUIEnvironment(debugEnvironment, executionEnvironment);
        RunContentDescriptor debugContentDescriptor = manager.attachVirtualMachine(debugUIEnvironment);
        LOG.assertTrue(debugContentDescriptor != null);
        ProcessHandler processHandler = debugContentDescriptor.getProcessHandler();
        LOG.assertTrue(processHandler != null);
        if (serverMode) {
            serverModeHandler.attachRemote();
            DebuggerManager.getInstance((Project)executionEnvironment.getProject()).addDebugProcessListener(processHandler, new DebugProcessListener(){

                public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                    try {
                        serverModeHandler.detachRemote();
                    }
                    catch (ExecutionException e) {
                        LOG.info((Throwable)e);
                    }
                }
            });
        }
    }

    private static class RemoteServerDebugEnvironment
    implements DebugEnvironment {
        private final Project myProject;
        private final GlobalSearchScope mySearchScope;
        private final RemoteConnection myRemoteConnection;
        private final RunProfile myRunProfile;

        RemoteServerDebugEnvironment(Project project2, RemoteConnection remoteConnection, RunProfile runProfile) {
            this.myProject = project2;
            this.mySearchScope = GlobalSearchScopes.executionScope((Project)project2, (RunProfile)runProfile);
            this.myRemoteConnection = remoteConnection;
            this.myRunProfile = runProfile;
        }

        @Override
        @Nullable
        public ExecutionResult createExecutionResult() throws ExecutionException {
            ConsoleViewImpl consoleView = new ConsoleViewImpl(this.myProject, false);
            RemoteDebugProcessHandler process2 = new RemoteDebugProcessHandler(this.myProject);
            consoleView.attachToProcess((ProcessHandler)process2);
            return new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)process2);
        }

        @Override
        @NotNull
        public GlobalSearchScope getSearchScope() {
            return this.mySearchScope;
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        @Override
        public RemoteConnection getRemoteConnection() {
            return this.myRemoteConnection;
        }

        @Override
        public long getPollTimeout() {
            return 30000L;
        }

        @Override
        public String getSessionName() {
            return this.myRunProfile.getName();
        }
    }

    private static class RemoteServerDebugUIEnvironment
    implements DebugUIEnvironment {
        private final DebugEnvironment myEnvironment;
        private final ExecutionEnvironment myExecutionEnvironment;

        RemoteServerDebugUIEnvironment(DebugEnvironment environment, ExecutionEnvironment executionEnvironment) {
            this.myEnvironment = environment;
            this.myExecutionEnvironment = executionEnvironment;
        }

        @Override
        public DebugEnvironment getEnvironment() {
            return this.myEnvironment;
        }

        @Override
        @Nullable
        public RunContentDescriptor getReuseContent() {
            return this.myExecutionEnvironment.getContentToReuse();
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myExecutionEnvironment.getRunProfile().getIcon();
        }

        @Override
        public void initActions(RunContentDescriptor content, DefaultActionGroup actionGroup) {
            actionGroup.add((AnAction)new CloseAction(this.myExecutionEnvironment.getExecutor(), content, this.myExecutionEnvironment.getProject()));
        }

        @Override
        @Nullable
        public RunProfile getRunProfile() {
            return this.myExecutionEnvironment.getRunProfile();
        }
    }
}

