/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.JavaPredefinedConfigurations;
import com.intellij.structuralsearch.JavaReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.JavaCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.ExprTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.FormalArgTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStructuralSearchProfile
extends StructuralSearchProfile {
    private static final Set<String> PRIMITIVE_TYPES = new THashSet(Arrays.asList("short", "boolean", "double", "long", "int", "float", "char", "byte"));

    @Override
    public String getText(PsiElement match, int start, int end) {
        PsiElement parent;
        if (match instanceof PsiIdentifier && (parent = match.getParent()) instanceof PsiJavaCodeReferenceElement && !(parent instanceof PsiExpression)) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            String text = referenceElement.getText();
            if (end != -1) {
                return text.substring(start, end);
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null) {
                return text.substring(start, parameterList.getStartOffsetInParent());
            }
            return text;
        }
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @Override
    @NotNull
    public String getTypedVarString(PsiElement element) {
        String text;
        if (element instanceof PsiNamedElement) {
            text = ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiAnnotation) {
            PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)element).getNameReferenceElement();
            text = referenceElement == null ? null : referenceElement.getQualifiedName();
        } else if (element instanceof PsiNameValuePair) {
            text = ((PsiNameValuePair)element).getName();
        } else {
            int i;
            text = element.getText();
            if (StringUtil.startsWithChar((CharSequence)text, (char)'@')) {
                text = text.substring(1);
            }
            if (StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                text = text.substring(0, text.length() - 1);
            } else if (element instanceof PsiExpressionStatement && (i = text.indexOf(59)) != -1) {
                text = text.substring(0, i);
            }
        }
        if (text == null) {
            text = element.getText();
        }
        return text;
    }

    @Override
    public String getMeaningfulText(PsiElement element) {
        if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() != null) {
            String text;
            PsiElement resolve2 = ((PsiReferenceExpression)element).resolve();
            if (resolve2 instanceof PsiClass) {
                return element.getText();
            }
            PsiElement referencedElement = ((PsiReferenceExpression)element).getReferenceNameElement();
            String string = text = referencedElement != null ? referencedElement.getText() : "";
            if (resolve2 == null && text.length() > 0 && Character.isUpperCase(text.charAt(0))) {
                return element.getText();
            }
            return text;
        }
        return super.getMeaningfulText(element);
    }

    @Override
    @Nullable
    public String getAlternativeText(PsiElement node, String previousText) {
        if (node instanceof PsiJavaCodeReferenceElement || node instanceof PsiClass) {
            PsiElement element;
            PsiElement psiElement = element = node instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)node).resolve() : node;
            if (element instanceof PsiClass) {
                String text = ((PsiClass)element).getQualifiedName();
                if (text != null && text.equals(previousText)) {
                    text = ((PsiClass)element).getName();
                }
                if (text != null) {
                    return text;
                }
            }
        } else if (node instanceof PsiLiteralExpression || node instanceof PsiComment) {
            return node.getText();
        }
        return null;
    }

    @Override
    public PsiElement updateCurrentNode(PsiElement targetNode) {
        if (targetNode instanceof PsiCodeBlock && ((PsiCodeBlock)targetNode).getStatementCount() == 1) {
            PsiElement targetNodeParent = targetNode.getParent();
            if (targetNodeParent instanceof PsiBlockStatement) {
                targetNodeParent = targetNodeParent.getParent();
            }
            if (targetNodeParent instanceof PsiIfStatement || targetNodeParent instanceof PsiLoopStatement) {
                targetNode = targetNodeParent;
            }
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchedByDownUp(PsiElement targetNode) {
        PsiElement parent;
        if (targetNode instanceof PsiIdentifier && ((parent = (targetNode = targetNode.getParent()).getParent()) instanceof PsiTypeElement || parent instanceof PsiStatement)) {
            targetNode = parent;
        }
        return targetNode;
    }

    @Override
    public PsiElement extendMatchOnePsiFile(PsiElement file) {
        if (file instanceof PsiIdentifier) {
            file = file.getParent();
        }
        return file;
    }

    @Override
    @NotNull
    public PsiElement getPresentableElement(PsiElement element) {
        PsiElement parent;
        if ((element = super.getPresentableElement(element)) instanceof PsiReferenceExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiMethodCallExpression) {
                return parent2;
            }
        } else if (element instanceof PsiJavaCodeReferenceElement && ((parent = element.getParent()) instanceof PsiTypeElement || parent instanceof PsiNewExpression || parent instanceof PsiAnnotation)) {
            return parent;
        }
        return element;
    }

    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        new JavaCompilingVisitor(globalVisitor).compile(elements);
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        return new JavaMatchingVisitor(globalVisitor);
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        return element -> JavaStructuralSearchProfile.isLexicalNode(element);
    }

    private static boolean isLexicalNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiJavaToken) {
            return !(element instanceof PsiKeyword) || !PRIMITIVE_TYPES.contains(element.getText()) || !(element.getParent() instanceof PsiNewExpression);
        }
        return false;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new JavaCompiledPattern();
    }

    @Override
    public List<MatchPredicate> getCustomPredicates(MatchVariableConstraint constraint, String name2, MatchOptions options) {
        ExprTypePredicate predicate;
        SmartList result = new SmartList();
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfExprType())) {
            predicate = new ExprTypePredicate(constraint.getNameOfExprType(), name2, constraint.isExprTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults());
            result.add(constraint.isInvertExprType() ? new NotPredicate(predicate) : predicate);
        }
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfFormalArgType())) {
            predicate = new FormalArgTypePredicate(constraint.getNameOfFormalArgType(), name2, constraint.isFormalArgTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults());
            result.add(constraint.isInvertFormalType() ? new NotPredicate(predicate) : predicate);
        }
        return result;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        return language == JavaLanguage.INSTANCE;
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        return new JavaReplaceHandler(project2, replaceOptions);
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        if (physical) {
            throw new UnsupportedOperationException(this.getClass() + " cannot create physical PSI");
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        if (context == PatternTreeContext.Block) {
            PsiElement[] classPattern;
            PsiCodeBlock codeBlock = elementFactory.createCodeBlockFromText("{\n" + text + "\n}", null);
            PsiElement element = codeBlock.getFirstBodyElement();
            if (element == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            SmartList result = new SmartList();
            PsiElement lastBodyElement = codeBlock.getLastBodyElement();
            while (element != null) {
                if (!(element instanceof PsiWhiteSpace)) {
                    result.add(element);
                }
                if (element == lastBodyElement) break;
                element = element.getNextSibling();
            }
            if (result.isEmpty()) {
                return PsiElement.EMPTY_ARRAY;
            }
            if (JavaStructuralSearchProfile.shouldTryExpressionPattern((List<PsiElement>)result)) {
                try {
                    PsiElement[] expressionPattern = this.createPatternTree(text, PatternTreeContext.Expression, fileType, language, contextName, extension, project2, false);
                    if (expressionPattern.length == 1) {
                        return expressionPattern;
                    }
                }
                catch (IncorrectOperationException expressionPattern) {}
            } else if (JavaStructuralSearchProfile.shouldTryClassPattern((List<PsiElement>)result) && (classPattern = this.createPatternTree(text, PatternTreeContext.Class, fileType, language, contextName, extension, project2, false)).length == 1) {
                return classPattern;
            }
            return result.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (context == PatternTreeContext.Class) {
            PsiElement endChild;
            PsiClass clazz = elementFactory.createClassFromText(text, null);
            PsiElement startChild = clazz.getLBrace();
            if (startChild != null) {
                startChild = startChild.getNextSibling();
            }
            if ((endChild = clazz.getRBrace()) != null) {
                endChild = endChild.getPrevSibling();
            }
            if (startChild == endChild) {
                return PsiElement.EMPTY_ARRAY;
            }
            assert (startChild != null);
            SmartList result = new SmartList();
            for (PsiElement element = startChild.getNextSibling(); element != endChild && element != null; element = element.getNextSibling()) {
                result.add(element);
            }
            return PsiUtilCore.toPsiElementArray((Collection)result);
        }
        if (context == PatternTreeContext.Expression) {
            return new PsiElement[]{elementFactory.createExpressionFromText(text, null)};
        }
        return PsiFileFactory.getInstance((Project)project2).createFileFromText("__dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text).getChildren();
    }

    private static boolean shouldTryExpressionPattern(List<PsiElement> elements) {
        PsiElement lastChild;
        PsiElement firstElement;
        return elements.size() >= 1 && elements.size() <= 3 && (firstElement = elements.get(0)) instanceof PsiDeclarationStatement && (lastChild = firstElement.getLastChild()) instanceof PsiErrorElement && PsiTreeUtil.prevLeaf((PsiElement)lastChild) instanceof PsiErrorElement;
    }

    private static boolean shouldTryClassPattern(List<PsiElement> elements) {
        if (elements.size() < 2) {
            return false;
        }
        PsiElement firstElement = elements.get(0);
        PsiElement secondElement = elements.get(1);
        PsiElement lastElement = elements.get(elements.size() - 1);
        if (firstElement instanceof PsiDocComment) {
            return true;
        }
        if (firstElement instanceof PsiDeclarationStatement && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiErrorElement && secondElement instanceof PsiExpressionStatement && PsiTreeUtil.lastChild((PsiElement)secondElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiSwitchLabelStatement && ((PsiSwitchLabelStatement)firstElement).isDefaultCase() && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement && secondElement instanceof PsiDeclarationStatement) {
            return true;
        }
        return firstElement instanceof PsiExpressionStatement && firstElement.getFirstChild() instanceof PsiMethodCallExpression && firstElement.getLastChild() instanceof PsiErrorElement && lastElement instanceof PsiBlockStatement;
    }

    @Override
    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaCodeContextType.class;
    }

    @Override
    @NotNull
    public PsiCodeFragment createCodeFragment(Project project2, String text, PsiElement context) {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project2);
        return factory.createCodeBlockCodeFragment(text, context, true);
    }

    @Override
    public void checkSearchPattern(CompiledPattern pattern) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        if (pattern.getNodeCount() == 1 && (nodes.current() instanceof PsiExpressionStatement || nodes.current() instanceof PsiDeclarationStatement)) {
            visitor.setCurrent(nodes.current());
        }
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
        MatchOptions matchOptions = options.getMatchOptions();
        FileType fileType = matchOptions.getFileType();
        PsiElement[] statements = this.createPatternTree(matchOptions.getSearchPattern(), PatternTreeContext.Block, fileType, project2, false);
        boolean searchIsExpression = statements.length == 1 && statements[0].getLastChild() instanceof PsiErrorElement;
        PsiElement[] statements2 = this.createPatternTree(options.getReplacement(), PatternTreeContext.Block, fileType, project2, false);
        boolean replaceIsExpression = statements2.length == 1 && statements2[0].getLastChild() instanceof PsiErrorElement;
        ValidatingVisitor visitor = new ValidatingVisitor();
        if (statements2.length == 1 && (statements2[0] instanceof PsiExpressionStatement || statements2[0] instanceof PsiDeclarationStatement)) {
            visitor.setCurrent(statements2[0]);
        }
        for (PsiElement statement2 : statements2) {
            statement2.accept((PsiElementVisitor)visitor);
        }
        if (searchIsExpression && statements[0].getFirstChild() instanceof PsiModifierList && statements2.length == 0) {
            return;
        }
        boolean targetFound = false;
        for (String name2 : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name2);
            if (!constraint.isPartOfSearchResults() || "__context__".equals(constraint.getName())) continue;
            targetFound = true;
            break;
        }
        if (!targetFound && searchIsExpression != replaceIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message("replacement.template.is.not.expression.error.message", new Object[0]) : SSRBundle.message("search.template.is.not.expression.error.message", new Object[0]));
        }
    }

    @Override
    public LanguageFileType getDefaultFileType(LanguageFileType currentDefaultFileType) {
        return StdFileTypes.JAVA;
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return JavaPredefinedConfigurations.createPredefinedTemplates();
    }

    @Override
    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, final ReplacementBuilder builder) {
        node.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitParameter(PsiParameter parameter) {
                super.visitParameter(parameter);
                String name2 = parameter.getName();
                String type = parameter.getType().getCanonicalText();
                if (StructuralSearchUtil.isTypedVariable(name2)) {
                    name2 = Replacer.stripTypedVariableDecoration(name2);
                    if (StructuralSearchUtil.isTypedVariable(type)) {
                        type = Replacer.stripTypedVariableDecoration(type);
                    }
                    ParameterInfo nameInfo = builder.findParameterization(name2);
                    ParameterInfo typeInfo = builder.findParameterization(type);
                    PsiElement scope = parameter.getDeclarationScope();
                    if (nameInfo != null && typeInfo != null && !(scope instanceof PsiCatchSection) && !(scope instanceof PsiForeachStatement)) {
                        nameInfo.setArgumentContext(false);
                        typeInfo.setArgumentContext(false);
                        typeInfo.setMethodParameterContext(true);
                        nameInfo.setMethodParameterContext(true);
                        typeInfo.setElement((PsiElement)parameter.getTypeElement());
                    }
                }
            }
        });
    }

    @Override
    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result, int offset, ReplacementInfo replacementInfo) {
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean forceAddingNewLine = false;
            if (info.isMethodParameterContext()) {
                StringBuilder buf = new StringBuilder();
                JavaStructuralSearchProfile.handleMethodParameter(buf, info, replacementInfo);
                replacementString = buf.toString();
            } else if (match.hasChildren() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                MatchResult previous = null;
                boolean stripSemicolon = false;
                for (MatchResult matchResult : match.getChildren()) {
                    PsiElement currentElement = matchResult.getMatch();
                    boolean bl = stripSemicolon = !(currentElement instanceof PsiField);
                    if (previous != null) {
                        PsiElement prevSibling;
                        PsiElement parent = currentElement.getParent();
                        if (parent instanceof PsiVariable) {
                            prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)parent);
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            }
                        } else if (info.isStatementContext()) {
                            prevSibling = currentElement.getPrevSibling();
                            if (prevSibling instanceof PsiWhiteSpace && prevSibling.getPrevSibling() == previous.getMatch()) {
                                buf.append(prevSibling.getText());
                            } else {
                                buf.append('\n');
                            }
                        } else if (info.isArgumentContext()) {
                            buf.append(',');
                        } else if (parent instanceof PsiClass) {
                            prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)currentElement);
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            } else {
                                buf.append('\n');
                            }
                        } else if (parent instanceof PsiReferenceList) {
                            buf.append(',');
                        } else if (parent instanceof PsiPolyadicExpression) {
                            PsiPolyadicExpression expression = (PsiPolyadicExpression)parent;
                            PsiJavaToken token = expression.getTokenBeforeOperand(expression.getOperands()[1]);
                            if (token != null) {
                                buf.append(token.getText());
                            }
                        } else {
                            buf.append(' ');
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    forceAddingNewLine = currentElement instanceof PsiComment;
                    previous = matchResult;
                }
                replacementString = stripSemicolon ? StringUtil.trimEnd((String)buf.toString(), (char)';') : buf.toString();
            } else {
                PsiElement matchElement = match.getMatch();
                if (info.isStatementContext()) {
                    forceAddingNewLine = matchElement instanceof PsiComment;
                }
                String matchImage = match.getMatchImage();
                replacementString = !(matchElement instanceof PsiField) ? StringUtil.trimEnd((String)matchImage, (char)';') : matchImage;
            }
            offset = Replacer.insertSubstitution(result, offset, info, replacementString);
            offset = JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, match);
            if (forceAddingNewLine && info.isStatementContext()) {
                result.insert(info.getStartIndex() + offset + 1, '\n');
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result) {
        PsiElement element = info.getElement();
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (prevSibling instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(prevSibling)) {
            int start = info.getBeforeDelimiterPos() + offset - (prevSibling.getTextLength() - 1);
            int end = info.getStartIndex() + offset;
            result.delete(start, end);
            return offset - (end - start);
        }
        PsiElement nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        if (JavaStructuralSearchProfile.isRemovableToken(nextSibling)) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + nextSibling.getTextLength() + offset;
            result.delete(start, end);
            return offset - 1;
        }
        if (element instanceof PsiTypeElement && nextSibling instanceof PsiIdentifier) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + offset;
            result.delete(start, end);
            return offset - 1;
        }
        if (element == null || !(element.getParent() instanceof PsiForStatement)) {
            return JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, null);
        }
        return offset;
    }

    private static boolean isRemovableToken(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnnotationParameterList || parent instanceof PsiAssertStatement || parent instanceof PsiExpressionList || parent instanceof PsiParameterList || parent instanceof PsiPolyadicExpression || parent instanceof PsiReferenceExpression || parent instanceof PsiReferenceList || parent instanceof PsiReferenceParameterList || parent instanceof PsiResourceList || parent instanceof PsiTypeParameterList || parent instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return false;
        }
        String text = element.getText();
        if (text.length() != 1) {
            return true;
        }
        switch (text.charAt(0)) {
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof PsiIdentifier;
    }

    @Override
    @NotNull
    public Collection<String> getReservedWords() {
        return Collections.singleton("packageLocal");
    }

    @Override
    public boolean isDocCommentOwner(PsiElement match) {
        return match instanceof PsiMember;
    }

    private static void handleMethodParameter(StringBuilder buf, ParameterInfo info, ReplacementInfo replacementInfo) {
        if (!(info.getElement() instanceof PsiTypeElement)) {
            return;
        }
        String name2 = ((PsiParameter)info.getElement().getParent()).getName();
        name2 = StructuralSearchUtil.isTypedVariable(name2) ? Replacer.stripTypedVariableDecoration(name2) : name2;
        MatchResult matchResult = replacementInfo.getNamedMatchResult(name2);
        if (matchResult == null) {
            return;
        }
        if (matchResult.isMultipleMatch()) {
            for (MatchResult result : matchResult.getChildren()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                JavaStructuralSearchProfile.appendParameter(buf, result);
            }
        } else {
            JavaStructuralSearchProfile.appendParameter(buf, matchResult);
        }
    }

    private static void appendParameter(StringBuilder buf, MatchResult matchResult) {
        List<MatchResult> sons = matchResult.getChildren();
        assert (sons.size() == 1);
        buf.append(sons.get(0).getMatchImage()).append(' ').append(matchResult.getMatchImage());
    }

    private static int removeExtraSemicolon(ParameterInfo info, int offset, StringBuilder result, MatchResult match) {
        if (info.isStatementContext()) {
            PsiElement matchElement;
            int index = offset + info.getStartIndex();
            PsiElement psiElement = matchElement = match == null ? null : match.getMatch();
            if (result.charAt(index) == ';' && (matchElement == null || result.charAt(index - 1) == '}' && !(matchElement instanceof PsiDeclarationStatement) && !(matchElement instanceof PsiNewExpression) && !(matchElement instanceof PsiArrayInitializerExpression) || (match.isMultipleMatch() ? match.getChildren().get(match.getChildren().size() - 1).getMatch() instanceof PsiComment : matchElement instanceof PsiComment))) {
                result.deleteCharAt(index);
                --offset;
            }
        }
        return offset;
    }

    @Override
    public boolean isApplicableConstraint(String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        switch (constraintName) {
            case "TEXT": {
                return !completePattern;
            }
            case "TEXT HIERARCHY": {
                if (variableNode != null) {
                    PsiElement parent = variableNode.getParent();
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        PsiElement grandParent = parent.getParent();
                        if (grandParent instanceof PsiTypeElement || grandParent instanceof PsiReferenceList || grandParent instanceof PsiReferenceExpression || grandParent instanceof PsiNewExpression || grandParent instanceof PsiAnonymousClass) {
                            return true;
                        }
                    } else {
                        if (parent instanceof PsiClass) {
                            return true;
                        }
                        if (JavaStructuralSearchProfile.isMemberSurroundedByClass(parent)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            case "EXPECTED TYPE": {
                PsiElement grandParent;
                if (variableNode != null && ((grandParent = variableNode.getParent().getParent()) instanceof PsiExpressionStatement ? JavaStructuralSearchProfile.hasSemicolon(grandParent) : grandParent instanceof PsiStatement)) {
                    return false;
                }
            }
            case "TYPE": {
                PsiElement child;
                if (variableNode instanceof PsiExpressionStatement && (child = variableNode.getLastChild()) instanceof PsiErrorElement) {
                    PsiErrorElement errorElement = (PsiErrorElement)child;
                    return "';' expected".equals(errorElement.getErrorDescription());
                }
                return variableNode != null && variableNode.getParent() instanceof PsiExpression;
            }
            case "MINIMUM ZERO": {
                if (target || variableNode == null) {
                    return false;
                }
                return JavaStructuralSearchProfile.isApplicableMinCount(variableNode) || JavaStructuralSearchProfile.isApplicableMinMaxCount(variableNode);
            }
            case "MAXIMUM UNLIMITED": {
                if (variableNode == null) {
                    return false;
                }
                return JavaStructuralSearchProfile.isApplicableMaxCount(variableNode) || JavaStructuralSearchProfile.isApplicableMinMaxCount(variableNode);
            }
            case "REFERENCE": {
                if (completePattern || variableNode == null) {
                    return false;
                }
                if (variableNode instanceof PsiLiteralExpression && ((PsiLiteralExpression)variableNode).getValue() instanceof String) {
                    return true;
                }
                PsiElement parent = variableNode.getParent();
                return parent instanceof PsiJavaCodeReferenceElement;
            }
        }
        return super.isApplicableConstraint(constraintName, variableNode, completePattern, target);
    }

    private static boolean isApplicableMinCount(@NotNull PsiElement variableNode) {
        PsiElement greatGrandParent;
        PsiElement label;
        PsiElement parent = variableNode.getParent();
        if (parent instanceof PsiContinueStatement) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiReferenceList) {
            return true;
        }
        if (grandParent instanceof PsiPolyadicExpression) {
            return ((PsiPolyadicExpression)grandParent).getOperands().length > 2;
        }
        if (parent instanceof PsiReferenceExpression) {
            if (grandParent instanceof PsiReferenceExpression) {
                return true;
            }
            if (grandParent instanceof PsiReturnStatement) {
                return true;
            }
            if (grandParent instanceof PsiAssertStatement) {
                return ((PsiAssertStatement)grandParent).getAssertDescription() == parent;
            }
            if (grandParent instanceof PsiNameValuePair) {
                return ((PsiNameValuePair)grandParent).getValue() == parent;
            }
            if (grandParent instanceof PsiBreakStatement) {
                return true;
            }
            if (grandParent instanceof PsiForStatement) {
                return true;
            }
        }
        if (grandParent instanceof PsiExpressionList && (label = grandParent.getParent()) instanceof PsiSwitchLabelStatementBase) {
            return ((PsiSwitchLabelStatementBase)label).getEnclosingSwitchStatement() != null;
        }
        if (grandParent instanceof PsiVariable) {
            return ((PsiVariable)grandParent).getInitializer() == parent;
        }
        if (grandParent instanceof PsiNewExpression) {
            return ((PsiNewExpression)grandParent).getArrayInitializer() != null;
        }
        if (grandParent instanceof PsiTypeElement && (greatGrandParent = grandParent.getParent()) instanceof PsiTypeElement) {
            PsiType type = ((PsiTypeElement)greatGrandParent).getType();
            return type instanceof PsiWildcardType && ((PsiWildcardType)type).isExtends();
        }
        if (grandParent instanceof PsiExpressionStatement) {
            greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiForStatement && !PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)greatGrandParent).getBody(), (PsiElement)variableNode, (boolean)true)) {
                return true;
            }
            if (JavaStructuralSearchProfile.hasSemicolon(grandParent)) {
                if (greatGrandParent instanceof PsiLoopStatement || greatGrandParent instanceof PsiIfStatement) {
                    return false;
                }
                return !(greatGrandParent instanceof PsiCodeBlock) || !(greatGrandParent.getParent() instanceof JavaDummyHolder) || PsiTreeUtil.getChildrenOfAnyType((PsiElement)greatGrandParent, (Class[])new Class[]{PsiStatement.class, PsiComment.class}).size() > 1;
            }
        }
        return false;
    }

    private static boolean isApplicableMaxCount(@NotNull PsiElement variableNode) {
        PsiElement parent = variableNode.getParent();
        if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)parent;
            if (localVariable instanceof PsiResourceVariable) {
                return false;
            }
            return !localVariable.getTypeElement().isInferredType();
        }
        if (parent instanceof PsiField) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiPolyadicExpression) {
            return true;
        }
        if (grandParent instanceof PsiExpressionList && grandParent.getParent() instanceof PsiSwitchLabelStatementBase) {
            return true;
        }
        if (grandParent instanceof PsiExpressionStatement && JavaStructuralSearchProfile.hasSemicolon(grandParent)) {
            PsiElement greatGrandParent = grandParent.getParent();
            return greatGrandParent instanceof PsiCodeBlock;
        }
        if (grandParent instanceof PsiReferenceList) {
            PsiElement greatGrandParent = grandParent.getParent();
            return !(greatGrandParent instanceof PsiClass) || ((PsiClass)greatGrandParent).getExtendsList() != grandParent || greatGrandParent instanceof PsiTypeParameter;
        }
        return false;
    }

    private static boolean isApplicableMinMaxCount(@NotNull PsiElement variableNode) {
        PsiElement greatGrandParent;
        if (variableNode instanceof PsiDocToken) {
            return true;
        }
        PsiElement parent = variableNode.getParent();
        if (JavaStructuralSearchProfile.isMemberSurroundedByClass(parent)) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiCatchSection && parent instanceof PsiParameter) {
            return true;
        }
        if (grandParent instanceof PsiAnnotation && !(grandParent.getParent().getNextSibling() instanceof PsiErrorElement)) {
            return true;
        }
        if (grandParent instanceof PsiParameterList || grandParent instanceof PsiArrayInitializerMemberValue || grandParent instanceof PsiExpressionList && !(grandParent.getParent() instanceof PsiSwitchLabelStatementBase) || grandParent instanceof PsiTypeParameterList || grandParent instanceof PsiResourceList || grandParent instanceof PsiResourceExpression || grandParent instanceof PsiArrayInitializerExpression) {
            return true;
        }
        if (grandParent instanceof PsiTypeElement && ((greatGrandParent = grandParent.getParent()) instanceof PsiReferenceParameterList || greatGrandParent instanceof PsiClass)) {
            return true;
        }
        if (grandParent instanceof PsiAnnotationParameterList && parent instanceof PsiNameValuePair) {
            return ((PsiNameValuePair)parent).getNameIdentifier() == variableNode;
        }
        return false;
    }

    private static boolean isMemberSurroundedByClass(PsiElement parent) {
        if (!(parent instanceof PsiMember) || parent instanceof PsiTypeParameter) {
            return false;
        }
        PsiMember member = (PsiMember)parent;
        PsiClass aClass = member.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String name2 = aClass.getName();
        return name2 != null && !"_Dummy_".equals(name2);
    }

    private static boolean hasSemicolon(PsiElement element) {
        PsiElement lastChild = element.getLastChild();
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            lastChild = lastChild.getPrevSibling();
        }
        return PsiUtil.isJavaToken((PsiElement)lastChild, (IElementType)JavaTokenType.SEMICOLON);
    }

    static class ValidatingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiElement myCurrent;

        ValidatingVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null || !nameReferenceElement.getText().equals("Modifier")) {
                return;
            }
            for (PsiNameValuePair pair2 : annotation.getParameterList().getAttributes()) {
                for (PsiAnnotationMemberValue v : AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)pair2.getValue())) {
                    ValidatingVisitor.checkModifier(StringUtil.unquoteString((String)v.getText()));
                }
            }
        }

        private static void checkModifier(String name2) {
            if (!"Instance".equals(name2) && !"packageLocal".equals(name2) && ArrayUtil.find((Object[])JavaMatchingVisitor.MODIFIERS, (Object)name2) < 0) {
                throw new MalformedPatternException(SSRBundle.message("invalid.modifier.type", name2));
            }
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            PsiElement parent = element.getParent();
            String errorDescription = element.getErrorDescription();
            if (parent instanceof PsiClass && "Identifier expected".equals(errorDescription)) {
                return;
            }
            if (parent instanceof PsiTryStatement && "'catch' or 'finally' expected".equals(errorDescription)) {
                return;
            }
            if (parent == this.myCurrent) {
                if ("';' expected".equals(errorDescription) && element.getNextSibling() == null) {
                    return;
                }
                if ("Identifier or type expected".equals(errorDescription)) {
                    return;
                }
                if ("Identifier expected".equals(errorDescription)) {
                    return;
                }
            }
            throw new MalformedPatternException(errorDescription);
        }

        void setCurrent(PsiElement current) {
            this.myCurrent = current;
        }
    }
}

