/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.StringToConstraintsTransformer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MatchOptions
implements JDOMExternalizable {
    private final Map<String, MatchVariableConstraint> variableConstraints;
    private boolean looseMatching;
    private boolean recursiveSearch;
    private boolean caseSensitiveMatch;
    private FileType myFileType;
    private Language myDialect;
    private SearchScope scope;
    private Scopes.Type scopeType;
    private String scopeDescriptor;
    @NotNull
    private String pattern;
    private String myPatternContext;
    @NonNls
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    @NonNls
    private static final String LOOSE_MATCHING_ATTRIBUTE_NAME = "loose";
    @NonNls
    private static final String RECURSIVE_ATTRIBUTE_NAME = "recursive";
    @NonNls
    private static final String CASESENSITIVE_ATTRIBUTE_NAME = "caseInsensitive";
    @NonNls
    private static final String CONSTRAINT_TAG_NAME = "constraint";
    @NonNls
    private static final String FILE_TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String DIALECT_ATTR_NAME = "dialect";
    @NonNls
    private static final String SCOPE_TYPE = "scope_type";
    @NonNls
    private static final String SCOPE_DESCRIPTOR = "scope_descriptor";
    @NonNls
    public static final String INSTANCE_MODIFIER_NAME = "Instance";
    @NonNls
    public static final String MODIFIER_ANNOTATION_NAME = "Modifier";

    public MatchOptions() {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>();
        this.looseMatching = true;
        this.myFileType = null;
        this.myDialect = null;
        this.pattern = "";
    }

    MatchOptions(MatchOptions options) {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>(options.variableConstraints.size());
        options.variableConstraints.forEach((key, value) -> this.variableConstraints.put((String)key, value.copy()));
        this.looseMatching = options.looseMatching;
        this.recursiveSearch = options.recursiveSearch;
        this.caseSensitiveMatch = options.caseSensitiveMatch;
        this.myFileType = options.myFileType;
        this.myDialect = options.myDialect;
        this.scope = options.scope;
        this.scopeType = options.scopeType;
        this.scopeDescriptor = options.scopeDescriptor;
        this.pattern = options.pattern;
        this.myPatternContext = options.myPatternContext;
    }

    public MatchOptions copy() {
        return new MatchOptions(this);
    }

    public void initScope(Project project2) {
        if (this.scope == null && this.scopeType != null && this.scopeDescriptor != null) {
            this.scope = Scopes.createScope(project2, this.scopeDescriptor, this.scopeType);
        }
    }

    public void addVariableConstraint(@NotNull MatchVariableConstraint constraint) {
        this.variableConstraints.put(constraint.getName(), constraint);
    }

    public Set<String> getUsedVariableNames() {
        LinkedHashSet set = TemplateImplUtil.parseVariableNames((CharSequence)this.pattern);
        set.add("__context__");
        return set;
    }

    public void removeUnusedVariables() {
        Set<String> nameSet = this.getUsedVariableNames();
        Iterator<String> iterator2 = this.variableConstraints.keySet().iterator();
        while (iterator2.hasNext()) {
            String key = iterator2.next();
            if (nameSet.contains(key)) continue;
            iterator2.remove();
        }
    }

    public MatchVariableConstraint getVariableConstraint(String name2) {
        return this.variableConstraints.get(name2);
    }

    public Set<String> getVariableConstraintNames() {
        return Collections.unmodifiableSet(this.variableConstraints.keySet());
    }

    public void setCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
    }

    public boolean isCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    public String toString() {
        return "match options:\npattern:\n" + this.pattern + "\nscope:\n" + (this.scope != null ? this.scope.toString() : "undefined scope") + "\nrecursive: " + this.recursiveSearch + "\ncase sensitive: " + this.caseSensitiveMatch + "\nloose: " + this.looseMatching;
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean recursiveSearch) {
        this.recursiveSearch = recursiveSearch;
    }

    public boolean isLooseMatching() {
        return this.looseMatching;
    }

    public void setLooseMatching(boolean looseMatching) {
        this.looseMatching = looseMatching;
    }

    public void setSearchPattern(@NotNull String text) {
        this.pattern = text;
    }

    @NotNull
    public String getSearchPattern() {
        return this.pattern;
    }

    public void fillSearchCriteria(String criteria) {
        if (!this.variableConstraints.isEmpty()) {
            this.variableConstraints.clear();
        }
        StringToConstraintsTransformer.transformCriteria(criteria, this);
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public void writeExternal(Element element) {
        element.setAttribute(TEXT_ATTRIBUTE_NAME, this.pattern);
        if (!this.looseMatching) {
            element.setAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME, String.valueOf(false));
        }
        element.setAttribute(RECURSIVE_ATTRIBUTE_NAME, String.valueOf(this.recursiveSearch));
        element.setAttribute(CASESENSITIVE_ATTRIBUTE_NAME, String.valueOf(this.caseSensitiveMatch));
        if (this.myFileType != null) {
            element.setAttribute(FILE_TYPE_ATTR_NAME, this.myFileType.getName());
        }
        if (this.myDialect != null) {
            element.setAttribute(DIALECT_ATTR_NAME, this.myDialect.getID());
        }
        if (this.scope != null) {
            element.setAttribute(SCOPE_TYPE, Scopes.getType(this.scope).toString()).setAttribute(SCOPE_DESCRIPTOR, Scopes.getDescriptor(this.scope));
        }
        Set<String> constraintNames = this.getUsedVariableNames();
        for (MatchVariableConstraint matchVariableConstraint : this.variableConstraints.values()) {
            if (matchVariableConstraint.isArtificial() || !constraintNames.contains(matchVariableConstraint.getName())) continue;
            Element infoElement = new Element(CONSTRAINT_TAG_NAME);
            element.addContent(infoElement);
            matchVariableConstraint.writeExternal(infoElement);
        }
    }

    public void readExternal(Element element) {
        this.pattern = StringUtil.notNullize((String)element.getAttribute(TEXT_ATTRIBUTE_NAME).getValue());
        Attribute attr = element.getAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME);
        if (attr != null) {
            try {
                this.looseMatching = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {}
        } else {
            this.looseMatching = true;
        }
        if ((attr = element.getAttribute(RECURSIVE_ATTRIBUTE_NAME)) != null) {
            try {
                this.recursiveSearch = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(CASESENSITIVE_ATTRIBUTE_NAME)) != null) {
            try {
                this.caseSensitiveMatch = attr.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(FILE_TYPE_ATTR_NAME)) != null) {
            this.myFileType = MatchOptions.getFileTypeByName(attr.getValue());
        }
        if ((attr = element.getAttribute(DIALECT_ATTR_NAME)) != null) {
            this.myDialect = Language.findLanguageByID((String)attr.getValue());
        }
        if ((attr = element.getAttribute(SCOPE_TYPE)) != null) {
            this.scopeType = Scopes.Type.valueOf(attr.getValue());
        }
        if ((attr = element.getAttribute(SCOPE_DESCRIPTOR)) != null) {
            this.scopeDescriptor = attr.getValue();
        }
        for (Element element1 : element.getChildren(CONSTRAINT_TAG_NAME)) {
            MatchVariableConstraint constraint = new MatchVariableConstraint();
            constraint.readExternal(element1);
            this.addVariableConstraint(constraint);
        }
    }

    private static FileType getFileTypeByName(String value) {
        if (value != null) {
            for (FileType type : StructuralSearchUtil.getSuitableFileTypes()) {
                if (!value.equals(type.getName())) continue;
                return type;
            }
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchOptions)) {
            return false;
        }
        MatchOptions matchOptions = (MatchOptions)o;
        if (this.caseSensitiveMatch != matchOptions.caseSensitiveMatch) {
            return false;
        }
        if (this.looseMatching != matchOptions.looseMatching) {
            return false;
        }
        if (this.recursiveSearch != matchOptions.recursiveSearch) {
            return false;
        }
        if (!Objects.equals(this.scope, matchOptions.scope)) {
            return false;
        }
        if (!this.pattern.equals(matchOptions.pattern)) {
            return false;
        }
        if (!this.variableConstraints.equals(matchOptions.variableConstraints)) {
            return false;
        }
        if (this.myFileType != matchOptions.myFileType) {
            return false;
        }
        if (!Objects.equals(this.myDialect, matchOptions.myDialect)) {
            return false;
        }
        return Objects.equals(this.myPatternContext, matchOptions.myPatternContext);
    }

    public int hashCode() {
        int result = this.looseMatching ? 1 : 0;
        result = 29 * result + (this.recursiveSearch ? 1 : 0);
        result = 29 * result + (this.caseSensitiveMatch ? 1 : 0);
        result = 29 * result + this.pattern.hashCode();
        result = 29 * result + this.variableConstraints.hashCode();
        if (this.scope != null) {
            result = 29 * result + this.scope.hashCode();
        }
        if (this.myFileType != null) {
            result = 29 * result + this.myFileType.hashCode();
        }
        if (this.myDialect != null) {
            result = 29 * result + this.myDialect.hashCode();
        }
        return result;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public FileType getFileType() {
        if (this.myFileType == null) {
            this.myFileType = StructuralSearchUtil.getDefaultFileType();
        }
        return this.myFileType;
    }

    public Language getDialect() {
        return this.myDialect;
    }

    public void setDialect(Language dialect) {
        this.myDialect = dialect;
    }

    public String getPatternContext() {
        return this.myPatternContext;
    }

    public void setPatternContext(String patternContext) {
        this.myPatternContext = patternContext;
    }
}

