/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchTemplateBuilder {
    private final TemplateBuilder myBuilder;
    private final PsiFile myPsiFile;
    private final PlaceholderCount myClassCount = new PlaceholderCount("Class");
    private final PlaceholderCount myVarCount = new PlaceholderCount("Var");
    private final PlaceholderCount myFunCount = new PlaceholderCount("Fun");
    private int myShift;

    public StructuralSearchTemplateBuilder(@NotNull PsiFile psiFile) {
        this.myBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)psiFile);
        this.myPsiFile = psiFile;
    }

    public TemplateBuilder buildTemplate() {
        JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){

            public void visitIdentifier(PsiIdentifier identifier) {
                PsiElement parent = identifier.getParent();
                if (parent instanceof PsiClass) {
                    StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myClassCount, true);
                } else if (parent instanceof PsiReferenceExpression) {
                    if (parent.getParent() instanceof PsiMethodCallExpression) {
                        StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myFunCount, true);
                    } else {
                        StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myVarCount, false);
                    }
                } else if (parent instanceof PsiJavaCodeReferenceElement) {
                    StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myClassCount, false);
                }
            }

            public void visitReferenceList(PsiReferenceList list) {
                PsiJavaCodeReferenceElement[] elements;
                for (PsiJavaCodeReferenceElement element : elements = list.getReferenceElements()) {
                    StructuralSearchTemplateBuilder.this.replaceElement(element.getReferenceNameElement(), StructuralSearchTemplateBuilder.this.myClassCount, false);
                }
            }
        };
        MatchOptions matchOptions = new MatchOptions();
        String text = this.myPsiFile.getText();
        matchOptions.setSearchPattern(text);
        Object[] elements = MatcherImplUtil.createTreeFromText(text, PatternTreeContext.Block, this.myPsiFile.getFileType(), this.myPsiFile.getProject());
        PsiElement psiElement = (PsiElement)ContainerUtil.find((Object[])elements, element -> !(element instanceof PsiWhiteSpace));
        if (psiElement != null) {
            this.myShift = 2;
            psiElement.accept((PsiElementVisitor)visitor);
        }
        return this.myBuilder;
    }

    void replaceElement(@Nullable PsiElement element, PlaceholderCount count, boolean preferOriginal) {
        if (element == null) {
            return;
        }
        this.myBuilder.replaceRange(element.getTextRange().shiftLeft(this.myShift), (Expression)new MyExpression(count.getPlaceholder(), element, preferOriginal));
    }

    private static class PlaceholderCount {
        private final String myName;
        private int myCount;

        private PlaceholderCount(String name2) {
            this.myName = name2;
        }

        public String getPlaceholder() {
            return "$" + this.myName + ++this.myCount + "$";
        }
    }

    private static class MyExpression
    extends Expression {
        private final String myPlaceholder;
        private final String myOriginalText;
        private final boolean myPreferOriginal;

        MyExpression(String placeholder, PsiElement original, boolean preferOriginal) {
            this.myPlaceholder = placeholder;
            this.myOriginalText = original.getText();
            this.myPreferOriginal = preferOriginal;
        }

        @Nullable
        public Result calculateResult(ExpressionContext context) {
            return new TextResult(this.myPreferOriginal ? this.myOriginalText : this.myPlaceholder);
        }

        @Nullable
        public Result calculateQuickResult(ExpressionContext context) {
            return this.calculateResult(context);
        }

        @Nullable
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            Object[] elements = new LookupElement[]{LookupElementBuilder.create((String)this.myPlaceholder), LookupElementBuilder.create((String)this.myOriginalText)};
            return this.myPreferOriginal ? (LookupElement[])ArrayUtil.reverseArray((Object[])elements) : elements;
        }
    }
}

