/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchUtil {
    private static final String REG_EXP_META_CHARS = ".$|()[]{}^?*+\\";
    private static final Key<StructuralSearchProfile> STRUCTURAL_SEARCH_PROFILE_KEY = new Key("Structural Search Profile");
    private static final Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static LanguageFileType ourDefaultFileType = null;
    public static boolean ourUseUniversalMatchingAlgorithm = false;
    private static StructuralSearchProfile[] ourNewStyleProfiles;
    private static List<Configuration> ourPredefinedConfigurations;

    private StructuralSearchUtil() {
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile2 != null && profile2.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile2 == null ? element : profile2.getPresentableElement(element);
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        if (ourNewStyleProfiles == null) {
            ArrayList<StructuralSearchProfile> list = new ArrayList<StructuralSearchProfile>();
            for (StructuralSearchProfile profile2 : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
                if (!(profile2 instanceof StructuralSearchProfileBase)) continue;
                list.add(profile2);
            }
            list.add(new XmlStructuralSearchProfile());
            ourNewStyleProfiles = list.toArray(new StructuralSearchProfile[0]);
        }
        return ourNewStyleProfiles;
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    public static FileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile2.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = StdFileTypes.XML;
            }
        }
        return ourDefaultFileType;
    }

    public static void clearProfileCache(@NotNull Language language) {
        language.putUserData(STRUCTURAL_SEARCH_PROFILE_KEY, null);
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        StructuralSearchProfile cachedProfile = (StructuralSearchProfile)language.getUserData(STRUCTURAL_SEARCH_PROFILE_KEY);
        if (cachedProfile != null) {
            return cachedProfile;
        }
        for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
            if (!profile2.isMyLanguage(language)) continue;
            language.putUserData(STRUCTURAL_SEARCH_PROFILE_KEY, (Object)profile2);
            return profile2;
        }
        return null;
    }

    public static boolean isTypedVariable(@NotNull String name2) {
        return name2.length() > 1 && name2.charAt(0) == '$' && name2.charAt(name2.length() - 1) == '$';
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        LanguageFileType languageFileType = (LanguageFileType)fileType;
        return StructuralSearchUtil.getProfileByLanguage(languageFileType.getLanguage());
    }

    @NotNull
    public static FileType[] getSuitableFileTypes() {
        HashSet<LanguageFileType> allFileTypes = new HashSet<LanguageFileType>();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        ArrayList<LanguageFileType> result = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : allFileTypes) {
            if (!(fileType instanceof LanguageFileType)) continue;
            result.add(fileType);
        }
        return result.toArray(FileType.EMPTY_ARRAY);
    }

    public static boolean containsRegExpMetaChar(String s) {
        return s.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch) {
        return REG_EXP_META_CHARS.indexOf(ch) >= 0;
    }

    public static String shieldRegExpMetaChars(String word) {
        return StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i))) {
                out.append("\\");
            }
            out.append(word.charAt(i));
        }
        return out;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result = new ArrayList();
            for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result, profile2.getPredefinedTemplates());
            }
            Collections.sort(result);
            ourPredefinedConfigurations = Collections.unmodifiableList(result);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(match);
        return profile2 != null && profile2.isDocCommentOwner(match);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile2 != null ? profile2.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(PsiElement matchedNode, String previousText) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile2 != null ? profile2.getAlternativeText(matchedNode, previousText) : null;
    }

    public static String normalizeWhiteSpace(@NotNull String text) {
        text = text.trim();
        StringBuilder result = new StringBuilder();
        boolean white = false;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (StringUtil.isWhiteSpace((char)c)) {
                if (white) continue;
                result.append(' ');
                white = true;
                continue;
            }
            white = false;
            result.append(c);
        }
        return result.toString();
    }

    public static String stripAccents(@NotNull String input) {
        return ACCENTS.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
    }

    public static String normalize(@NotNull String text) {
        return StructuralSearchUtil.stripAccents(StructuralSearchUtil.normalizeWhiteSpace(text));
    }

    static {
        ourPredefinedConfigurations = null;
    }
}

