/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.XmlCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.XmlCompilingVisitor;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructuralSearchProfile
extends StructuralSearchProfile {
    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        new XmlCompilingVisitor(globalVisitor).compile(elements);
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        return new XmlMatchingVisitor(globalVisitor);
    }

    @Override
    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME;
    }

    @Override
    @NotNull
    public String getTypedVarString(PsiElement element) {
        return element instanceof XmlText ? element.getText().trim() : super.getTypedVarString(element);
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        return element -> {
            if (element instanceof XmlText) {
                PsiElement child = element.getFirstChild();
                return child == element.getLastChild() && child instanceof PsiWhiteSpace;
            }
            return element instanceof PsiWhiteSpace || element instanceof PsiErrorElement;
        };
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new XmlCompiledPattern();
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        return language instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String text1 = context == PatternTreeContext.File ? text : "<QQQ>" + text + "</QQQ>";
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)project2).createFileFromText("dummy." + ext, fileType, (CharSequence)text1, LocalTimeCounter.currentTime(), physical, true);
        XmlDocument document2 = HtmlUtil.getRealXmlDocument((XmlDocument)((XmlFile)fileFromText).getDocument());
        if (context == PatternTreeContext.File) {
            return new PsiElement[]{document2};
        }
        return document2.getRootTag().getValue().getChildren();
    }

    @Override
    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return XmlContextType.class;
    }

    @Override
    @NotNull
    public FileType detectFileType(@NotNull PsiElement context) {
        Language contextLanguage;
        PsiFile file = context instanceof PsiFile ? (PsiFile)context : context.getContainingFile();
        Language language = contextLanguage = context instanceof PsiFile ? null : context.getLanguage();
        if (file.getLanguage() == StdLanguages.HTML || file.getFileType() == StdFileTypes.JSP && contextLanguage == StdLanguages.HTML) {
            return StdFileTypes.HTML;
        }
        return StdFileTypes.XML;
    }

    @Override
    public void checkSearchPattern(CompiledPattern pattern) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        return new XmlReplaceHandler(project2, replaceOptions);
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return XmlPredefinedConfigurations.createPredefinedTemplates();
    }

    private static class XmlPredefinedConfigurations {
        private static final String HTML_XML = SSRBundle.message("xml_html.category", new Object[0]);

        private XmlPredefinedConfigurations() {
        }

        static Configuration[] createPredefinedTemplates() {
            return new Configuration[]{PredefinedConfigurationUtil.createSearchTemplateInfo("xml tag", "<'a/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute", "<'_tag 'attribute=\"'_value\"/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute", "<'_tag 'attribute />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute value", "<'_tag '_attribute=\"'value\"/>", HTML_XML, (FileType)StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute value", "<'_tag '_attribute='value />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml/html tag value", "<table>'_content*</table>", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<ul> or <ol>", "<'_tag:[regex( ul|ol )] />", HTML_XML, (FileType)StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<li> not contained in <ul> or <ol>", "[!within( \"<ul> or <ol>\" )]<li />", HTML_XML, (FileType)StdFileTypes.HTML)};
        }
    }

    private static class XmlReplaceHandler
    extends StructuralReplaceHandler {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ReplaceOptions myReplaceOptions;

        XmlReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
            this.myProject = project2;
            this.myReplaceOptions = replaceOptions;
        }

        @Override
        public void replace(ReplacementInfo info, ReplaceOptions options) {
            PsiElement elementToReplace = StructuralSearchUtil.getPresentableElement(info.getMatch(0));
            assert (elementToReplace != null);
            String replacementToMake = info.getReplacement();
            PsiElement elementParent = elementToReplace.getParent();
            boolean listContext = elementParent instanceof XmlTag;
            if (listContext) {
                this.doReplaceInContext(info, elementToReplace, replacementToMake, elementParent);
            } else {
                PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, this.myReplaceOptions.getMatchOptions().getFileType(), this.myProject);
                if (replacements.length > 0) {
                    PsiElement replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, replacements, replacementToMake, elementParent);
                    Replacer.handleComments(elementToReplace, replacement, info);
                    elementToReplace.replace(replacement);
                } else {
                    elementToReplace.delete();
                }
            }
        }

        private void doReplaceInContext(ReplacementInfo info, PsiElement elementToReplace, String replacementToMake, PsiElement elementParent) {
            PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, this.myReplaceOptions.getMatchOptions().getFileType(), this.myProject);
            if (replacements.length > 1) {
                elementParent.addRangeBefore(replacements[0], replacements[replacements.length - 1], elementToReplace);
            } else if (replacements.length == 1) {
                Replacer.handleComments(elementToReplace, replacements[0], info);
                try {
                    elementParent.addBefore(replacements[0], elementToReplace);
                }
                catch (IncorrectOperationException e) {
                    elementToReplace.replace(replacements[0]);
                }
            }
            int matchSize = info.getMatchesCount();
            for (int i = 0; i < matchSize; ++i) {
                PsiElement element = StructuralSearchUtil.getPresentableElement(info.getMatch(i));
                PsiElement prevSibling = element.getPrevSibling();
                element.getParent().deleteChildRange(XmlReplaceHandler.isWhitespace(prevSibling) ? prevSibling : element, element);
            }
        }

        private static boolean isWhitespace(PsiElement element) {
            PsiElement lastChild;
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (!(element instanceof XmlText)) {
                return false;
            }
            PsiElement firstChild = element.getFirstChild();
            return firstChild == (lastChild = element.getLastChild()) && firstChild instanceof PsiWhiteSpace;
        }
    }

    static class ValidatingVisitor
    extends PsiRecursiveElementWalkingVisitor {
        ValidatingVisitor() {
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            String errorDescription = element.getErrorDescription();
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute && "'=' expected".equals(errorDescription)) {
                return;
            }
            if (parent instanceof XmlTag && errorDescription.startsWith("Element") && errorDescription.endsWith(" is not closed")) {
                return;
            }
            throw new MalformedPatternException(errorDescription);
        }
    }
}

