/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.HierarchyNodeIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JavaMatchingVisitor
extends JavaElementVisitor {
    public static final String[] MODIFIERS = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "strictfp", "transient", "volatile", "default"};
    private final GlobalMatchingVisitor myMatchingVisitor;
    private PsiClass myClazz;

    public JavaMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    public void visitComment(PsiComment comment) {
        PsiComment comment2 = null;
        if (!(this.myMatchingVisitor.getElement() instanceof PsiComment)) {
            if (this.myMatchingVisitor.getElement() instanceof PsiMember) {
                comment2 = (PsiComment)ObjectUtils.tryCast((Object)this.myMatchingVisitor.getElement().getFirstChild(), PsiComment.class);
            }
        } else {
            comment2 = (PsiComment)this.myMatchingVisitor.getElement();
        }
        if (comment2 == null) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        MatchingHandler handler = (MatchingHandler)comment.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            IElementType tokenType = comment2.getTokenType();
            int end = comment2.getTextLength();
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            this.myMatchingVisitor.setResult(substitutionHandler.handle((PsiElement)comment2, tokenType == JavaDocTokenType.DOC_COMMENT_START ? 3 : 2, tokenType == JavaTokenType.END_OF_LINE_COMMENT ? end : end - 2, this.myMatchingVisitor.getMatchContext()));
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)comment, (PsiElement)comment2, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(StructuralSearchUtil.normalize(JavaMatchUtil.getCommentText(comment)), StructuralSearchUtil.normalize(JavaMatchUtil.getCommentText(comment2))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitModifierList(PsiModifierList list) {
        PsiModifierList list2 = (PsiModifierList)this.myMatchingVisitor.getElement();
        for (String modifier : MODIFIERS) {
            if (this.myMatchingVisitor.setResult(!list.hasModifierProperty(modifier) || list2.hasModifierProperty(modifier))) continue;
            return;
        }
        PsiAnnotation[] annotations = list.getAnnotations();
        if (annotations.length > 0) {
            HashSet<PsiAnnotation> annotationSet = new HashSet<PsiAnnotation>(Arrays.asList(annotations));
            for (PsiAnnotation annotation : annotations) {
                PsiNameValuePair[] attributes;
                PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
                if (nameReferenceElement == null || !"Modifier".equals(nameReferenceElement.getText())) continue;
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                for (PsiNameValuePair pair2 : attributes = parameterList.getAttributes()) {
                    PsiAnnotationMemberValue value = pair2.getValue();
                    if (value == null) continue;
                    if (value instanceof PsiArrayInitializerMemberValue) {
                        boolean matchedOne = false;
                        for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                            if (!JavaMatchingVisitor.annotationValueMatchesModifierList(list2, v)) continue;
                            matchedOne = true;
                            break;
                        }
                        if (matchedOne) continue;
                        this.myMatchingVisitor.setResult(false);
                        return;
                    }
                    if (JavaMatchingVisitor.annotationValueMatchesModifierList(list2, value)) continue;
                    this.myMatchingVisitor.setResult(false);
                    return;
                }
                annotationSet.remove(annotation);
            }
            if (!annotationSet.isEmpty()) {
                Object[] otherAnnotations = list2.getAnnotations();
                SmartList unmatchedElements = new SmartList(otherAnnotations);
                this.myMatchingVisitor.getMatchContext().pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitModifierList$0((List)unmatchedElements, arg_0));
                try {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotationSet.toArray(PsiAnnotation.EMPTY_ARRAY), (PsiElement[])otherAnnotations));
                    list2.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
                }
                finally {
                    this.myMatchingVisitor.getMatchContext().popMatchedElementsListener();
                }
            }
        } else {
            this.myMatchingVisitor.setResult(true);
        }
    }

    private static boolean annotationValueMatchesModifierList(PsiModifierList list2, PsiAnnotationMemberValue value) {
        String name2 = StringUtil.unquoteString((String)value.getText());
        if ("Instance".equals(name2)) {
            return !list2.hasModifierProperty("static") && !list2.hasModifierProperty("abstract") && list2.getParent() instanceof PsiMember;
        }
        return list2.hasModifierProperty(name2) && (!"packageLocal".equals(name2) || list2.getParent() instanceof PsiMember);
    }

    public void visitDocTag(PsiDocTag tag) {
        PsiDocTag tag2 = (PsiDocTag)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(tag.getNameElement());
        if (!this.myMatchingVisitor.setResult(isTypedVar || tag.getName().equals(tag2.getName()))) {
            return;
        }
        PsiDocTagValue psiDocTagValue = tag.getValueElement();
        boolean isTypedValue = false;
        if (psiDocTagValue != null) {
            PsiElement[] children = psiDocTagValue.getChildren();
            if (children.length == 1) {
                psiDocTagValue = children[0];
            }
            if ((isTypedValue = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)psiDocTagValue)) && (tag2.getValueElement() != null ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)psiDocTagValue, (PsiElement)tag2.getValueElement())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.allowsAbsenceOfMatch((PsiElement)psiDocTagValue)))) {
                return;
            }
        }
        if (!isTypedValue && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(new DocValuesIterator(tag.getFirstChild()), new DocValuesIterator(tag2.getFirstChild())))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(tag.getNameElement(), tag2.getNameElement()));
        }
    }

    public void visitDocComment(PsiDocComment comment) {
        PsiDocComment comment2;
        if (this.myMatchingVisitor.getElement() instanceof PsiDocCommentOwner) {
            comment2 = ((PsiDocCommentOwner)this.myMatchingVisitor.getElement()).getDocComment();
            if (comment2 == null) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
        } else {
            comment2 = (PsiDocComment)this.myMatchingVisitor.getElement();
            if (this.myMatchingVisitor.getElement().getParent() instanceof PsiDocCommentOwner) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
        }
        if (comment.getTags().length > 0) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])comment.getTags(), (PsiElement[])comment2.getTags()));
        } else {
            this.visitComment((PsiComment)comment);
        }
    }

    public void visitElement(PsiElement el) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(el, this.myMatchingVisitor.getElement()));
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiArrayInitializerExpression other = this.getExpression(PsiArrayInitializerExpression.class);
        if (other == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])expression.getInitializers(), (PsiElement[])other.getInitializers()));
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        PsiClassInitializer initializer2 = (PsiClassInitializer)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)initializer.getModifierList(), (PsiElement)initializer2.getModifierList()) && this.myMatchingVisitor.matchSons((PsiElement)initializer.getBody(), (PsiElement)initializer2.getBody()));
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, this.myMatchingVisitor.getElement()));
    }

    public void visitJavaToken(PsiJavaToken token) {
        PsiElement element = this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult((!(element instanceof PsiJavaToken) || token.getTokenType() == ((PsiJavaToken)element).getTokenType()) && (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)token) ? this.myMatchingVisitor.handleTypedElement((PsiElement)token, element) : this.myMatchingVisitor.matchText((PsiElement)token, element)));
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        PsiAnnotation other = (PsiAnnotation)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)annotation.getNameReferenceElement(), (PsiElement)other.getNameReferenceElement()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotation.getParameterList().getAttributes(), (PsiElement[])other.getParameterList().getAttributes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitNameValuePair(PsiNameValuePair pair2) {
        PsiNameValuePair other = (PsiNameValuePair)this.myMatchingVisitor.getElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        PsiIdentifier nameIdentifier = pair2.getNameIdentifier();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)nameIdentifier);
        if (nameIdentifier != null) {
            context.pushResult();
        }
        PsiIdentifier otherIdentifier = other.getNameIdentifier();
        try {
            PsiAnnotationMemberValue value = pair2.getValue();
            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)value, (PsiElement)other.getValue()))) {
                if (nameIdentifier != null) {
                    this.myMatchingVisitor.setResult(isTypedVar || this.myMatchingVisitor.matchText(nameIdentifier.getText(), otherIdentifier == null ? "value" : otherIdentifier.getText()));
                } else {
                    this.myMatchingVisitor.setResult(otherIdentifier == null || "value".equals(otherIdentifier.getText()));
                }
            }
        }
        finally {
            PsiIdentifier matchNode;
            if (otherIdentifier != null) {
                matchNode = otherIdentifier;
            } else {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                PsiAnnotation annotation = (PsiAnnotation)factory.createStatementFromText("@Anno(value=\"\")", (PsiElement)other).getFirstChild().getFirstChild();
                matchNode = annotation.getParameterList().getAttributes()[0].getNameIdentifier();
            }
            if (nameIdentifier != null) {
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)matchNode);
            }
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        PsiArrayInitializerMemberValue otherInitializer = (PsiArrayInitializerMemberValue)this.myMatchingVisitor.getElement();
        PsiAnnotationMemberValue[] initializers = initializer.getInitializers();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])initializers, (PsiElement[])otherInitializer.getInitializers()));
    }

    private boolean checkHierarchy(PsiMember element, PsiMember patternElement) {
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)patternElement);
        if (handler instanceof SubstitutionHandler) {
            SubstitutionHandler handler2 = (SubstitutionHandler)handler;
            if (!handler2.isSubtype()) {
                if (handler2.isStrictSubtype()) {
                    return element.getContainingClass() != this.myClazz;
                }
            } else {
                return true;
            }
        }
        return this.myClazz == null || element.getContainingClass() == this.myClazz;
    }

    public void visitField(PsiField psiField) {
        PsiDocComment comment = psiField.getDocComment();
        PsiField other = (PsiField)this.myMatchingVisitor.getElement();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)other))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.checkHierarchy((PsiMember)other, (PsiMember)psiField))) {
            return;
        }
        super.visitField(psiField);
    }

    public void visitAnonymousClass(PsiAnonymousClass clazz) {
        PsiAnonymousClass clazz2 = (PsiAnonymousClass)this.myMatchingVisitor.getElement();
        PsiJavaCodeReferenceElement classReference = clazz.getBaseClassReference();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)classReference);
        if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.match((PsiElement)clazz.getBaseClassReference(), (PsiElement)clazz2.getBaseClassReference())) && this.myMatchingVisitor.matchSons((PsiElement)clazz.getArgumentList(), (PsiElement)clazz2.getArgumentList()) && this.compareClasses((PsiClass)clazz, (PsiClass)clazz2)) && isTypedVar) {
            this.myMatchingVisitor.setResult(this.matchType((PsiElement)classReference, (PsiElement)clazz2.getBaseClassReference()));
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
        PsiLambdaExpression other = this.getExpression(PsiLambdaExpression.class);
        if (other == null) {
            return;
        }
        PsiParameterList parameterList1 = expression.getParameterList();
        if (!this.myMatchingVisitor.setResult(parameterList1.isEmpty() || this.myMatchingVisitor.matchSons((PsiElement)parameterList1, (PsiElement)other.getParameterList()))) {
            return;
        }
        PsiElement body1 = JavaMatchingVisitor.getElementToMatch(expression.getBody());
        this.myMatchingVisitor.setResult(body1 == null || this.myMatchingVisitor.matchSequentially(body1, JavaMatchingVisitor.getElementToMatch(other.getBody())));
    }

    private static PsiElement getElementToMatch(PsiElement element) {
        if (element instanceof PsiCodeBlock) {
            List list = PsiTreeUtil.getChildrenOfAnyType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiComment.class});
            if (list.isEmpty()) {
                return null;
            }
            element = (PsiElement)list.get(0);
            if (list.size() > 1) {
                return element;
            }
        }
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiReturnStatement) {
            element = ((PsiReturnStatement)element).getReturnValue();
        }
        return element;
    }

    private boolean matchInAnyOrder(PsiReferenceList elements, PsiReferenceList elements2) {
        if (elements == null) {
            return this.myMatchingVisitor.isLeftLooseMatching() || elements2 == null;
        }
        return this.myMatchingVisitor.matchInAnyOrder((PsiElement[])elements.getReferenceElements(), (PsiElement[])(elements2 != null ? elements2.getReferenceElements() : PsiElement.EMPTY_ARRAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareClasses(PsiClass clazz, PsiClass clazz2) {
        PsiClass saveClazz = this.myClazz;
        this.myClazz = clazz2;
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        JavaCompiledPattern javaPattern = (JavaCompiledPattern)context.getPattern();
        THashSet matchedElements = new THashSet();
        context.pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$compareClasses$1((Set)matchedElements, arg_0));
        try {
            PsiClassInitializer[] initializers2;
            PsiClassInitializer[] initializers;
            PsiClass[] nestedClasses;
            PsiMethod[] methods;
            PsiField[] fields;
            boolean accepted;
            boolean templateIsInterface = clazz.isInterface();
            if (templateIsInterface && !clazz2.isInterface()) {
                boolean bl = false;
                return bl;
            }
            if (templateIsInterface && clazz.isAnnotationType() && !clazz2.isAnnotationType()) {
                boolean bl = false;
                return bl;
            }
            if (clazz.isEnum() && !clazz2.isEnum()) {
                boolean bl = false;
                return bl;
            }
            if (clazz instanceof PsiTypeParameter != clazz2 instanceof PsiTypeParameter) {
                boolean bl = false;
                return bl;
            }
            if (!this.matchInAnyOrder(clazz.getExtendsList(), clazz2.getExtendsList())) {
                boolean bl = false;
                return bl;
            }
            PsiReferenceList implementsList = clazz.getImplementsList();
            if (implementsList != null && !this.matchInAnyOrder(implementsList, clazz2.getImplementsList())) {
                PsiReferenceList anotherExtendsList = clazz2.getExtendsList();
                PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
                accepted = false;
                if (referenceElements.length > 0 && anotherExtendsList != null) {
                    HierarchyNodeIterator iterator2 = new HierarchyNodeIterator((PsiElement)clazz2, true, true, false);
                    accepted = this.myMatchingVisitor.matchInAnyOrder(new ArrayBackedNodeIterator((PsiElement[])referenceElements), iterator2);
                }
                if (!accepted) {
                    boolean iterator2 = false;
                    return iterator2;
                }
            }
            if ((fields = clazz.getFields()).length > 0) {
                PsiField[] fields2;
                PsiField[] psiFieldArray = fields2 = javaPattern.isRequestsSuperFields() ? clazz2.getAllFields() : clazz2.getFields();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])fields, (PsiElement[])fields2)) {
                    accepted = false;
                    return accepted;
                }
            }
            if ((methods = clazz.getMethods()).length > 0) {
                PsiMethod[] methods2;
                PsiMethod[] psiMethodArray = methods2 = javaPattern.isRequestsSuperMethods() ? clazz2.getAllMethods() : clazz2.getMethods();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])methods, (PsiElement[])methods2)) {
                    boolean iterator2 = false;
                    return iterator2;
                }
            }
            if ((nestedClasses = clazz.getInnerClasses()).length > 0) {
                PsiClass[] nestedClasses2;
                PsiClass[] psiClassArray = nestedClasses2 = javaPattern.isRequestsSuperInners() ? clazz2.getAllInnerClasses() : clazz2.getInnerClasses();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])nestedClasses, (PsiElement[])nestedClasses2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if ((initializers = clazz.getInitializers()).length > 0 && !this.myMatchingVisitor.matchInAnyOrder((PsiElement[])initializers, (PsiElement[])(initializers2 = clazz2.getInitializers()))) {
                boolean bl = false;
                return bl;
            }
            SmartList unmatchedElements = new SmartList((Collection)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)clazz2, PsiMember.class));
            unmatchedElements.removeAll((Collection<?>)matchedElements);
            MatchingHandler unmatchedSubstitutionHandler = null;
            for (PsiElement element = clazz.getFirstChild(); element != null; element = element.getNextSibling()) {
                if (!(element instanceof PsiTypeElement) || !(element.getNextSibling() instanceof PsiErrorElement)) continue;
                unmatchedSubstitutionHandler = javaPattern.getHandler(element);
                break;
            }
            if (unmatchedSubstitutionHandler instanceof SubstitutionHandler) {
                SubstitutionHandler handler = (SubstitutionHandler)unmatchedSubstitutionHandler;
                for (PsiElement element : unmatchedElements) {
                    handler.handle(element, context);
                }
            } else {
                clazz2.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.myClazz = saveClazz;
            context.popMatchedElementsListener();
        }
    }

    private boolean matchBody(PsiElement patternElement, PsiElement matchElement) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            if (matchElement instanceof PsiBlockStatement) {
                PsiCodeBlock codeBlock = ((PsiBlockStatement)matchElement).getCodeBlock();
                if (patternElement instanceof PsiBlockStatement || codeBlock.getStatementCount() == 1) {
                    matchElement = codeBlock.getFirstChild();
                }
            }
            if (patternElement instanceof PsiBlockStatement) {
                patternElement = ((PsiBlockStatement)patternElement).getCodeBlock().getFirstChild();
            }
        }
        return this.myMatchingVisitor.matchSequentially(patternElement, matchElement);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression slice2) {
        PsiArrayAccessExpression other = this.getExpression(PsiArrayAccessExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)slice2.getArrayExpression(), (PsiElement)other.getArrayExpression()) && this.myMatchingVisitor.match((PsiElement)slice2.getIndexExpression(), (PsiElement)other.getIndexExpression()));
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        if (this.getExpression(PsiMethodReferenceExpression.class) == null) {
            return;
        }
        super.visitMethodReferenceExpression(expression);
    }

    public void visitReferenceExpression(PsiReferenceExpression reference) {
        PsiElement target;
        boolean multiMatch;
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        CompiledPattern pattern = context.getPattern();
        MatchingHandler _handler = pattern.getHandlerSimple(reference.getReferenceNameElement());
        boolean special = false;
        if (_handler == null) {
            _handler = pattern.getHandlerSimple((PsiElement)reference);
            special = reference.resolve() != null;
        }
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiExpression qualifier = reference.getQualifierExpression();
        if (_handler instanceof SubstitutionHandler && (qualifier == null || special)) {
            SubstitutionHandler handler = (SubstitutionHandler)_handler;
            if (handler.isSubtype() || handler.isStrictSubtype()) {
                if (this.myMatchingVisitor.setResult(this.checkMatchWithinHierarchy((PsiElement)reference, other, handler))) {
                    handler.addResult(other, 0, -1, this.myMatchingVisitor.getMatchContext());
                }
            } else {
                PsiElement deparenthesized = other instanceof PsiExpression && context.getOptions().isLooseMatching() ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)other)) : other;
                this.myMatchingVisitor.setResult(handler.validate(deparenthesized, 0, -1, context));
                if (this.myMatchingVisitor.getResult()) {
                    handler.addResult(other, 0, -1, context);
                }
            }
            return;
        }
        boolean bl = multiMatch = other != null && reference.getContainingFile() == other.getContainingFile();
        if (!(other instanceof PsiReferenceExpression)) {
            this.myMatchingVisitor.setResult(multiMatch && this.myMatchingVisitor.matchText((PsiElement)reference, other));
            return;
        }
        PsiReferenceExpression reference2 = (PsiReferenceExpression)other;
        PsiExpression qualifier2 = reference2.getQualifierExpression();
        if (multiMatch && (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (qualifier2 == null || qualifier2 instanceof PsiThisExpression || qualifier2 instanceof PsiSuperExpression) && (target = reference.resolve()) != null) {
            this.myMatchingVisitor.setResult(target == reference2.resolve());
            return;
        }
        if (qualifier == null && qualifier2 == null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(reference.getReferenceNameElement(), reference2.getReferenceNameElement()));
            return;
        }
        if (!(other.getParent() instanceof PsiMethodCallExpression) && qualifier != null) {
            PsiElement referenceElement = reference.getReferenceNameElement();
            PsiElement referenceElement2 = reference2.getReferenceNameElement();
            if (pattern.isTypedVar(referenceElement) ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(referenceElement, referenceElement2)) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(referenceElement, referenceElement2))) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(qualifier instanceof PsiThisExpression && qualifier2 == null || this.myMatchingVisitor.matchOptionally((PsiElement)qualifier, (PsiElement)qualifier2))) {
                return;
            }
            if (qualifier2 == null) {
                this.myMatchingVisitor.setResult(JavaMatchingVisitor.matchImplicitQualifier(qualifier, other, context));
            }
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    private static int getArrayDimensions(PsiElement element) {
        if (element == null) {
            return 0;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiType type = variable.getType();
            return type.getArrayDimensions();
        }
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            PsiType type = method.getReturnType();
            return type == null ? 0 : type.getArrayDimensions();
        }
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiType type = typeElement.getType();
            return type.getArrayDimensions();
        }
        return 0;
    }

    private static PsiTypeElement getInnermostComponentTypeElement(PsiTypeElement typeElement) {
        PsiElement child = typeElement.getFirstChild();
        while (child instanceof PsiTypeElement) {
            typeElement = (PsiTypeElement)child;
            child = typeElement.getFirstChild();
        }
        return typeElement;
    }

    private static PsiElement getInnermostComponent(PsiElement element) {
        PsiJavaCodeReferenceElement referenceElement;
        if (!(element instanceof PsiTypeElement)) {
            return element;
        }
        PsiTypeElement typeElement = (PsiTypeElement)element;
        if (typeElement.getType() instanceof PsiDisjunctionType) {
            return typeElement;
        }
        if (typeElement.isInferredType()) {
            PsiType type = typeElement.getType();
            if (type == PsiType.NULL || type instanceof PsiLambdaParameterType) {
                return typeElement;
            }
            String canonicalText = type.getCanonicalText();
            typeElement = JavaPsiFacade.getElementFactory((Project)typeElement.getProject()).createTypeElementFromText(canonicalText, (PsiElement)typeElement);
        }
        return (referenceElement = typeElement.getInnermostComponentReferenceElement()) != null ? referenceElement : JavaMatchingVisitor.getInnermostComponentTypeElement(typeElement);
    }

    private static PsiTypeElement[] getTypeParameters(PsiJavaCodeReferenceElement referenceElement, Boolean replaceDiamondWithExplicitTypes) {
        PsiReferenceParameterList referenceElementParameterList = referenceElement.getParameterList();
        if (referenceElementParameterList == null) {
            return null;
        }
        PsiTypeElement[] typeParameterElements = referenceElementParameterList.getTypeParameterElements();
        if (typeParameterElements.length != 1 || replaceDiamondWithExplicitTypes == Boolean.FALSE) {
            return typeParameterElements;
        }
        PsiType type = typeParameterElements[0].getType();
        if (!(type instanceof PsiDiamondType)) {
            return typeParameterElements;
        }
        if (replaceDiamondWithExplicitTypes == null) {
            return null;
        }
        PsiDiamondType diamondType = (PsiDiamondType)type;
        PsiDiamondType.DiamondInferenceResult inferenceResult = diamondType.resolveInferredTypes();
        StringBuilder text = new StringBuilder(referenceElement.getQualifiedName());
        text.append('<');
        boolean comma = false;
        for (PsiType inferredType : inferenceResult.getInferredTypes()) {
            if (comma) {
                text.append(',');
            } else {
                comma = true;
            }
            text.append(inferredType.getCanonicalText());
        }
        text.append('>');
        PsiJavaCodeReferenceElement newReferenceElement = JavaPsiFacade.getElementFactory((Project)referenceElement.getProject()).createReferenceFromText(text.toString(), (PsiElement)referenceElement);
        PsiReferenceParameterList newParameterList = newReferenceElement.getParameterList();
        return newParameterList == null ? null : newParameterList.getTypeParameterElements();
    }

    private Boolean shouldReplaceDiamondWithExplicitTypes(PsiElement element) {
        SubstitutionHandler substitutionHandler;
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return Boolean.TRUE;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
        PsiReferenceParameterList parameterList = javaCodeReferenceElement.getParameterList();
        if (parameterList == null) {
            return Boolean.TRUE;
        }
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        if (elements.length != 1) {
            return Boolean.TRUE;
        }
        PsiTypeElement typeElement = elements[0];
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)typeElement);
        if (handler instanceof SubstitutionHandler && (substitutionHandler = (SubstitutionHandler)handler).getMinOccurs() > 0) {
            return null;
        }
        return !(typeElement.getType() instanceof PsiDiamondType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchType(PsiElement patternType, PsiElement matchedType) {
        boolean caseSensitive;
        String text2;
        String text;
        boolean equalsIgnorePackage;
        PsiElement parent;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement patternElement = JavaMatchingVisitor.getInnermostComponent(patternType);
        PsiElement matchedElement = patternElement instanceof PsiTypeElement && ((PsiTypeElement)patternElement).isInferredType() ? matchedType : JavaMatchingVisitor.getInnermostComponent(matchedType);
        PsiTypeElement[] typeParameters = null;
        if (matchedElement instanceof PsiJavaCodeReferenceElement) {
            referenceElement = (PsiJavaCodeReferenceElement)matchedElement;
            typeParameters = JavaMatchingVisitor.getTypeParameters(referenceElement, this.shouldReplaceDiamondWithExplicitTypes(patternElement));
        } else if (matchedElement instanceof PsiTypeParameter) {
            matchedElement = ((PsiTypeParameter)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiClass && ((PsiClass)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiClass)matchedElement).getTypeParameters();
            matchedElement = ((PsiClass)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiMethod && ((PsiMethod)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiMethod)matchedElement).getTypeParameters();
            matchedElement = ((PsiMethod)matchedElement).getNameIdentifier();
        }
        if (patternElement instanceof PsiTypeElement && matchedElement instanceof PsiTypeElement) {
            PsiType type1 = ((PsiTypeElement)patternElement).getType();
            PsiType type2 = ((PsiTypeElement)matchedElement).getType();
            if (type1 instanceof PsiWildcardType && type2 instanceof PsiWildcardType) {
                PsiWildcardType wildcardType1 = (PsiWildcardType)type1;
                PsiWildcardType wildcardType2 = (PsiWildcardType)type2;
                if (wildcardType1.equals((Object)wildcardType2)) {
                    return true;
                }
                if (wildcardType1.isExtends() && (wildcardType2.isExtends() || !wildcardType2.isBounded())) {
                    if (wildcardType2.isExtends()) {
                        return this.myMatchingVisitor.match(patternElement.getLastChild(), matchedElement.getLastChild());
                    }
                    if (!wildcardType2.isBounded()) {
                        return this.myMatchingVisitor.matchOptionally(patternElement.getLastChild(), null);
                    }
                } else if (wildcardType1.isSuper() && wildcardType2.isSuper()) {
                    return this.myMatchingVisitor.match(patternElement.getLastChild(), matchedElement.getLastChild());
                }
            }
        }
        if (patternElement instanceof PsiJavaCodeReferenceElement) {
            PsiTypeElement[] elements;
            referenceElement = (PsiJavaCodeReferenceElement)patternElement;
            PsiReferenceParameterList list = referenceElement.getParameterList();
            boolean typeParametersMatched = false;
            if (list != null && (elements = list.getTypeParameterElements()).length > 0) {
                typeParametersMatched = true;
                if (!this.myMatchingVisitor.matchSequentially((PsiElement[])elements, (PsiElement[])(typeParameters == null ? PsiElement.EMPTY_ARRAY : typeParameters))) {
                    return false;
                }
            }
            patternElement = referenceElement.getReferenceNameElement();
            if (typeParametersMatched && matchedElement instanceof PsiJavaCodeReferenceElement) {
                matchedElement = ((PsiJavaCodeReferenceElement)matchedElement).getReferenceNameElement();
            }
        }
        final int matchedArrayDimensions = JavaMatchingVisitor.getArrayDimensions(matchedType);
        int patternArrayDimensions = JavaMatchingVisitor.getArrayDimensions(patternType);
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(patternElement)) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(patternElement);
            RegExpPredicate regExpPredicate = null;
            boolean fullTypeResult = false;
            if (patternArrayDimensions != 0) {
                if (patternArrayDimensions != matchedArrayDimensions) {
                    return false;
                }
            } else if (matchedArrayDimensions != 0) {
                regExpPredicate = handler.findRegExpPredicate();
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(new RegExpPredicate.NodeTextGenerator(){

                        @Override
                        public String getText(PsiElement element) {
                            StringBuilder builder = new StringBuilder(StructuralSearchUtil.getMeaningfulText(element));
                            for (int i = 0; i < matchedArrayDimensions; ++i) {
                                builder.append("[]");
                            }
                            return builder.toString();
                        }
                    });
                }
                fullTypeResult = true;
            }
            try {
                boolean result;
                boolean bl = result = handler.isSubtype() || handler.isStrictSubtype() ? this.checkMatchWithinHierarchy(patternElement, matchedElement, handler) : handler.validate(matchedElement, 0, -1, this.myMatchingVisitor.getMatchContext());
                if (result) {
                    handler.addResult(fullTypeResult ? matchedType : matchedElement, 0, -1, this.myMatchingVisitor.getMatchContext());
                }
                boolean bl2 = result;
                return bl2;
            }
            finally {
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(null);
                }
            }
        }
        if (matchedArrayDimensions != patternArrayDimensions) {
            return false;
        }
        if (patternElement instanceof PsiIdentifier && (parent = patternElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            patternElement = parent;
        }
        if (matchedElement instanceof PsiIdentifier && (parent = matchedElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            matchedElement = parent;
        }
        if ((equalsIgnorePackage = MatchUtils.compareWithNoDifferenceToPackage(text = JavaMatchingVisitor.getText(patternElement), text2 = JavaMatchingVisitor.getText(matchedElement), !(caseSensitive = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch()))) || !(matchedElement instanceof PsiJavaReference)) {
            return equalsIgnorePackage;
        }
        PsiElement element2 = ((PsiJavaReference)matchedElement).resolve();
        if (!(element2 instanceof PsiClass)) {
            return false;
        }
        String name2 = ((PsiClass)element2).getQualifiedName();
        return caseSensitive ? text.equals(name2) : text.equalsIgnoreCase(name2);
    }

    @Contract(pure=true)
    private static String getText(@NotNull PsiElement element) {
        int index;
        String result;
        if (element instanceof PsiClass) {
            result = ((PsiClass)element).getQualifiedName();
            if (result == null) {
                result = element.getText();
            }
        } else {
            result = element instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element).getCanonicalText() : element.getText();
        }
        return (index = result.indexOf(60)) == -1 ? result : result.substring(0, index);
    }

    private boolean checkMatchWithinHierarchy(PsiElement patternElement, PsiElement matchElement, SubstitutionHandler handler) {
        PsiElement patternGrandParent;
        boolean includeInterfaces = true;
        boolean includeClasses = true;
        PsiElement patternParent = patternElement.getParent();
        if (patternParent instanceof PsiReferenceList && (patternGrandParent = patternParent.getParent()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)patternGrandParent;
            if (patternParent == psiClass.getExtendsList()) {
                includeInterfaces = psiClass.isInterface();
            } else if (patternParent == psiClass.getImplementsList()) {
                includeClasses = false;
            }
        }
        HierarchyNodeIterator nodes = new HierarchyNodeIterator(matchElement, includeClasses, includeInterfaces);
        if (handler.isStrictSubtype()) {
            ((NodeIterator)nodes).advance();
        }
        boolean negated = handler.getPredicate() instanceof NotPredicate;
        while (((NodeIterator)nodes).hasNext() && negated == handler.validate(((NodeIterator)nodes).current(), 0, -1, this.myMatchingVisitor.getMatchContext())) {
            ((NodeIterator)nodes).advance();
        }
        return negated != ((NodeIterator)nodes).hasNext();
    }

    public void visitConditionalExpression(PsiConditionalExpression cond) {
        PsiConditionalExpression cond2 = this.getExpression(PsiConditionalExpression.class);
        if (cond2 == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)cond.getCondition(), (PsiElement)cond2.getCondition()) && this.myMatchingVisitor.matchSons((PsiElement)cond, (PsiElement)cond2));
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        PsiPolyadicExpression expr2 = this.getExpression(PsiPolyadicExpression.class);
        if (expr2 == null) {
            return;
        }
        if (this.myMatchingVisitor.setResult(expression.getOperationTokenType().equals(expr2.getOperationTokenType()))) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])expression.getOperands(), (PsiElement[])expr2.getOperands()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitVariable(PsiVariable var) {
        PsiVariable var2 = (PsiVariable)this.myMatchingVisitor.getElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        PsiIdentifier nameIdentifier = var.getNameIdentifier();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)nameIdentifier);
        context.pushResult();
        try {
            if (!this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)nameIdentifier, (PsiElement)var2.getNameIdentifier())) && this.myMatchingVisitor.match((PsiElement)var.getModifierList(), (PsiElement)var2.getModifierList()))) {
                return;
            }
            PsiTypeElement typeElement1 = var.getTypeElement();
            if (typeElement1 != null) {
                PsiTypeElement typeElement2 = var2.getTypeElement();
                if (typeElement2 == null) {
                    typeElement2 = JavaPsiFacade.getElementFactory((Project)var2.getProject()).createTypeElement(var2.getType());
                }
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)typeElement1, (PsiElement)typeElement2))) {
                    return;
                }
            }
            PsiExpression initializer = var.getInitializer();
            PsiExpression var2Initializer = var2.getInitializer();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)initializer, (PsiElement)var2Initializer));
        }
        finally {
            String name2;
            PsiIdentifier identifier = var2.getNameIdentifier();
            if (identifier == null && (name2 = var2.getName()) != null) {
                PsiIdentifier fakeIdentifier = JavaPsiFacade.getElementFactory((Project)var2.getProject()).createIdentifier(name2);
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
            } else {
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
            }
        }
    }

    private void matchArrayOrArguments(PsiNewExpression new1, PsiNewExpression new2) {
        PsiExpression[] dimensions2;
        PsiExpression[] dimensions1;
        PsiType type1 = new1.getType();
        PsiType type2 = new2.getType();
        if (!this.myMatchingVisitor.setResult(type1 != null && type2 != null && type1.getArrayDimensions() == type2.getArrayDimensions())) {
            return;
        }
        PsiArrayInitializerExpression initializer1 = new1.getArrayInitializer();
        PsiArrayInitializerExpression initializer2 = new2.getArrayInitializer();
        if (initializer1 != null) {
            if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)initializer1, (PsiElement)initializer2))) {
                return;
            }
        } else if (initializer2 != null) {
            this.myMatchingVisitor.setResult(JavaMatchingVisitor.areZeroLiterals(new1.getArrayDimensions()) && initializer2.getInitializers().length == 0);
            return;
        }
        if (!this.myMatchingVisitor.setResult((dimensions1 = new1.getArrayDimensions()).length == (dimensions2 = new2.getArrayDimensions()).length)) {
            return;
        }
        if (dimensions1.length != 0) {
            for (int i = 0; i < dimensions1.length; ++i) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)dimensions1[i], (PsiElement)dimensions2[i]))) continue;
                return;
            }
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)new1.getArgumentList(), (PsiElement)new2.getArgumentList()) && this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiCallExpression)new1, (PsiCallExpression)new2)));
        }
    }

    private static boolean areZeroLiterals(PsiExpression[] expressions) {
        for (PsiExpression expression : expressions) {
            if (expression instanceof PsiLiteralExpression && expression.getText().equals("0")) continue;
            return false;
        }
        return true;
    }

    private static boolean matchImplicitQualifier(PsiExpression qualifier, PsiElement reference, MatchContext context) {
        PsiMethod target;
        Object object = target = reference instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)reference).resolveMethod() : ((PsiReference)reference).resolve();
        if (target instanceof PsiMember && qualifier instanceof PsiThisExpression) {
            return !((PsiMember)target).hasModifierProperty("static") && (target instanceof PsiField || target instanceof PsiMethod);
        }
        MatchingHandler matchingHandler = context.getPattern().getHandler((PsiElement)qualifier);
        if (!(matchingHandler instanceof SubstitutionHandler)) {
            return false;
        }
        SubstitutionHandler substitutionHandler = (SubstitutionHandler)matchingHandler;
        if (target instanceof PsiModifierListOwner && ((PsiModifierListOwner)target).hasModifierProperty("static")) {
            return substitutionHandler.handle(PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class), context);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)reference.getProject());
        PsiExpression implicitReference = factory.createExpressionFromText("this", reference);
        return substitutionHandler.handle((PsiElement)implicitReference, context);
    }

    public void visitMethodCallExpression(PsiMethodCallExpression mcall) {
        PsiMethodCallExpression mcall2 = this.getExpression(PsiMethodCallExpression.class);
        if (mcall2 == null) {
            return;
        }
        PsiReferenceExpression mcallRef1 = mcall.getMethodExpression();
        PsiReferenceExpression mcallRef2 = mcall2.getMethodExpression();
        PsiElement patternMethodName = mcallRef1.getReferenceNameElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar(patternMethodName);
        if (!isTypedVar && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(patternMethodName, mcallRef2.getReferenceNameElement()))) {
            return;
        }
        PsiExpression patternQualifier = mcallRef1.getQualifierExpression();
        PsiExpression matchedQualifier = mcallRef2.getQualifierExpression();
        if (!this.myMatchingVisitor.setResult(patternQualifier instanceof PsiThisExpression && matchedQualifier == null || this.myMatchingVisitor.matchOptionally((PsiElement)patternQualifier, (PsiElement)matchedQualifier))) {
            return;
        }
        if (patternQualifier != null && matchedQualifier == null && !this.myMatchingVisitor.setResult(JavaMatchingVisitor.matchImplicitQualifier(patternQualifier, (PsiElement)mcall2, context))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)mcall.getArgumentList(), (PsiElement)mcall2.getArgumentList()))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiCallExpression)mcall, (PsiCallExpression)mcall2))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(patternMethodName, mcallRef2.getReferenceNameElement()));
        }
    }

    private boolean matchTypeParameters(PsiCallExpression call1, PsiCallExpression call2) {
        PsiReferenceParameterList patternParameterList = call1.getTypeArgumentList();
        PsiTypeElement[] patternTypeElements = patternParameterList.getTypeParameterElements();
        if (patternTypeElements.length == 0) {
            return true;
        }
        PsiReferenceParameterList matchedParameterList = call2.getTypeArgumentList();
        if (matchedParameterList.getFirstChild() == null && this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            JavaResolveResult resolveResult = call2.resolveMethodGenerics();
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return false;
            }
            PsiTypeParameterList typeParameterList = targetMethod.getTypeParameterList();
            if (typeParameterList == null) {
                return false;
            }
            PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            matchedParameterList = (PsiReferenceParameterList)matchedParameterList.copy();
            for (PsiTypeParameter typeParameter : typeParameters) {
                PsiType type = substitutor.substitute(typeParameter);
                if (type == null) {
                    return false;
                }
                PsiTypeElement matchedTypeElement = JavaPsiFacade.getElementFactory((Project)call1.getProject()).createTypeElement(type);
                matchedParameterList.add((PsiElement)matchedTypeElement);
            }
        }
        PsiTypeElement[] matchedTypeElements = matchedParameterList.getTypeParameterElements();
        return this.myMatchingVisitor.matchSequentially((PsiElement[])patternTypeElements, (PsiElement[])matchedTypeElements);
    }

    public void visitExpressionStatement(PsiExpressionStatement expr) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (this.myMatchingVisitor.setResult(other instanceof PsiExpressionStatement)) {
            PsiExpressionStatement expr2 = (PsiExpressionStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expr.getExpression(), (PsiElement)expr2.getExpression()));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression const1) {
        PsiLiteralExpression const2 = this.getExpression(PsiLiteralExpression.class);
        if (const2 == null) {
            return;
        }
        PsiType type1 = const1.getType();
        if (type1 != null && !this.myMatchingVisitor.setResult(type1.equals(const2.getType()))) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)const1.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            int offset = 0;
            int length = const2.getTextLength();
            String text = const2.getText();
            if (StringUtil.isQuotedString((String)text)) {
                --length;
                ++offset;
            }
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)const2, offset, length, this.myMatchingVisitor.getMatchContext()));
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)const1, (PsiElement)const2, this.myMatchingVisitor.getMatchContext()));
        } else {
            Object value1 = const1.getValue();
            Object value2 = const2.getValue();
            if ((value1 instanceof String || value1 instanceof Character) && (value2 instanceof String || value2 instanceof Character)) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(StructuralSearchUtil.normalize(value1.toString()), StructuralSearchUtil.normalize(value2.toString())));
            } else if (value1 != null && value2 != null) {
                this.myMatchingVisitor.setResult(value1.equals(value2));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)const1, (PsiElement)const2));
            }
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression assign) {
        PsiAssignmentExpression other = this.getExpression(PsiAssignmentExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(assign.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)assign.getLExpression(), (PsiElement)other.getLExpression()) && this.myMatchingVisitor.match((PsiElement)assign.getRExpression(), (PsiElement)other.getRExpression()));
        }
    }

    public void visitIfStatement(PsiIfStatement if1) {
        PsiIfStatement if2 = (PsiIfStatement)this.myMatchingVisitor.getElement();
        PsiStatement elseBranch = if1.getElseBranch();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)if1.getCondition(), (PsiElement)if2.getCondition()) && this.matchBody((PsiElement)if1.getThenBranch(), (PsiElement)if2.getThenBranch()) && (elseBranch == null || this.matchBody((PsiElement)elseBranch, (PsiElement)if2.getElseBranch())));
    }

    public void visitSwitchStatement(PsiSwitchStatement switch1) {
        PsiSwitchStatement switch2 = (PsiSwitchStatement)this.myMatchingVisitor.getElement();
        if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)switch1.getExpression(), (PsiElement)switch2.getExpression()))) {
            List cases1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)switch1.getBody(), PsiSwitchLabelStatement.class);
            if (cases1.isEmpty()) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)switch1.getBody(), (PsiElement)switch2.getBody()));
            } else {
                List cases2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)switch2.getBody(), PsiSwitchLabelStatement.class);
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(cases1.toArray(PsiElement.EMPTY_ARRAY), cases2.toArray(PsiElement.EMPTY_ARRAY)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement case1) {
        PsiSwitchLabelStatement case2 = (PsiSwitchLabelStatement)this.myMatchingVisitor.getElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        PsiExpression value1 = case1.getCaseValue();
        PsiExpression value2 = case2.getCaseValue();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)value1);
        context.pushResult();
        try {
            List<PsiStatement> statements;
            if (this.myMatchingVisitor.setResult(isTypedVar || case1.isDefaultCase() == case2.isDefaultCase() && this.myMatchingVisitor.match((PsiElement)value1, (PsiElement)value2)) && !(statements = JavaMatchingVisitor.collectCaseStatements(case1)).isEmpty()) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(statements.toArray(PsiElement.EMPTY_ARRAY), JavaMatchingVisitor.collectCaseStatements(case2).toArray(PsiElement.EMPTY_ARRAY)));
            }
            this.myMatchingVisitor.scopeMatch((PsiElement)value1, isTypedVar, (PsiElement)(value2 == null ? case2 : value2));
        }
        catch (Throwable throwable) {
            this.myMatchingVisitor.scopeMatch((PsiElement)value1, isTypedVar, (PsiElement)(value2 == null ? case2 : value2));
            throw throwable;
        }
    }

    private static List<PsiStatement> collectCaseStatements(PsiSwitchLabelStatement switchLabelStatement) {
        SmartList result = new SmartList();
        PsiStatement sibling = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)switchLabelStatement, PsiStatement.class);
        while (sibling != null && !(sibling instanceof PsiSwitchLabelStatement)) {
            result.add(sibling);
            sibling = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)sibling, PsiStatement.class);
        }
        return result;
    }

    public void visitForStatement(PsiForStatement for1) {
        PsiForStatement for2 = (PsiForStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)JavaMatchingVisitor.notEmpty(for1.getInitialization()), (PsiElement)JavaMatchingVisitor.notEmpty(for2.getInitialization())) && this.myMatchingVisitor.matchOptionally((PsiElement)for1.getCondition(), (PsiElement)for2.getCondition()) && this.myMatchingVisitor.matchOptionally((PsiElement)for1.getUpdate(), (PsiElement)for2.getUpdate()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    private static PsiStatement notEmpty(PsiStatement statement2) {
        return statement2 instanceof PsiEmptyStatement ? null : statement2;
    }

    public void visitForeachStatement(PsiForeachStatement for1) {
        PsiForeachStatement for2 = (PsiForeachStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getIterationParameter(), (PsiElement)for2.getIterationParameter()) && this.myMatchingVisitor.match((PsiElement)for1.getIteratedValue(), (PsiElement)for2.getIteratedValue()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    public void visitWhileStatement(PsiWhileStatement while1) {
        PsiWhileStatement while2 = (PsiWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitBlockStatement(PsiBlockStatement block) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiCodeBlock) {
            this.myMatchingVisitor.setResult(!(other.getParent() instanceof PsiBlockStatement) && this.myMatchingVisitor.matchSons((PsiElement)block.getCodeBlock(), other));
        } else {
            PsiBlockStatement block2 = (PsiBlockStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, (PsiElement)block2));
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement dcl) {
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(dcl.getDeclaredElements(), declaration.getDeclaredElements()));
    }

    public void visitDoWhileStatement(PsiDoWhileStatement while1) {
        PsiDoWhileStatement while2 = (PsiDoWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    public void visitReturnStatement(PsiReturnStatement return1) {
        PsiReturnStatement return2 = (PsiReturnStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)return1.getReturnValue(), (PsiElement)return2.getReturnValue()));
    }

    public void visitPostfixExpression(PsiPostfixExpression postfix) {
        PsiPostfixExpression postfix2 = this.getExpression(PsiPostfixExpression.class);
        if (postfix2 == null) {
            return;
        }
        this.myMatchingVisitor.setResult(postfix.getOperationTokenType().equals(postfix2.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)postfix.getOperand(), (PsiElement)postfix2.getOperand()));
    }

    public void visitPrefixExpression(PsiPrefixExpression prefix) {
        PsiPrefixExpression prefix2 = this.getExpression(PsiPrefixExpression.class);
        if (prefix2 == null) {
            return;
        }
        this.myMatchingVisitor.setResult(prefix.getOperationTokenType().equals(prefix2.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)prefix.getOperand(), (PsiElement)prefix2.getOperand()));
    }

    public void visitAssertStatement(PsiAssertStatement assert1) {
        PsiAssertStatement assert2 = (PsiAssertStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)assert1.getAssertCondition(), (PsiElement)assert2.getAssertCondition()) && this.myMatchingVisitor.matchOptionally((PsiElement)assert1.getAssertDescription(), (PsiElement)assert2.getAssertDescription()));
    }

    public void visitBreakStatement(PsiBreakStatement break1) {
        PsiBreakStatement break2 = (PsiBreakStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)break1.getExpression(), (PsiElement)break2.getExpression()));
    }

    public void visitContinueStatement(PsiContinueStatement continue1) {
        PsiContinueStatement continue2 = (PsiContinueStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)continue1.getLabelIdentifier(), (PsiElement)continue2.getLabelIdentifier()));
    }

    public void visitSuperExpression(PsiSuperExpression super1) {
        this.getExpression(PsiSuperExpression.class);
    }

    public void visitThisExpression(PsiThisExpression this1) {
        this.getExpression(PsiThisExpression.class);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement synchronized1) {
        PsiSynchronizedStatement synchronized2 = (PsiSynchronizedStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)synchronized1.getLockExpression(), (PsiElement)synchronized2.getLockExpression()) && this.myMatchingVisitor.matchSons((PsiElement)synchronized1.getBody(), (PsiElement)synchronized2.getBody()));
    }

    public void visitThrowStatement(PsiThrowStatement throw1) {
        PsiThrowStatement throw2 = (PsiThrowStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)throw1.getException(), (PsiElement)throw2.getException()));
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expr) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (this.myMatchingVisitor.setResult(other instanceof PsiParenthesizedExpression)) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expr, other));
        }
    }

    public void visitCatchSection(PsiCatchSection section) {
        PsiCatchSection section2 = (PsiCatchSection)this.myMatchingVisitor.getElement();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)section);
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)section.getParameter(), (PsiElement)section2.getParameter()) && this.myMatchingVisitor.matchSons((PsiElement)section.getCatchBlock(), (PsiElement)section2.getCatchBlock()) && ((SubstitutionHandler)handler).handle((PsiElement)section2, this.myMatchingVisitor.getMatchContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitTryStatement(PsiTryStatement try1) {
        PsiTryStatement try2 = (PsiTryStatement)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)try1.getTryBlock(), (PsiElement)try2.getTryBlock()))) {
            return;
        }
        PsiResourceList resourceList1 = try1.getResourceList();
        PsiCatchSection[] catches1 = try1.getCatchSections();
        PsiCodeBlock finally1 = try1.getFinallyBlock();
        PsiResourceList resourceList2 = try2.getResourceList();
        Object[] catches2 = try2.getCatchSections();
        PsiCodeBlock finally2 = try2.getFinallyBlock();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        if (!context.getOptions().isLooseMatching() && (catches1.length == 0 && catches2.length != 0 || finally1 == null && finally2 != null || resourceList1 == null && resourceList2 != null)) {
            this.myMatchingVisitor.setResult(false);
        } else {
            SmartList unmatchedElements = new SmartList();
            if (resourceList1 != null) {
                List resources1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList1, PsiResourceListElement.class);
                List resources2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList2, PsiResourceListElement.class);
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(resources1.toArray(PsiElement.EMPTY_ARRAY), resources2.toArray(PsiElement.EMPTY_ARRAY)))) {
                    return;
                }
            } else if (resourceList2 != null) {
                unmatchedElements.add(resourceList2);
            }
            ContainerUtil.addAll((Collection)unmatchedElements, (Object[])catches2);
            context.pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitTryStatement$2((List)unmatchedElements, arg_0));
            try {
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])catches1, (PsiElement[])catches2))) {
                    return;
                }
            }
            finally {
                context.popMatchedElementsListener();
            }
            if (finally1 != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)finally1, (PsiElement)finally2));
            } else if (finally2 != null) {
                unmatchedElements.add(finally2);
            }
            if (this.myMatchingVisitor.getResult() && !unmatchedElements.isEmpty()) {
                try2.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
        }
    }

    public void visitResourceExpression(PsiResourceExpression expression) {
        PsiElement other = this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(other instanceof PsiResourceExpression && this.myMatchingVisitor.match((PsiElement)expression.getExpression(), (PsiElement)((PsiResourceExpression)other).getExpression()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitLabeledStatement(PsiLabeledStatement statement2) {
        PsiLabeledStatement other = (PsiLabeledStatement)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = statement2.getLabelIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)identifier);
        context.pushResult();
        try {
            this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)identifier, other.getNameIdentifier())) && this.myMatchingVisitor.match((PsiElement)statement2.getStatement(), (PsiElement)other.getStatement()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)identifier, isTypedVar, other.getNameIdentifier());
        }
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression instanceOf) {
        PsiInstanceOfExpression other = this.getExpression(PsiInstanceOfExpression.class);
        if (other == null) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)instanceOf.getOperand(), (PsiElement)other.getOperand()))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)instanceOf.getCheckType(), (PsiElement)other.getCheckType()));
    }

    public void visitNewExpression(PsiNewExpression new1) {
        PsiExpression other = this.getExpression();
        PsiJavaCodeReferenceElement classReference = new1.getClassReference();
        if (other instanceof PsiArrayInitializerExpression && other.getParent() instanceof PsiVariable && JavaMatchingVisitor.areZeroLiterals(new1.getArrayDimensions())) {
            MatchingHandler handler;
            MatchContext matchContext = this.myMatchingVisitor.getMatchContext();
            CompiledPattern pattern = matchContext.getPattern();
            boolean isTypedVar = pattern.isTypedVar((PsiElement)classReference);
            if (isTypedVar && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference, null))) {
                return;
            }
            PsiType otherType = other.getType();
            if (classReference != null && (handler = pattern.getHandler((PsiElement)classReference)) instanceof SubstitutionHandler && otherType != null) {
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
                MatchPredicate predicate = substitutionHandler.getPredicate();
                if (predicate != null) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                    PsiTypeElement otherTypeElement = factory.createTypeElement(otherType.getDeepComponentType());
                    this.myMatchingVisitor.setResult(predicate.match((PsiElement)otherTypeElement, matchContext));
                }
            } else {
                PsiType type = new1.getType();
                this.myMatchingVisitor.setResult(type != null && type.equals(otherType));
            }
            if (this.myMatchingVisitor.getResult()) {
                PsiArrayInitializerExpression initializer = new1.getArrayInitializer();
                if (initializer != null) {
                    this.myMatchingVisitor.matchSons((PsiElement)initializer, (PsiElement)other);
                } else {
                    this.myMatchingVisitor.setResult(((PsiArrayInitializerExpression)other).getInitializers().length == 0);
                }
            }
            return;
        }
        if (!this.myMatchingVisitor.setResult(other instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression new2 = (PsiNewExpression)other;
        if (classReference != null) {
            if (new2.getClassReference() != null) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference, (PsiElement)new2.getClassReference()))) {
                    this.matchArrayOrArguments(new1, new2);
                }
                return;
            }
            PsiKeyword newKeyword = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)new2, PsiKeyword.class);
            PsiElement element = PsiTreeUtil.getNextSiblingOfType((PsiElement)newKeyword, PsiWhiteSpace.class);
            if (element != null && element.getNextSibling() instanceof PsiKeyword) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference, element.getNextSibling()))) {
                    this.matchArrayOrArguments(new1, new2);
                }
                return;
            }
        }
        if (classReference == new2.getClassReference()) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)new1, (PsiElement)new2));
        } else if (new1.getAnonymousClass() == null && classReference != null && new2.getAnonymousClass() != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference, (PsiElement)new2.getAnonymousClass().getBaseClassReference()) && this.myMatchingVisitor.matchSons((PsiElement)new1.getArgumentList(), (PsiElement)new2.getArgumentList()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitKeyword(PsiKeyword keyword) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)keyword, this.myMatchingVisitor.getElement()));
    }

    public void visitTypeCastExpression(PsiTypeCastExpression cast) {
        PsiTypeCastExpression other = this.getExpression(PsiTypeCastExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)cast.getCastType(), (PsiElement)other.getCastType()) && this.myMatchingVisitor.match((PsiElement)cast.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expr) {
        PsiClassObjectAccessExpression other = this.getExpression(PsiClassObjectAccessExpression.class);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expr.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        PsiAnnotation[] otherAnnotations;
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        if (annotations != null && !this.myMatchingVisitor.setResult((otherAnnotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class)) != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])otherAnnotations))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.matchType((PsiElement)ref, other));
    }

    public void visitTypeElement(PsiTypeElement typeElement) {
        PsiAnnotation[] annotations2;
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiAnnotation.class);
        if (annotations != null && !this.myMatchingVisitor.setResult((annotations2 = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class)) != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])annotations2))) {
            return;
        }
        PsiTypeElement[] typeElementChildren = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
        if (typeElementChildren != null && typeElementChildren.length > 1) {
            PsiTypeElement[] typeElementChildren2 = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiTypeElement.class);
            this.myMatchingVisitor.setResult(typeElementChildren2 != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])typeElementChildren, (PsiElement[])typeElementChildren2));
        } else {
            this.myMatchingVisitor.setResult(this.matchType((PsiElement)typeElement, other));
        }
    }

    public void visitTypeParameter(PsiTypeParameter psiTypeParameter) {
        PsiTypeParameter parameter = (PsiTypeParameter)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = psiTypeParameter.getNameIdentifier();
        assert (identifier != null);
        PsiIdentifier identifier2 = parameter.getNameIdentifier();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)identifier);
        if (handler instanceof SubstitutionHandler ? !this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)identifier2, this.myMatchingVisitor.getMatchContext())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)identifier, (PsiElement)identifier2))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchInAnyOrder(psiTypeParameter.getExtendsList(), parameter.getExtendsList()))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])psiTypeParameter.getAnnotations(), (PsiElement[])parameter.getAnnotations()));
    }

    public void visitClass(PsiClass clazz) {
        PsiClass clazz2 = (PsiClass)this.myMatchingVisitor.getElement();
        if (clazz.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)clazz.getTypeParameterList(), (PsiElement)clazz2.getTypeParameterList()))) {
            return;
        }
        PsiDocComment comment = clazz.getDocComment();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)clazz2))) {
            return;
        }
        PsiIdentifier identifier = clazz.getNameIdentifier();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)identifier);
        PsiModifierList modifierList = clazz.getModifierList();
        if (modifierList != null && modifierList.getTextLength() > 0 && !this.myMatchingVisitor.match((PsiElement)modifierList, (PsiElement)clazz2.getModifierList())) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)identifier, (PsiElement)clazz2.getNameIdentifier())) && this.compareClasses(clazz, clazz2)) && isTypedVar) {
            SubstitutionHandler handler;
            PsiIdentifier id = clazz2.getNameIdentifier();
            if (id == null) {
                id = clazz2;
            }
            if ((handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)identifier)).isSubtype() || handler.isStrictSubtype()) {
                if (this.myMatchingVisitor.setResult(this.checkMatchWithinHierarchy((PsiElement)identifier, (PsiElement)id, handler))) {
                    handler.addResult((PsiElement)id, 0, -1, this.myMatchingVisitor.getMatchContext());
                }
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)identifier, (PsiElement)id));
            }
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList psiTypeParameterList) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(psiTypeParameterList.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(PsiMethod method) {
        PsiIdentifier methodNameNode = method.getNameIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)methodNameNode);
        PsiMethod method2 = (PsiMethod)this.myMatchingVisitor.getElement();
        context.pushResult();
        try {
            PsiDocComment docComment = method.getDocComment();
            if (docComment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)docComment, (PsiElement)method2))) {
                return;
            }
            if (method.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)method.getTypeParameterList(), (PsiElement)((PsiMethod)this.myMatchingVisitor.getElement()).getTypeParameterList()))) {
                return;
            }
            if (!this.checkHierarchy((PsiMember)method2, (PsiMember)method)) {
                this.myMatchingVisitor.setResult(false);
                return;
            }
            this.myMatchingVisitor.setResult(method.isConstructor() == method2.isConstructor() && (isTypedVar || this.myMatchingVisitor.matchText((PsiElement)methodNameNode, (PsiElement)method2.getNameIdentifier())) && this.myMatchingVisitor.match((PsiElement)method.getModifierList(), (PsiElement)method2.getModifierList()) && this.myMatchingVisitor.matchSons((PsiElement)method.getParameterList(), (PsiElement)method2.getParameterList()) && this.myMatchingVisitor.match((PsiElement)method.getReturnTypeElement(), (PsiElement)method2.getReturnTypeElement()) && this.matchInAnyOrder(method.getThrowsList(), method2.getThrowsList()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)method.getBody(), (PsiElement)method2.getBody()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)methodNameNode, isTypedVar, (PsiElement)method2.getNameIdentifier());
        }
    }

    private <T extends PsiExpression> T getExpression(Class<T> aClass) {
        PsiExpression other = this.getExpression();
        return (T)(this.myMatchingVisitor.setResult(aClass.isInstance(other)) ? other : null);
    }

    private PsiExpression getExpression() {
        PsiElement other = this.myMatchingVisitor.getElement();
        return other instanceof PsiExpression ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)other)) : null;
    }

    private static /* synthetic */ void lambda$visitTryStatement$2(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    private static /* synthetic */ void lambda$compareClasses$1(Set matchedElements, Collection elements) {
        matchedElements.addAll(elements);
    }

    private static /* synthetic */ void lambda$visitModifierList$0(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    static {
        Arrays.sort(MODIFIERS);
    }
}

