/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import java.util.HashSet;

public abstract class MatchingHandler {
    protected NodeFilter filter;
    private PsiElement pinnedElement;
    protected static ClearStateVisitor clearingVisitor = new ClearStateVisitor();

    public void setFilter(NodeFilter filter) {
        this.filter = filter;
    }

    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        return patternNode == null ? matchedNode == null : this.canMatch(patternNode, matchedNode, context);
    }

    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        return this.filter != null ? this.filter.accepts(matchedNode) : DefaultFilter.accepts(patternNode, matchedNode);
    }

    public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context) {
        MatchingStrategy strategy = context.getPattern().getStrategy();
        PsiElement currentPatternNode = patternNodes.current();
        PsiElement currentMatchNode = matchNodes.current();
        MatchingHandler.skipIfNecessary(matchNodes, currentPatternNode, strategy);
        MatchingHandler.skipComments(matchNodes, currentPatternNode);
        MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy);
        if (!patternNodes.hasNext()) {
            return !matchNodes.hasNext();
        }
        PsiElement patternElement = patternNodes.current();
        MatchingHandler handler = context.getPattern().getHandler(patternElement);
        if (matchNodes.hasNext() && handler.match(patternElement, matchNodes.current(), context)) {
            patternNodes.advance();
            MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy);
            if (this.shouldAdvanceTheMatchFor(patternElement, matchNodes.current())) {
                matchNodes.advance();
                MatchingHandler.skipIfNecessary(matchNodes, patternNodes.current(), strategy);
                if (patternNodes.hasNext()) {
                    MatchingHandler.skipComments(matchNodes, patternNodes.current());
                }
            }
            if (patternNodes.hasNext()) {
                MatchingHandler nextHandler = context.getPattern().getHandler(patternNodes.current());
                if (nextHandler.matchSequentially(patternNodes, matchNodes, context)) {
                    return true;
                }
                patternNodes.rewindTo(currentPatternNode);
                matchNodes.rewindTo(currentMatchNode);
            } else {
                return handler.isMatchSequentiallySucceeded(matchNodes);
            }
        }
        return false;
    }

    private static void skipComments(NodeIterator matchNodes, PsiElement patternNode) {
        boolean skipComment;
        boolean bl = skipComment = !(patternNode instanceof PsiComment);
        while (skipComment && matchNodes.current() instanceof PsiComment) {
            matchNodes.advance();
        }
    }

    private static void skipIfNecessary(NodeIterator nodes, PsiElement elementToMatchWith, MatchingStrategy strategy) {
        while (strategy.shouldSkip(nodes.current(), elementToMatchWith)) {
            nodes.advance();
        }
    }

    protected boolean isMatchSequentiallySucceeded(NodeIterator matchNodes) {
        MatchingHandler.skipComments(matchNodes, null);
        return !matchNodes.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchInAnyOrder(NodeIterator patternNodes, NodeIterator matchedNodes, MatchContext context) {
        MatchResultImpl saveResult = context.hasResult() ? context.getResult() : null;
        context.setResult(null);
        try {
            if (patternNodes.hasNext() && !matchedNodes.hasNext()) {
                boolean bl = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
                return bl;
            }
            HashSet<PsiElement> matchedElements = null;
            while (patternNodes.hasNext()) {
                PsiElement patternNode = patternNodes.current();
                patternNodes.advance();
                CompiledPattern pattern = context.getPattern();
                MatchingHandler handler = pattern.getHandler(patternNode);
                matchedNodes.reset();
                boolean allElementsMatched = true;
                int matchedOccurs = 0;
                while (true) {
                    PsiElement pinnedNode;
                    PsiElement matchedNode;
                    PsiElement psiElement = matchedNode = (pinnedNode = handler.getPinnedNode()) != null ? pinnedNode : matchedNodes.current();
                    if (pinnedNode == null) {
                        matchedNodes.advance();
                    }
                    if (matchedElements == null || !matchedElements.contains(matchedNode)) {
                        allElementsMatched = false;
                        if (handler.match(patternNode, matchedNode, context)) {
                            ++matchedOccurs;
                            if (matchedElements == null) {
                                matchedElements = new HashSet<PsiElement>();
                            }
                            matchedElements.add(matchedNode);
                            if (handler.shouldAdvanceThePatternFor(patternNode, matchedNode)) {
                                break;
                            }
                        } else if (pinnedNode != null) {
                            boolean bl = false;
                            return bl;
                        }
                        clearingVisitor.clearState(pattern, patternNode);
                    }
                    if (matchedNodes.hasNext() && pinnedNode == null) continue;
                    if (!handler.validate(context, matchedOccurs)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!allElementsMatched && patternNodes.hasNext()) break;
                    boolean result = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
                    if (result && matchedElements != null) {
                        context.notifyMatchedElements(matchedElements);
                    }
                    boolean bl = result;
                    return bl;
                }
                if (handler.validate(context, matchedOccurs)) continue;
                boolean bl = false;
                return bl;
            }
            boolean result = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
            if (result && matchedElements != null) {
                context.notifyMatchedElements(matchedElements);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (saveResult != null) {
                if (context.hasResult()) {
                    for (MatchResult child : context.getResult().getChildren()) {
                        saveResult.addChild(child);
                    }
                }
                context.setResult(saveResult);
            }
        }
    }

    protected static boolean validateSatisfactionOfHandlers(NodeIterator patternNodes, MatchContext context) {
        while (patternNodes.hasNext()) {
            if (!context.getPattern().getHandler(patternNodes.current()).validate(context, 0)) {
                return false;
            }
            patternNodes.advance();
        }
        return true;
    }

    boolean validate(MatchContext context, int matchedOccurs) {
        return matchedOccurs == 1;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean shouldAdvanceThePatternFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public void reset() {
    }

    public PsiElement getPinnedNode() {
        return this.pinnedElement;
    }

    public void setPinnedElement(PsiElement pinnedElement) {
        this.pinnedElement = pinnedElement;
    }

    static class ClearStateVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private CompiledPattern pattern;

        ClearStateVisitor() {
            super(true);
        }

        public void visitElement(PsiElement element) {
            MatchingHandler handler;
            if (this.pattern.isToResetHandler(element) && (handler = this.pattern.getHandlerSimple(element)) != null) {
                handler.reset();
            }
            super.visitElement(element);
        }

        synchronized void clearState(CompiledPattern _pattern, PsiElement el) {
            this.pattern = _pattern;
            el.acceptChildren((PsiElementVisitor)this);
            this.pattern = null;
        }
    }
}

