/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkippingHandler
extends MatchingHandler
implements DelegatingHandler {
    private final MatchingHandler myDelegate;

    public SkippingHandler(@NotNull MatchingHandler delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext matchContext) {
        if (patternNode == null || matchedNode == null || matchedNode.getClass() == patternNode.getClass()) {
            return this.myDelegate.match(patternNode, matchedNode, matchContext);
        }
        PsiElement newPatternNode = SkippingHandler.skipNodeIfNeccessary(patternNode);
        matchedNode = SkippingHandler.skipNodeIfNeccessary(matchedNode);
        if (newPatternNode != patternNode) {
            return matchContext.getPattern().getHandler(newPatternNode).match(newPatternNode, matchedNode, matchContext);
        }
        return this.myDelegate.match(patternNode, matchedNode, matchContext);
    }

    @Override
    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        PsiElement newPatternNode = SkippingHandler.skipNodeIfNeccessary(patternNode);
        if (newPatternNode != patternNode) {
            return context.getPattern().getHandler(newPatternNode).canMatch(newPatternNode, matchedNode, context);
        }
        return this.myDelegate.canMatch(patternNode, matchedNode, context);
    }

    @Override
    public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context) {
        return this.myDelegate.matchSequentially(patternNodes, matchNodes, context);
    }

    @Override
    protected boolean isMatchSequentiallySucceeded(NodeIterator matchNodes) {
        return this.myDelegate.isMatchSequentiallySucceeded(matchNodes);
    }

    @Override
    public MatchingHandler getDelegate() {
        return this.myDelegate;
    }

    @Nullable
    public static PsiElement getOnlyNonWhitespaceChild(PsiElement element) {
        PsiElement onlyChild = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (DuplocatorUtil.isIgnoredNode(element) || child.getTextLength() == 0) continue;
            if (onlyChild != null) {
                return null;
            }
            onlyChild = child;
        }
        return onlyChild;
    }

    @Nullable
    public static PsiElement skipNodeIfNeccessary(PsiElement element) {
        return SkippingHandler.skipNodeIfNeccessary(element, null, null);
    }

    @Nullable
    public static PsiElement skipNodeIfNeccessary(PsiElement element, EquivalenceDescriptor descriptor2, NodeFilter filter) {
        return DuplocatorUtil.skipNodeIfNeccessary(element, descriptor2, filter != null ? filter : LexicalNodesFilter.getInstance());
    }
}

