/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspectionOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SSBasedInspection
extends LocalInspectionTool {
    static final Object LOCK = new Object();
    static final String SHORT_NAME = "SSBasedInspection";
    private final List<Configuration> myConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();
    final Set<String> myProblemsReported = new HashSet<String>(1);

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        ConfigurationManager.writeConfigurations(node, this.myConfigurations);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.myProblemsReported.clear();
        this.myConfigurations.clear();
        ConfigurationManager.readConfigurations(node, this.myConfigurations);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GENERAL_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return SSRBundle.message("SSRInspection.display.name", new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        final Map<Configuration, MatchContext> compiledOptions = SSBasedInspectionCompiledPatternsCache.getCompiledOptions(this.myConfigurations, holder.getProject());
        if (compiledOptions.isEmpty()) {
            return super.buildVisitor(holder, isOnTheFly);
        }
        return new PsiElementVisitor(){
            final Matcher matcher;
            final PairProcessor<MatchResult, Configuration> processor;
            {
                this.matcher = new Matcher(holder.getManager().getProject());
                this.processor = (matchResult, configuration) -> {
                    PsiElement element = matchResult.getMatch();
                    String name2 = configuration.getName();
                    LocalQuickFix fix = SSBasedInspection.createQuickFix(holder.getManager().getProject(), matchResult, configuration);
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, name2, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                    return true;
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitElement(PsiElement element) {
                if (LexicalNodesFilter.getInstance().accepts(element)) {
                    return;
                }
                Object object = LOCK;
                synchronized (object) {
                    SsrFilteringNodeIterator matchedNodes = new SsrFilteringNodeIterator(element);
                    for (Map.Entry entry : compiledOptions.entrySet()) {
                        block7: {
                            Configuration configuration = (Configuration)entry.getKey();
                            MatchContext context = (MatchContext)entry.getValue();
                            if (context == null || !Matcher.checkIfShouldAttemptToMatch(context, matchedNodes)) continue;
                            int nodeCount = context.getPattern().getNodeCount();
                            try {
                                this.matcher.processMatchesInElement(context, configuration, new CountingNodeIterator(nodeCount, matchedNodes), this.processor);
                            }
                            catch (StructuralSearchException e) {
                                if (!SSBasedInspection.this.myProblemsReported.add(configuration.getName())) break block7;
                                UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.ERROR).setContent(e instanceof StructuralSearchScriptException ? SSRBundle.message("inspection.script.problem", e.getCause(), configuration.getName()) : SSRBundle.message("inspection.template.problem", e.getMessage())).setImportant(true).notify(element.getProject());
                            }
                        }
                        matchedNodes.reset();
                    }
                }
            }
        };
    }

    static LocalQuickFix createQuickFix(Project project2, MatchResult matchResult, Configuration configuration) {
        if (!(configuration instanceof ReplaceConfiguration)) {
            return null;
        }
        ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)configuration;
        final Replacer replacer = new Replacer(project2, replaceConfiguration.getReplaceOptions());
        final ReplacementInfo replacementInfo = replacer.buildReplacement(matchResult);
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                return SSRBundle.message("SSRInspection.replace.with", replacementInfo.getReplacement());
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                PsiElement element = descriptor2.getPsiElement();
                if (element != null) {
                    replacer.replace(replacementInfo);
                }
            }

            @NotNull
            public String getFamilyName() {
                return SSRBundle.message("SSRInspection.family.name", new Object[0]);
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SSBasedInspectionOptions(this.myConfigurations).getComponent();
    }

    public void setConfigurations(@NotNull List<Configuration> configurations, @NotNull Project project2) {
        this.myConfigurations.clear();
        this.myConfigurations.addAll(configurations);
    }
}

