/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection.highlightTemplate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SSBasedInspectionCompiledPatternsCache {
    private static final Key<Map<Configuration, MatchContext>> COMPILED_OPTIONS_KEY = Key.create((String)"SSR_INSPECTION_COMPILED_OPTIONS_KEY");

    @NotNull
    static Map<Configuration, MatchContext> getCompiledOptions(@NotNull List<Configuration> configurations, @NotNull Project project2) {
        Map cache = (Map)ObjectUtils.notNull((Object)project2.getUserData(COMPILED_OPTIONS_KEY), new HashMap());
        if (!SSBasedInspectionCompiledPatternsCache.areConfigurationsInCache(configurations, cache)) {
            Matcher matcher = new Matcher(project2);
            matcher.precompileOptions(configurations, cache);
            project2.putUserData(COMPILED_OPTIONS_KEY, (Object)cache);
            cache.keySet().retainAll(configurations);
        }
        return ContainerUtilRt.newHashMap((Map)cache);
    }

    private static boolean areConfigurationsInCache(@NotNull List<Configuration> configurations, @NotNull Map<Configuration, MatchContext> cache) {
        for (Configuration configuration : configurations) {
            if (cache.containsKey(configuration)) continue;
            return false;
        }
        return true;
    }

    public static void removeFromCache(Configuration configuration, @NotNull Project project2) {
        Map cache = (Map)project2.getUserData(COMPILED_OPTIONS_KEY);
        if (cache != null) {
            cache.remove(configuration);
        }
    }
}

