/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import org.jetbrains.annotations.NotNull;

public class StructuralReplaceAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        StructuralReplaceAction.triggerAction(null, new SearchContext(event.getDataContext()));
    }

    public static void triggerAction(Configuration config, SearchContext searchContext) {
        Project project2 = searchContext.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (Registry.is((String)"ssr.use.new.search.dialog")) {
            StructuralSearchDialog replaceDialog = new StructuralSearchDialog(searchContext, true);
            if (config != null) {
                replaceDialog.setUseLastConfiguration(true);
                replaceDialog.loadConfiguration(config);
            }
            replaceDialog.show();
        } else {
            ReplaceDialog replaceDialog = new ReplaceDialog(searchContext);
            if (config != null) {
                replaceDialog.setUseLastConfiguration(true);
                replaceDialog.setValuesFromConfig(config);
            }
            replaceDialog.show();
        }
    }

    public void update(@NotNull AnActionEvent event) {
        StructuralSearchPlugin plugin;
        Presentation presentation = event.getPresentation();
        Project project2 = event.getProject();
        StructuralSearchPlugin structuralSearchPlugin = plugin = project2 == null ? null : StructuralSearchPlugin.getInstance(project2);
        if (plugin == null || plugin.isSearchInProgress() || plugin.isReplaceInProgress() || plugin.isDialogVisible()) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
        super.update(event);
    }
}

