/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Configuration
implements JDOMExternalizable,
Comparable<Configuration> {
    @NonNls
    public static final String CONTEXT_VAR_NAME = "__context__";
    public static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    @NonNls
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String CREATED_ATTRIBUTE_NAME = "created";
    private String name;
    private String category;
    private boolean predefined;
    private long created;
    private transient String myCurrentVariableName = null;

    public Configuration() {
        this.name = "";
        this.category = "";
        this.created = -1L;
    }

    public Configuration(String name2, String category) {
        this.name = name2;
        this.category = category;
        this.created = -1L;
    }

    protected Configuration(Configuration configuration) {
        this.name = configuration.name;
        this.category = configuration.category;
        this.created = -1L;
        this.predefined = false;
    }

    public abstract Configuration copy();

    @NotNull
    public String getName() {
        if (StringUtil.isEmptyOrSpaces((String)this.name)) {
            return StringUtil.collapseWhiteSpace((CharSequence)this.getMatchOptions().getSearchPattern());
        }
        return this.name;
    }

    public void setName(@NotNull String value) {
        this.name = value;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(@NotNull String category) {
        this.category = category;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        if (this.predefined) {
            throw new AssertionError();
        }
        this.created = created;
    }

    public void readExternal(Element element) {
        this.name = element.getAttributeValue(NAME_ATTRIBUTE_NAME);
        Attribute attribute = element.getAttribute(CREATED_ATTRIBUTE_NAME);
        if (attribute != null) {
            try {
                this.created = attribute.getLongValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME_ATTRIBUTE_NAME, this.name);
        if (this.created > 0L) {
            element.setAttribute(CREATED_ATTRIBUTE_NAME, String.valueOf(this.created));
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setPredefined(boolean predefined) {
        this.predefined = predefined;
    }

    public abstract MatchOptions getMatchOptions();

    public ReplaceOptions getReplaceOptions() {
        return null;
    }

    public abstract NamedScriptableDefinition findVariable(String var1);

    public abstract void removeUnusedVariables();

    public String getCurrentVariableName() {
        return this.myCurrentVariableName;
    }

    public void setCurrentVariableName(String variableName) {
        this.myCurrentVariableName = variableName;
    }

    @Override
    public int compareTo(Configuration other) {
        int result = StringUtil.naturalCompare((String)this.getCategory(), (String)other.getCategory());
        return result != 0 ? result : StringUtil.naturalCompare((String)this.getName(), (String)other.getName());
    }

    public boolean equals(Object configuration) {
        if (!(configuration instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)configuration;
        if (this.category != null ? !this.category.equals(other.category) : other.category != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + (this.category != null ? this.category.hashCode() : 0);
    }
}

