/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="StructuralSearchPlugin", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationManager
implements PersistentStateComponent<Element> {
    private static final int MAX_RECENT_SIZE = 30;
    @NonNls
    static final String SEARCH_TAG_NAME = "searchConfiguration";
    @NonNls
    static final String REPLACE_TAG_NAME = "replaceConfiguration";
    @NonNls
    private static final String SAVE_HISTORY_ATTR_NAME = "history";
    private final List<Configuration> configurations = new SmartList();
    private final List<Configuration> historyConfigurations = new SmartList();
    private final ConfigurationManagerState myApplicationState;
    private final Project myProject;

    public static ConfigurationManager getInstance(@NotNull Project project2) {
        return (ConfigurationManager)ServiceManager.getService((Project)project2, ConfigurationManager.class);
    }

    public ConfigurationManager(Project project2) {
        this.myProject = project2;
        this.myApplicationState = ConfigurationManagerState.getInstance();
    }

    public Element getState() {
        Element state = new Element("state");
        ConfigurationManager.writeConfigurations(state, this.configurations, this.historyConfigurations);
        return state;
    }

    public void loadState(@NotNull Element element) {
        this.configurations.clear();
        this.historyConfigurations.clear();
        SmartList tmp = new SmartList();
        ConfigurationManager.readConfigurations(element, this.configurations, (Collection<Configuration>)tmp);
        this.migrate(this.configurations);
        for (Configuration configuration : tmp) {
            configuration.getMatchOptions().initScope(this.myProject);
            this.addHistoryConfiguration(configuration);
        }
        Collections.reverse(this.historyConfigurations);
    }

    private void migrate(List<Configuration> configurations) {
        if (configurations.isEmpty()) {
            return;
        }
        block0: for (Configuration configuration : configurations) {
            Configuration existing = this.myApplicationState.get(configuration.getName());
            while (existing != null) {
                if (configuration.equals(existing)) continue block0;
                configuration.setName(configuration.getName() + '~');
                existing = this.myApplicationState.get(configuration.getName());
            }
            this.myApplicationState.add(configuration);
        }
    }

    public void addHistoryConfiguration(@NotNull Configuration configuration) {
        Configuration old;
        if ((configuration = configuration.copy()).getCreated() <= 0L) {
            configuration.setCreated(System.currentTimeMillis());
        }
        if ((old = ConfigurationManager.findConfiguration(this.historyConfigurations, configuration)) != null) {
            this.historyConfigurations.remove(old);
        }
        this.historyConfigurations.add(0, configuration);
        while (this.historyConfigurations.size() > 30) {
            this.historyConfigurations.remove(this.historyConfigurations.size() - 1);
        }
    }

    public Configuration getMostRecentConfiguration() {
        return this.historyConfigurations.isEmpty() ? null : this.historyConfigurations.get(0);
    }

    public void removeConfiguration(Configuration configuration) {
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            this.myApplicationState.remove(configuration.getName());
        }
        this.configurations.remove(configuration);
    }

    public static void writeConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations) {
        ConfigurationManager.writeConfigurations(element, configurations, Collections.emptyList());
    }

    private static void writeConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations, @NotNull Collection<Configuration> historyConfigurations) {
        for (Configuration configuration : configurations) {
            configuration.getMatchOptions().setScope(null);
            ConfigurationManager.saveConfiguration(element, configuration);
        }
        for (Configuration historyConfiguration : historyConfigurations) {
            Element infoElement = ConfigurationManager.saveConfiguration(element, historyConfiguration);
            infoElement.setAttribute(SAVE_HISTORY_ATTR_NAME, "1");
        }
    }

    static Element saveConfiguration(@NotNull Element element, @NotNull Configuration config) {
        Element infoElement = new Element(config instanceof SearchConfiguration ? SEARCH_TAG_NAME : REPLACE_TAG_NAME);
        element.addContent(infoElement);
        config.writeExternal(infoElement);
        return infoElement;
    }

    public static void readConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations) {
        ConfigurationManager.readConfigurations(element, configurations, (Collection<Configuration>)new SmartList());
    }

    private static void readConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations, @NotNull Collection<Configuration> historyConfigurations) {
        for (Element pattern : element.getChildren()) {
            Configuration config = ConfigurationManager.readConfiguration(pattern);
            if (config == null) continue;
            if (pattern.getAttribute(SAVE_HISTORY_ATTR_NAME) != null) {
                historyConfigurations.add(config);
                continue;
            }
            configurations.add(config);
        }
    }

    static Configuration readConfiguration(@NotNull Element element) {
        Configuration config;
        String name2 = element.getName();
        if (name2.equals(SEARCH_TAG_NAME)) {
            config = new SearchConfiguration();
        } else if (name2.equals(REPLACE_TAG_NAME)) {
            config = new ReplaceConfiguration();
        } else {
            return null;
        }
        ((Configuration)config).readExternal(element);
        return config;
    }

    public List<String> getAllConfigurationNames() {
        Stream<Configuration> stream = Stream.concat(StructuralSearchUtil.getPredefinedTemplates().stream(), this.getConfigurations().stream());
        return stream.map(c -> c.getName()).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Configuration> getConfigurations() {
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            return this.myApplicationState.getAll();
        }
        return Collections.unmodifiableList(this.configurations);
    }

    @Nullable
    public Configuration findConfigurationByName(String name2) {
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            Configuration ideConfiguration = this.myApplicationState.get(name2);
            if (ideConfiguration != null) {
                return ideConfiguration;
            }
        } else {
            Configuration configuration = ConfigurationManager.findConfigurationByName(this.configurations, name2);
            if (configuration != null) {
                return configuration;
            }
        }
        return ConfigurationManager.findConfigurationByName(StructuralSearchUtil.getPredefinedTemplates(), name2);
    }

    @Nullable
    private static Configuration findConfigurationByName(Collection<Configuration> configurations, String name2) {
        return configurations.stream().filter(config -> config.getName().equals(name2)).findFirst().orElse(null);
    }

    @Nullable
    private static Configuration findConfiguration(@NotNull Collection<Configuration> configurations, Configuration configuration) {
        return configurations.stream().filter(c -> {
            if (configuration instanceof ReplaceConfiguration) {
                return c instanceof ReplaceConfiguration && c.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern()) && c.getReplaceOptions().getReplacement().equals(configuration.getReplaceOptions().getReplacement());
            }
            return c instanceof SearchConfiguration && c.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern());
        }).findFirst().orElse(null);
    }

    @NotNull
    public List<Configuration> getHistoryConfigurations() {
        return Collections.unmodifiableList(this.historyConfigurations);
    }

    public boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration) {
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            return ConfigurationManager.showSaveTemplateAsDialog(newConfiguration, this.myProject, n -> this.myApplicationState.get((String)n) != null, c -> {
                this.myApplicationState.add((Configuration)c);
                this.configurations.remove(c);
                this.configurations.add((Configuration)c);
            });
        }
        return ConfigurationManager.showSaveTemplateAsDialog(this.configurations, newConfiguration, this.myProject);
    }

    public static boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration, @NotNull Project project2, @NotNull Predicate<String> nameExistsPredicate, @NotNull Consumer<Configuration> namedConfigurationConsumer) {
        int answer;
        String name2 = ConfigurationManager.showInputDialog(newConfiguration.getName(), project2);
        while (name2 != null && nameExistsPredicate.test(name2) && (answer = Messages.showYesNoDialog((Project)project2, (String)SSRBundle.message("overwrite.message", new Object[0]), (String)SSRBundle.message("overwrite.title", name2), (String)"Replace", (String)Messages.CANCEL_BUTTON, (Icon)Messages.getQuestionIcon())) != 0) {
            name2 = ConfigurationManager.showInputDialog(name2, project2);
        }
        if (name2 != null) {
            newConfiguration.setName(name2);
            namedConfigurationConsumer.accept(newConfiguration.copy());
            return true;
        }
        return false;
    }

    public static boolean showSaveTemplateAsDialog(@NotNull Collection<Configuration> configurations, @NotNull Configuration newConfiguration, @NotNull Project project2) {
        return ConfigurationManager.showSaveTemplateAsDialog(newConfiguration, project2, n -> ConfigurationManager.findConfigurationByName(configurations, n) != null, c -> {
            configurations.remove(c);
            configurations.add((Configuration)c);
        });
    }

    @Nullable
    private static String showInputDialog(@NotNull String initial, @NotNull Project project2) {
        return Messages.showInputDialog((Project)project2, (String)SSRBundle.message("template.name.button", new Object[0]), (String)SSRBundle.message("save.template.description.button", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)initial, null);
    }

    @State(name="StructuralSearch", storages={@Storage(value="structuralSearch.xml")})
    private static class ConfigurationManagerState
    implements PersistentStateComponent<Element> {
        public final Map<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();

        private ConfigurationManagerState() {
        }

        public static ConfigurationManagerState getInstance() {
            return (ConfigurationManagerState)ServiceManager.getService(ConfigurationManagerState.class);
        }

        public static ConfigurationManagerState getInstance(Project project2) {
            return (ConfigurationManagerState)ServiceManager.getService((Project)project2, ConfigurationManagerState.class);
        }

        public void add(Configuration configuration) {
            configuration.getMatchOptions().setScope(null);
            this.configurations.put(configuration.getName(), configuration);
        }

        public Configuration get(String name2) {
            return this.configurations.get(name2);
        }

        public void remove(String name2) {
            this.configurations.remove(name2);
        }

        public Collection<Configuration> getAll() {
            return Collections.unmodifiableCollection(this.configurations.values());
        }

        @Nullable
        public Element getState() {
            Element element = new Element("state");
            for (Configuration configuration : this.configurations.values()) {
                ConfigurationManager.saveConfiguration(element, configuration);
            }
            return element;
        }

        public void loadState(@NotNull Element state) {
            for (Element child : state.getChildren()) {
                Configuration configuration = ConfigurationManager.readConfiguration(child);
                if (configuration == null) continue;
                this.configurations.put(configuration.getName(), configuration);
            }
        }
    }
}

