/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.TextFieldWithAutoCompletionWithBrowseButton;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.util.StructuralSearchScriptScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditVarConstraintsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog");
    private final CompiledPattern myCompiledPattern;
    private final StructuralSearchProfile myProfile;
    private IntegerField maxoccurs;
    private JCheckBox applyWithinTypeHierarchy;
    private JCheckBox notRegexp;
    private EditorTextField regexp;
    private IntegerField minoccurs;
    private JPanel mainForm;
    private JList<String> parameterList;
    private JCheckBox partOfSearchResults;
    private JCheckBox notExprType;
    private EditorTextField regexprForExprType;
    private final Configuration myConfiguration;
    private JCheckBox exprTypeWithinHierarchy;
    private final List<String> variables;
    private JCheckBox wholeWordsOnly;
    private JCheckBox formalArgTypeWithinHierarchy;
    private JCheckBox invertFormalArgType;
    private EditorTextField formalArgType;
    private ComponentWithBrowseButton<EditorTextField> customScriptCode;
    private TextFieldWithAutoCompletionWithBrowseButton withinTextField;
    private JPanel containedInConstraints;
    private JCheckBox invertWithin;
    private JPanel expressionConstraints;
    private JPanel occurencePanel;
    private JPanel textConstraintsPanel;
    private JLabel myRegExHelpLabel;
    private TextFieldWithAutoCompletionWithBrowseButton referenceTargetTextField;
    private JPanel referenceTargetConstraints;
    private JBCheckBox invertReferenceTarget;
    private JPanel expectedTypeConstraints;
    private JPanel scriptConstraints;
    private final Project myProject;

    EditVarConstraintsDialog(final Project project2, Configuration configuration, List<String> _variables, final FileType fileType) {
        super(project2, true);
        this.myProject = project2;
        this.variables = _variables;
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        final MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.myCompiledPattern = PatternCompiler.compilePattern(project2, matchOptions, false);
        this.myProfile = StructuralSearchUtil.getProfileByFileType(fileType);
        this.setTitle(SSRBundle.message("editvarcontraints.edit.variables", new Object[0]));
        this.regexp.getDocument().addDocumentListener((DocumentListener)new MyDocumentListener(this.notRegexp, this.wholeWordsOnly));
        this.regexp.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                EditVarConstraintsDialog.this.applyWithinTypeHierarchy.setEnabled(e.getDocument().getTextLength() > 0 && fileType == StdFileTypes.JAVA);
            }
        });
        this.minoccurs.setMinValue(0);
        this.minoccurs.setDefaultValue(Integer.valueOf(0));
        this.minoccurs.setDefaultValueText("0");
        this.maxoccurs.setMinValue(0);
        this.maxoccurs.setDefaultValue(Integer.valueOf(Integer.MAX_VALUE));
        this.maxoccurs.setDefaultValueText(SSRBundle.message("editvarcontraints.unlimited", new Object[0]));
        this.minoccurs.getValueEditor().addListener(newValue -> {
            if (this.maxoccurs.getValue() < newValue) {
                this.maxoccurs.setValue(newValue);
            }
        });
        this.maxoccurs.getValueEditor().addListener(newValue -> {
            if (this.minoccurs.getValue() > newValue) {
                this.minoccurs.setValue(newValue);
            }
        });
        this.regexprForExprType.getDocument().addDocumentListener((DocumentListener)new MyDocumentListener(this.exprTypeWithinHierarchy, this.notExprType));
        this.formalArgType.getDocument().addDocumentListener((DocumentListener)new MyDocumentListener(this.formalArgTypeWithinHierarchy, this.invertFormalArgType));
        List<String> names = ConfigurationManager.getInstance(project2).getAllConfigurationNames();
        this.withinTextField.setAutoCompletionItems(names);
        this.withinTextField.addActionListener(new SelectTemplateListener(project2, this.withinTextField));
        this.referenceTargetTextField.setAutoCompletionItems(names);
        this.referenceTargetTextField.addActionListener(new SelectTemplateListener(project2, this.referenceTargetTextField));
        if (!this.variables.contains("__context__")) {
            this.variables.add("__context__");
        }
        this.parameterList.setModel((ListModel<String>)new AbstractListModel<String>(){

            @Override
            public String getElementAt(int index) {
                return (String)EditVarConstraintsDialog.this.variables.get(index);
            }

            @Override
            public int getSize() {
                return EditVarConstraintsDialog.this.variables.size();
            }
        });
        this.parameterList.setSelectionMode(0);
        this.parameterList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            boolean rollingBackSelection;

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (this.rollingBackSelection) {
                    this.rollingBackSelection = false;
                    return;
                }
                String var = (String)EditVarConstraintsDialog.this.parameterList.getSelectedValue();
                if (EditVarConstraintsDialog.this.validateParameters()) {
                    EditVarConstraintsDialog.this.copyValuesFromUI(EditVarConstraintsDialog.this.myConfiguration.getCurrentVariableName());
                    ApplicationManager.getApplication().runWriteAction(() -> EditVarConstraintsDialog.this.copyValuesToUI(var));
                    EditVarConstraintsDialog.this.myConfiguration.setCurrentVariableName(var);
                } else {
                    this.rollingBackSelection = true;
                    EditVarConstraintsDialog.this.parameterList.setSelectedIndex(e.getFirstIndex() == EditVarConstraintsDialog.this.parameterList.getSelectedIndex() ? e.getLastIndex() : e.getFirstIndex());
                }
            }
        });
        this.parameterList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name2 = (String)value;
                if ("__context__".equals(name2)) {
                    name2 = SSRBundle.message("complete.match.variable.name", new Object[0]);
                }
                if (EditVarConstraintsDialog.isReplacementVariable(name2)) {
                    name2 = EditVarConstraintsDialog.stripReplacementVarDecoration(name2);
                }
                return super.getListCellRendererComponent((JList<?>)list, name2, index, isSelected, cellHasFocus);
            }
        });
        this.customScriptCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                ArrayList variableNames = ContainerUtil.newArrayList(matchOptions.getVariableConstraintNames());
                variableNames.add("__log__");
                EditScriptDialog dialog = new EditScriptDialog(project2, ((EditorTextField)EditVarConstraintsDialog.this.customScriptCode.getChildComponent()).getText(), variableNames);
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    ((EditorTextField)EditVarConstraintsDialog.this.customScriptCode.getChildComponent()).setText(dialog.getScriptText());
                }
            }
        });
        this.init();
        if (!this.variables.isEmpty()) {
            String variableName = configuration.getCurrentVariableName();
            configuration.setCurrentVariableName(null);
            int selectedIndex = variableName != null ? Math.max(0, this.variables.indexOf(variableName)) : 0;
            this.parameterList.setSelectedIndex(selectedIndex);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.parameterList;
    }

    static String stripReplacementVarDecoration(String name2) {
        name2 = name2.substring(0, name2.length() - "$replacement".length());
        return name2;
    }

    static boolean isReplacementVariable(String name2) {
        return name2.endsWith("$replacement");
    }

    boolean validateParameters() {
        if (!(!Registry.is((String)"ssr.use.regexp.to.specify.type") || this.validateRegExp(this.regexprForExprType) && this.validateRegExp(this.formalArgType))) {
            return false;
        }
        return this.validateRegExp(this.regexp) && this.validateWithin() && this.validateCounts() && this.validateScript();
    }

    protected JComponent createCenterPanel() {
        return this.mainForm;
    }

    protected void doOKAction() {
        if (this.validateParameters()) {
            this.copyValuesFromUI(this.myConfiguration.getCurrentVariableName());
            super.doOKAction();
        }
    }

    void copyValuesFromUI(@Nullable String varName) {
        if (varName == null) {
            return;
        }
        if (EditVarConstraintsDialog.isReplacementVariable(varName)) {
            this.saveScriptInfo(EditVarConstraintsDialog.getOrAddReplacementVariableDefinition(varName, this.myConfiguration));
            return;
        }
        MatchVariableConstraint varInfo = UIUtil.getOrAddVariableConstraint(varName, this.myConfiguration);
        varInfo.setRegExp(this.regexp.getDocument().getText());
        varInfo.setInvertRegExp(this.notRegexp.isSelected());
        varInfo.setMinCount(this.minoccurs.getValue());
        varInfo.setMaxCount(this.maxoccurs.getValue());
        varInfo.setWithinHierarchy(this.applyWithinTypeHierarchy.isSelected());
        varInfo.setInvertRegExp(this.notRegexp.isSelected());
        boolean target = this.partOfSearchResults.isSelected();
        if (target) {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name2 : matchOptions.getVariableConstraintNames()) {
                if (name2.equals(varName)) continue;
                matchOptions.getVariableConstraint(name2).setPartOfSearchResults(false);
            }
        }
        varInfo.setPartOfSearchResults(target);
        varInfo.setInvertExprType(this.notExprType.isSelected());
        varInfo.setNameOfExprType(this.regexprForExprType.getDocument().getText());
        varInfo.setExprTypeWithinHierarchy(this.exprTypeWithinHierarchy.isSelected());
        varInfo.setWholeWordsOnly(this.wholeWordsOnly.isSelected());
        varInfo.setInvertFormalType(this.invertFormalArgType.isSelected());
        varInfo.setFormalArgTypeWithinHierarchy(this.formalArgTypeWithinHierarchy.isSelected());
        varInfo.setNameOfFormalArgType(this.formalArgType.getDocument().getText());
        this.saveScriptInfo(varInfo);
        String withinConstraint = this.withinTextField.getText().trim();
        Configuration configuration = ConfigurationManager.getInstance(this.myProject).findConfigurationByName(withinConstraint);
        varInfo.setWithinConstraint(configuration != null || withinConstraint.isEmpty() ? withinConstraint : '\"' + withinConstraint + '\"');
        varInfo.setInvertWithinConstraint(this.invertWithin.isSelected());
        String referenceTargetConstraint = this.referenceTargetTextField.getText().trim();
        Configuration configuration2 = ConfigurationManager.getInstance(this.myProject).findConfigurationByName(referenceTargetConstraint);
        varInfo.setReferenceConstraint(configuration2 != null || referenceTargetConstraint.isEmpty() ? referenceTargetConstraint : '\"' + referenceTargetConstraint + '\"');
        varInfo.setInvertReference(this.invertReferenceTarget.isSelected());
    }

    private static ReplacementVariableDefinition getOrAddReplacementVariableDefinition(String varName, Configuration configuration) {
        String realVariableName;
        ReplaceOptions replaceOptions = configuration.getReplaceOptions();
        ReplacementVariableDefinition variableDefinition = replaceOptions.getVariableDefinition(realVariableName = EditVarConstraintsDialog.stripReplacementVarDecoration(varName));
        if (variableDefinition == null) {
            variableDefinition = new ReplacementVariableDefinition();
            variableDefinition.setName(realVariableName);
            replaceOptions.addVariableDefinition(variableDefinition);
        }
        return variableDefinition;
    }

    private void saveScriptInfo(NamedScriptableDefinition varInfo) {
        varInfo.setScriptCodeConstraint("\"" + ((EditorTextField)this.customScriptCode.getChildComponent()).getText() + "\"");
    }

    void copyValuesToUI(String varName) {
        if (varName == null) {
            return;
        }
        if (EditVarConstraintsDialog.isReplacementVariable(varName)) {
            ReplacementVariableDefinition definition = this.myConfiguration.getReplaceOptions().getVariableDefinition(EditVarConstraintsDialog.stripReplacementVarDecoration(varName));
            this.restoreScriptCode(definition);
            this.textConstraintsPanel.setVisible(false);
            this.occurencePanel.setVisible(false);
            this.expressionConstraints.setVisible(false);
            this.partOfSearchResults.setVisible(false);
            this.containedInConstraints.setVisible(false);
            this.referenceTargetConstraints.setVisible(false);
            this.scriptConstraints.setVisible(true);
            return;
        }
        List<PsiElement> nodes = this.myCompiledPattern.getVariableNodes(varName);
        boolean completePattern = "__context__".equals(varName);
        boolean text = this.myProfile.isApplicableConstraint("TEXT", nodes, completePattern, false);
        this.textConstraintsPanel.setVisible(text);
        this.applyWithinTypeHierarchy.setVisible(text && this.myProfile.isApplicableConstraint("TEXT HIERARCHY", nodes, completePattern, false));
        boolean minZero = this.myProfile.isApplicableConstraint("MINIMUM ZERO", nodes, completePattern, false);
        boolean maxUnlimited = this.myProfile.isApplicableConstraint("MAXIMUM UNLIMITED", nodes, completePattern, false);
        if (minZero || maxUnlimited) {
            this.occurencePanel.setVisible(true);
            this.minoccurs.setMinValue(minZero ? 0 : 1);
            this.minoccurs.setDefaultValue(Integer.valueOf(minZero ? 0 : 1));
            this.minoccurs.setDefaultValueText(minZero ? "0" : "1");
            this.maxoccurs.setMaxValue(maxUnlimited ? Integer.MAX_VALUE : 1);
            this.maxoccurs.setDefaultValue(Integer.valueOf(maxUnlimited ? Integer.MAX_VALUE : 1));
            this.maxoccurs.setDefaultValueText(maxUnlimited ? SSRBundle.message("editvarcontraints.unlimited", new Object[0]) : "1");
        } else {
            this.occurencePanel.setVisible(false);
        }
        boolean typeComponent = this.myProfile.isApplicableConstraint("TYPE", nodes, completePattern, false);
        this.expressionConstraints.setVisible(typeComponent);
        this.expectedTypeConstraints.setVisible(typeComponent && this.myProfile.isApplicableConstraint("EXPECTED TYPE", nodes, completePattern, false));
        this.referenceTargetConstraints.setVisible(this.myProfile.isApplicableConstraint("REFERENCE", nodes, completePattern, false));
        this.partOfSearchResults.setVisible(true);
        this.containedInConstraints.setVisible(completePattern);
        this.scriptConstraints.setVisible(true);
        this.partOfSearchResults.setEnabled(!completePattern);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        MatchVariableConstraint varInfo = matchOptions.getVariableConstraint(varName);
        if (varInfo == null) {
            this.regexp.getDocument().setText((CharSequence)"");
            this.notRegexp.setSelected(false);
            this.minoccurs.setValue(Integer.valueOf(1));
            this.maxoccurs.setValue(Integer.valueOf(1));
            this.applyWithinTypeHierarchy.setSelected(false);
            this.partOfSearchResults.setSelected(UIUtil.isTarget(varName, matchOptions));
            this.regexprForExprType.getDocument().setText((CharSequence)"");
            this.notExprType.setSelected(false);
            this.exprTypeWithinHierarchy.setSelected(false);
            this.wholeWordsOnly.setSelected(false);
            this.invertFormalArgType.setSelected(false);
            this.formalArgTypeWithinHierarchy.setSelected(false);
            this.formalArgType.getDocument().setText((CharSequence)"");
            ((EditorTextField)this.customScriptCode.getChildComponent()).setText("");
            this.withinTextField.setText("");
            this.invertWithin.setSelected(false);
            this.referenceTargetTextField.setText("");
            this.invertReferenceTarget.setSelected(false);
        } else {
            this.applyWithinTypeHierarchy.setSelected(varInfo.isWithinHierarchy());
            this.regexp.getDocument().setText((CharSequence)varInfo.getRegExp());
            this.regexp.selectAll();
            this.notRegexp.setSelected(varInfo.isInvertRegExp());
            this.minoccurs.setValue(Integer.valueOf(varInfo.getMinCount()));
            this.minoccurs.selectAll();
            this.maxoccurs.setValue(Integer.valueOf(varInfo.getMaxCount()));
            this.maxoccurs.selectAll();
            this.partOfSearchResults.setSelected(UIUtil.isTarget(varName, matchOptions));
            this.exprTypeWithinHierarchy.setSelected(varInfo.isExprTypeWithinHierarchy());
            this.regexprForExprType.getDocument().setText((CharSequence)varInfo.getNameOfExprType());
            this.regexprForExprType.selectAll();
            this.notExprType.setSelected(varInfo.isInvertExprType());
            this.wholeWordsOnly.setSelected(varInfo.isWholeWordsOnly());
            this.invertFormalArgType.setSelected(varInfo.isInvertFormalType());
            this.formalArgTypeWithinHierarchy.setSelected(varInfo.isFormalArgTypeWithinHierarchy());
            this.formalArgType.getDocument().setText((CharSequence)varInfo.getNameOfFormalArgType());
            this.formalArgType.selectAll();
            this.restoreScriptCode(varInfo);
            this.withinTextField.setText(StringUtil.unquoteString((String)varInfo.getWithinConstraint()));
            this.invertWithin.setSelected(varInfo.isInvertWithinConstraint());
            this.referenceTargetTextField.setText(StringUtil.unquoteString((String)varInfo.getReferenceConstraint()));
            this.invertReferenceTarget.setSelected(varInfo.isInvertReference());
        }
    }

    private void restoreScriptCode(NamedScriptableDefinition varInfo) {
        ((EditorTextField)this.customScriptCode.getChildComponent()).setText(varInfo != null ? StringUtil.unquoteString((String)varInfo.getScriptCodeConstraint()) : "");
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog";
    }

    private boolean validateRegExp(EditorTextField field) {
        try {
            Pattern.compile(field.getText());
        }
        catch (PatternSyntaxException e) {
            return this.showError((JComponent)field, e.getDescription());
        }
        return true;
    }

    private boolean validateScript() {
        EditorTextField field = (EditorTextField)this.customScriptCode.getChildComponent();
        return this.showError((JComponent)field, ScriptSupport.checkValidScript(field.getText()));
    }

    private boolean validateWithin() {
        String within = this.withinTextField.getText();
        if (StringUtil.isEmpty((String)within)) {
            return true;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance(this.myProject);
        HashSet<String> seen = new HashSet<String>();
        Configuration configuration = configurationManager.findConfigurationByName(within);
        while (configuration != null) {
            if (!seen.add(within)) {
                return this.showError(this.withinTextField.getChildComponent(), "Pattern recursively contained within itself");
            }
            MatchVariableConstraint constraint = configuration.getMatchOptions().getVariableConstraint("__context__");
            if (constraint == null) break;
            configuration = configurationManager.findConfigurationByName(constraint.getWithinConstraint());
        }
        return true;
    }

    private boolean validateCounts() {
        try {
            this.minoccurs.validateContent();
        }
        catch (ConfigurationException e) {
            return this.showError((JComponent)this.minoccurs, SSRBundle.message("invalid.occurence.count", new Object[0]));
        }
        try {
            this.maxoccurs.validateContent();
        }
        catch (ConfigurationException e) {
            return this.showError((JComponent)this.maxoccurs, SSRBundle.message("invalid.occurence.count", new Object[0]));
        }
        return this.maxoccurs.getValue() >= this.minoccurs.getValue() || this.showError((JComponent)this.maxoccurs, SSRBundle.message("invalid.occurence.count", new Object[0]));
    }

    private boolean showError(JComponent component, String message) {
        if (message == null) {
            return true;
        }
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, AllIcons.General.BalloonError, MessageType.ERROR.getPopupBackground(), null).createBalloon();
        balloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
        Disposer.register((Disposable)this.myDisposable, (Disposable)balloon);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)component, true));
        return false;
    }

    protected String getHelpId() {
        return "reference.dialogs.search.replace.structural.editvariable";
    }

    private void createUIComponents() {
        this.regexp = this.createRegexComponent();
        if (Registry.is((String)"ssr.use.regexp.to.specify.type")) {
            this.regexprForExprType = this.createRegexComponent();
            this.formalArgType = this.createRegexComponent();
        } else {
            this.regexprForExprType = this.createTextComponent();
            this.formalArgType = this.createTextComponent();
        }
        this.customScriptCode = new ComponentWithBrowseButton((JComponent)this.createScriptComponent(), null);
        this.myRegExHelpLabel = RegExHelpPopup.createRegExLink((String)SSRBundle.message("regular.expression.help.label", new Object[0]), (Component)this.regexp, (Logger)LOG);
        this.myRegExHelpLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.withinTextField = new TextFieldWithAutoCompletionWithBrowseButton(this.myProject);
        this.referenceTargetTextField = new TextFieldWithAutoCompletionWithBrowseButton(this.myProject);
    }

    private EditorTextField createTextComponent() {
        return this.createEditorComponent("1.txt");
    }

    private EditorTextField createRegexComponent() {
        return this.createEditorComponent("1.regexp");
    }

    private EditorTextField createScriptComponent() {
        return this.createEditorComponent("1.groovy");
    }

    @NotNull
    private EditorTextField createEditorComponent(String fileName) {
        FileType fileType = EditVarConstraintsDialog.getFileType(fileName);
        Document doc = this.createDocument(fileName, fileType, "");
        return new EditorTextField(doc, this.myProject, fileType);
    }

    private Document createDocument(String fileName, FileType fileType, String text) {
        PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, fileType, (CharSequence)text, -1L, true);
        return PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
    }

    private static FileType getFileType(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        return fileType;
    }

    Editor createEditor(Project project2, String text, String fileName) {
        Language groovy = Language.findLanguageByID((String)"Groovy");
        Document doc = null;
        FileType fileType = EditVarConstraintsDialog.getFileType(fileName);
        if (groovy != null) {
            for (StructuralSearchProfile profile2 : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
                if (!profile2.isMyLanguage(groovy)) continue;
                PsiCodeFragment fragment = Objects.requireNonNull(profile2.createCodeFragment(project2, text, null));
                fragment.forceResolveScope((GlobalSearchScope)new StructuralSearchScriptScope(this.myProject));
                doc = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment);
                break;
            }
        }
        if (doc == null) {
            doc = this.createDocument(fileName, fileType, text);
        }
        Editor editor = EditorFactory.getInstance().createEditor(doc, project2);
        ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setRightMarginShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        ((EditorEx)editor).setHighlighter(HighlighterFactory.createHighlighter((FileType)fileType, (EditorColorsScheme)DefaultColorSchemesManager.getInstance().getFirstScheme(), (Project)project2));
        return editor;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        IntegerField integerField;
        IntegerField integerField2;
        JPanel jPanel4;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel5;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JPanel jPanel7;
        JBList jBList;
        JPanel jPanel8;
        this.createUIComponents();
        this.mainForm = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 9, 1, 0, 3, 3, 3, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        jPanel9.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.variables.border"), (int)0, (int)0, null, null));
        this.parameterList = jBList = new JBList();
        jPanel9.add((Component)jBList, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 6, null, new Dimension(150, 50), null));
        this.textConstraintsPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel7, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.text.constraints.border"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.text.regular.expression"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.regexp;
        jPanel7.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.applyWithinTypeHierarchy = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.apply.constraint.within.type.hierarchy"));
        jPanel7.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.notRegexp = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel7.add((Component)jCheckBox8, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.wholeWordsOnly = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.whole.words.only"));
        jPanel7.add((Component)jCheckBox7, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.expressionConstraints = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel6, new GridConstraints(5, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.expression.constraints.border"), (int)0, (int)0, null, null));
        EditorTextField editorTextField2 = this.regexprForExprType;
        jPanel6.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.exprTypeWithinHierarchy = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.apply.constraint.within.type.hierarchy"));
        jPanel6.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.notExprType = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.text.regular.expression.for.java.expression.type"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.expectedTypeConstraints = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.text.regular.expression.for.formal.argument.type.of.the.method"));
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField3 = this.formalArgType;
        jPanel5.add((Component)editorTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.formalArgTypeWithinHierarchy = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.apply.constraint.within.type.hierarchy"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.invertFormalArgType = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.partOfSearchResults = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.this.variable.is.target.of.the.search"));
        jPanel8.add((Component)jCheckBox2, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.occurencePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel4, new GridConstraints(3, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.occurrences.count.border"), (int)0, (int)0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.minimum.count"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.minoccurs = integerField2 = new IntegerField();
        integerField2.setCanBeEmpty(true);
        integerField2.setText("1");
        jPanel4.add((Component)integerField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), new Dimension(50, -1)));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.maximum.count"));
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.maxoccurs = integerField = new IntegerField();
        integerField.setCanBeEmpty(true);
        integerField.setColumns(0);
        integerField.setText("1");
        jPanel4.add((Component)integerField, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(80, -1), new Dimension(80, -1)));
        this.containedInConstraints = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.within.pattern.border"), (int)0, (int)0, null, null));
        TextFieldWithAutoCompletionWithBrowseButton textFieldWithAutoCompletionWithBrowseButton = this.withinTextField;
        jPanel3.add((Component)((Object)textFieldWithAutoCompletionWithBrowseButton), new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/SSRBundle").getString("search.template"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.invertWithin = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel6 = this.myRegExHelpLabel;
        jPanel8.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.scriptConstraints = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel2, new GridConstraints(6, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.script.constraints.border"), (int)0, (int)0, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/SSRBundle").getString("script.option.text"));
        jPanel2.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComponentWithBrowseButton<EditorTextField> componentWithBrowseButton = this.customScriptCode;
        jPanel2.add((Component)componentWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.referenceTargetConstraints = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel, new GridConstraints(4, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.reference.target.constraints.border"), (int)0, (int)0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/SSRBundle").getString("search.template"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithAutoCompletionWithBrowseButton textFieldWithAutoCompletionWithBrowseButton2 = this.referenceTargetTextField;
        jPanel.add((Component)((Object)textFieldWithAutoCompletionWithBrowseButton2), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null, 2));
        this.invertReferenceTarget = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainForm;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class SelectTemplateListener
    implements ActionListener {
        private final Project myProject;
        private final TextAccessor myTextField;

        SelectTemplateListener(Project project2, TextAccessor textField) {
            this.myProject = project2;
            this.myTextField = textField;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Configuration[] selectedConfigurations;
            SelectTemplateDialog dialog = new SelectTemplateDialog(this.myProject, false, false);
            dialog.selectConfiguration(this.myTextField.getText().trim());
            dialog.show();
            if (dialog.getExitCode() == 0 && (selectedConfigurations = dialog.getSelectedConfigurations()).length == 1) {
                this.myTextField.setText(selectedConfigurations[0].getName());
            }
        }
    }

    private class EditScriptDialog
    extends DialogWrapper {
        private final Editor editor;
        private final String title;

        EditScriptDialog(Project project2, String text, Collection<String> names) {
            super(project2, true);
            this.setTitle(SSRBundle.message("edit.groovy.script.constraint.title", new Object[0]));
            this.editor = EditVarConstraintsDialog.this.createEditor(project2, text, "1.groovy");
            this.title = names.size() > 0 ? "Available variables: " + StringUtil.join(names, (String)", ") : "";
            this.init();
        }

        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.editor.getContentComponent();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.editor.getComponent(), "Center");
            if (!this.title.isEmpty()) {
                panel.add((Component)new JLabel(this.title), "South");
            }
            return panel;
        }

        String getScriptText() {
            return this.editor.getDocument().getText();
        }

        protected void dispose() {
            EditorFactory.getInstance().releaseEditor(this.editor);
            super.dispose();
        }
    }

    private static class MyDocumentListener
    implements DocumentListener {
        private final JComponent[] components;

        MyDocumentListener(JComponent ... _components) {
            this.components = _components;
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            boolean enable = e.getDocument().getTextLength() > 0;
            for (JComponent component : this.components) {
                component.setEnabled(enable);
            }
        }
    }
}

