/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeInfo {
    public static final FileTypeInfo[] EMPTY_ARRAY = new FileTypeInfo[0];
    private static final Pattern CLEANUP = Pattern.compile("(?i)\\s+file(?:s)?$");
    private final FileType myFileType;
    private final Language myDialect;
    private final String myContext;
    private final boolean myEnabled;
    private final String myDescription;

    public FileTypeInfo(@NotNull FileType fileType, @Nullable Language dialect, @Nullable String context, boolean enabled, boolean duplicated) {
        this.myFileType = fileType;
        this.myDialect = dialect;
        this.myContext = context;
        this.myEnabled = enabled;
        this.myDescription = FileTypeInfo.getDescription(fileType, duplicated);
    }

    @NotNull
    public FileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public Language getDialect() {
        return this.myDialect;
    }

    @Nullable
    public String getContext() {
        return this.myContext;
    }

    @NotNull
    public String getText() {
        if (this.myDialect != null) {
            return this.myDialect.getDisplayName();
        }
        if (this.myContext != null) {
            return this.myContext + " Context";
        }
        return this.myFileType.getName();
    }

    @NotNull
    public String getSearchText() {
        if (this.myDialect != null) {
            return this.myDialect.getDisplayName();
        }
        return this.myFileType.getName();
    }

    @NotNull
    public String getFullText() {
        if (this.myDialect != null) {
            return this.myDescription + " - " + this.myDialect.getDisplayName();
        }
        if (this.myContext != null) {
            return this.myDescription + " - " + this.myContext + " Context";
        }
        return this.myDescription;
    }

    public boolean isNested() {
        return this.myDialect != null || this.myContext != null;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isEqualTo(@NotNull FileType fileType, @Nullable Language dialect, @Nullable String context) {
        return Objects.equals(this.myFileType, fileType) && Objects.equals(this.myDialect, dialect) && Objects.equals(this.myContext, context);
    }

    @NotNull
    private static String getDescription(@NotNull FileType fileType, boolean duplicated) {
        String description = fileType.getDescription();
        String trimmedDescription = StringUtil.capitalizeWords((String)CLEANUP.matcher(description).replaceAll(""), (boolean)true);
        if (!duplicated) {
            return trimmedDescription;
        }
        return trimmedDescription + " (" + fileType.getName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileTypeInfo)) {
            return false;
        }
        FileTypeInfo info = (FileTypeInfo)o;
        return Objects.equals(this.myFileType, info.myFileType) && Objects.equals(this.myDialect, info.myDialect) && Objects.equals(this.myContext, info.myContext);
    }

    public int hashCode() {
        return Objects.hash(this.myFileType, this.myDialect, this.myContext);
    }

    public String toString() {
        return this.getFullText();
    }
}

