/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeSelector
extends ComboBox<FileTypeInfo> {
    public FileTypeSelector(@NotNull List<FileType> types) {
        super(FileTypeSelector.createModel(types));
        this.setRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        new MySpeedSearch(this);
    }

    @Nullable
    public FileTypeInfo getSelectedItem() {
        return (FileTypeInfo)super.getSelectedItem();
    }

    @Nullable
    public FileType getSelectedFileType() {
        FileTypeInfo info = (FileTypeInfo)super.getSelectedItem();
        return info != null ? info.getFileType() : null;
    }

    public void setSelectedItem(@NotNull FileType type, @Nullable Language dialect, @Nullable String context) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            FileTypeInfo info = (FileTypeInfo)model.getElementAt(i);
            if (!info.isEqualTo(type, dialect, context)) continue;
            this.setSelectedItem(info);
            return;
        }
    }

    public void setSelectedItem(Object anObject) {
        MyComboBoxModel model;
        int index;
        FileTypeInfo selectedInfo;
        if (anObject instanceof FileTypeInfo && !(selectedInfo = (FileTypeInfo)anObject).isEnabled() && (index = (model = (MyComboBoxModel)this.getModel()).getIndexOf(selectedInfo)) >= 0 && index + 1 < model.getSize()) {
            FileTypeInfo nextInfo = (FileTypeInfo)model.getElementAt(index + 1);
            super.setSelectedItem((Object)nextInfo);
            return;
        }
        super.setSelectedItem(anObject);
    }

    @NotNull
    private static DefaultComboBoxModel<FileTypeInfo> createModel(List<FileType> types) {
        ArrayList<FileTypeInfo> infos = new ArrayList<FileTypeInfo>();
        for (FileType fileType : types) {
            String[] contextNames;
            boolean duplicated = FileTypeSelector.isDuplicated(fileType, types);
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(fileType);
            if (profile2 instanceof StructuralSearchProfileBase && (contextNames = ((StructuralSearchProfileBase)profile2).getContextNames()).length != 0) {
                infos.add(new FileTypeInfo(fileType, null, null, false, duplicated));
                for (String contextName : contextNames) {
                    infos.add(new FileTypeInfo(fileType, null, contextName, true, duplicated));
                }
                continue;
            }
            infos.add(new FileTypeInfo(fileType, null, null, true, duplicated));
            if (!(fileType instanceof LanguageFileType)) continue;
            Language language = ((LanguageFileType)fileType).getLanguage();
            Language[] languageDialects = LanguageUtil.getLanguageDialects((Language)language);
            Arrays.sort(languageDialects, Comparator.comparing(Language::getDisplayName));
            for (Language dialect : languageDialects) {
                infos.add(new FileTypeInfo(fileType, dialect, null, true, duplicated));
            }
        }
        return new MyComboBoxModel(infos);
    }

    private static boolean isDuplicated(@NotNull FileType fileType, @NotNull List<FileType> types) {
        String description = fileType.getDescription();
        for (FileType type : types) {
            if (type == fileType || !description.equals(type.getDescription())) continue;
            return true;
        }
        return false;
    }

    private static class MySpeedSearch
    extends ComboboxSpeedSearch {
        MySpeedSearch(FileTypeSelector comboBox) {
            super((JComboBox)((Object)comboBox));
        }

        protected String getElementText(Object element) {
            return ((FileTypeInfo)element).getSearchText();
        }
    }

    private static class MyCellRenderer
    extends ListCellRendererWrapper<FileTypeInfo> {
        private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
        private static final Icon WIDE_EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)32, (int)18));

        private MyCellRenderer() {
        }

        public void customize(JList list, FileTypeInfo info, int index, boolean selected, boolean hasFocus) {
            if (info == null) {
                return;
            }
            if (info.isNested() && index >= 0) {
                this.setIcon(WIDE_EMPTY_ICON);
                this.setText(info.getText());
            } else {
                this.setIcon(MyCellRenderer.getFileTypeIcon(info));
                this.setText(info.getFullText());
            }
        }

        @NotNull
        private static Icon getFileTypeIcon(FileTypeInfo info) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(EMPTY_ICON, 0);
            Icon icon = info.getFileType().getIcon();
            if (icon != null) {
                layeredIcon.setIcon(icon, 1);
            }
            return layeredIcon;
        }
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel<FileTypeInfo> {
        MyComboBoxModel(List<FileTypeInfo> infos) {
            super(infos.toArray(FileTypeInfo.EMPTY_ARRAY));
        }
    }
}

