/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.find.FindBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.plugin.ui.DirectoryComboBoxWithButtons;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePanel
extends JPanel {
    private static final Condition<ScopeDescriptor> SCOPE_FILTER = descriptor2 -> IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(descriptor2.getDisplay()) || !(descriptor2.getScope() instanceof ModuleWithDependenciesScope);
    private final Project myProject;
    private SearchScope myScope;
    private NullableConsumer<? super SearchScope> myConsumer;
    Scopes.Type myScopeType;
    final ActionToolbarImpl myToolbar;
    final JPanel myScopeDetailsPanel = new JPanel(new CardLayout());
    private final ModulesComboBox myModulesComboBox = new ModulesComboBox();
    private final DirectoryComboBoxWithButtons myDirectoryComboBox;
    private final ScopeChooserCombo myScopesComboBox = new ScopeChooserCombo();

    public ScopePanel(@NotNull Project project2) {
        super(null);
        this.myProject = project2;
        Module[] allModules = ModuleManager.getInstance((Project)project2).getModules();
        this.myModulesComboBox.setModules(Arrays.asList(allModules));
        if (allModules.length > 0) {
            this.myModulesComboBox.setSelectedModule(allModules[0]);
        }
        this.myModulesComboBox.addItemListener(e -> this.setScopeFromUI(Scopes.Type.MODULE));
        this.myScopesComboBox.init(project2, true, false, (Object)"", SCOPE_FILTER);
        this.myScopesComboBox.getComboBox().addItemListener(e -> this.setScopeFromUI(Scopes.Type.NAMED));
        this.myDirectoryComboBox = new DirectoryComboBoxWithButtons(this.myProject);
        this.myDirectoryComboBox.setCallback(() -> this.setScopeFromUI(Scopes.Type.DIRECTORY));
        this.myScopeDetailsPanel.add(Scopes.Type.PROJECT.toString(), new JLabel());
        this.myScopeDetailsPanel.add(Scopes.Type.MODULE.toString(), ScopePanel.shrinkWrap((JComponent)this.myModulesComboBox));
        this.myScopeDetailsPanel.add(Scopes.Type.DIRECTORY.toString(), this.myDirectoryComboBox);
        this.myScopeDetailsPanel.add(Scopes.Type.NAMED.toString(), ScopePanel.shrinkWrap((JComponent)this.myScopesComboBox));
        this.myScopeDetailsPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)(UIUtil.isUnderDefaultMacTheme() ? 0 : 3)));
        boolean fullVersion = !PlatformUtils.isDataGrip();
        AnAction[] actions = fullVersion ? (AnAction[])ContainerUtil.ar((Object[])new ScopeToggleAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.project", (Object[])new Object[0]), Scopes.Type.PROJECT), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.module", (Object[])new Object[0]), Scopes.Type.MODULE), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED)}) : (AnAction[])ContainerUtil.ar((Object[])new ScopeToggleAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY)});
        DefaultActionGroup scopeActionGroup = new DefaultActionGroup(actions);
        this.myToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("ScopePanel", (ActionGroup)scopeActionGroup, true);
        this.myToolbar.setForceMinimumSize(true);
        this.myToolbar.setLayoutPolicy(0);
        this.setScope(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent((Component)this.myToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, 25).addComponent(this.myScopeDetailsPanel));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent((Component)this.myToolbar).addComponent(this.myScopeDetailsPanel));
    }

    private static JComponent shrinkWrap(JComponent component) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)component, "West");
        wrapper.add(Box.createHorizontalGlue(), "Center");
        return wrapper;
    }

    public void setRecentDirectories(@NotNull List<String> recentDirectories) {
        this.myDirectoryComboBox.setRecentDirectories(recentDirectories);
    }

    public void setScope(@Nullable SearchScope selectedScope) {
        if (selectedScope instanceof LocalSearchScope && selectedScope.getDisplayName().startsWith("Hierarchy of ")) {
            selectedScope = null;
        }
        this.myScope = selectedScope == null ? GlobalSearchScope.projectScope((Project)this.myProject) : selectedScope;
        this.myScopeType = Scopes.getType(this.myScope);
        if (selectedScope instanceof ModuleWithDependenciesScope) {
            ModuleWithDependenciesScope scope = (ModuleWithDependenciesScope)selectedScope;
            this.myModulesComboBox.setSelectedModule(scope.getModule());
        } else if (selectedScope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)selectedScope;
            VirtualFile directory = directoryScope.getDirectory();
            this.myDirectoryComboBox.setDirectory(directory);
            this.myDirectoryComboBox.setRecursive(directoryScope.isWithSubdirectories());
        } else if (selectedScope != null) {
            this.myScopesComboBox.init(this.myProject, true, false, (Object)selectedScope.getDisplayName(), SCOPE_FILTER);
        }
        this.myToolbar.updateActionsImmediately();
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.myScopeType.toString());
    }

    public void setScopeConsumer(@Nullable NullableConsumer<? super SearchScope> consumer) {
        this.myConsumer = consumer;
    }

    @Nullable
    public SearchScope getScope() {
        return this.myScope;
    }

    void setScopeFromUI(@NotNull Scopes.Type type) {
        switch (type) {
            case PROJECT: {
                this.myScope = GlobalSearchScope.projectScope((Project)this.myProject);
                break;
            }
            case MODULE: {
                Module module2 = this.myModulesComboBox.getSelectedModule();
                if (module2 == null) {
                    return;
                }
                this.myScope = GlobalSearchScope.moduleScope((Module)module2);
                this.myModulesComboBox.requestFocus();
                break;
            }
            case DIRECTORY: {
                VirtualFile directory = this.myDirectoryComboBox.getDirectory();
                this.myScope = directory == null ? null : GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)directory, (boolean)this.myDirectoryComboBox.isRecursive());
                this.myDirectoryComboBox.getComboBox().requestFocus();
                break;
            }
            case NAMED: {
                this.myScope = this.myScopesComboBox.getSelectedScope();
                this.myScopesComboBox.requestFocus();
            }
        }
        if (this.myConsumer != null) {
            this.myConsumer.consume((Object)this.myScope);
        }
    }

    class ScopeToggleAction
    extends ToggleAction {
        private final Scopes.Type myScopeType;

        ScopeToggleAction(@NotNull String text, Scopes.Type scopeType) {
            super(text, null, EmptyIcon.ICON_0);
            this.myScopeType = scopeType;
            this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myScopeType == ScopePanel.this.myScopeType;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (state) {
                ((CardLayout)ScopePanel.this.myScopeDetailsPanel.getLayout()).show(ScopePanel.this.myScopeDetailsPanel, this.myScopeType.toString());
                ScopePanel.this.myScopeType = this.myScopeType;
                ScopePanel.this.setScopeFromUI(this.myScopeType);
                ScopePanel.this.myToolbar.updateActionsImmediately();
            }
        }

        public boolean displayTextInToolbar() {
            return true;
        }
    }
}

