/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchContext {
    private final Project myProject;
    private final PsiFile myFile;
    private final Editor myEditor;

    public SearchContext(@NotNull Project project2) {
        this.myProject = project2;
        this.myFile = null;
        this.myEditor = null;
    }

    public SearchContext(DataContext context) {
        this.myProject = (Project)ObjectUtils.coalesce((Object)CommonDataKeys.PROJECT.getData(context), (Object)ProjectManager.getInstance().getDefaultProject());
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (!(vFile == null || file != null && vFile.equals(file.getContainingFile().getVirtualFile()))) {
            file = PsiManager.getInstance((Project)this.myProject).findFile(vFile);
        }
        this.myFile = file;
        this.myEditor = (Editor)CommonDataKeys.EDITOR.getData(context);
    }

    @Nullable
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }
}

