/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        String selectedText;
        if (editor.getUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY) == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '$' && !StringUtil.isEmpty((String)(selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText())) && !selectedText.contains("$")) {
            boolean multipleCarets;
            Document document2 = editor.getDocument();
            SmartList rangeMarkers = new SmartList();
            rangeMarkers.add(document2.createRangeMarker(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
            CaretModel caretModel = editor.getCaretModel();
            boolean bl = multipleCarets = caretModel.getCaretCount() != 1;
            if (!multipleCarets) {
                PsiTreeUtil.processElements((PsiElement)file, arg_0 -> StructuralSearchTypedHandler.lambda$beforeSelectionRemoved$0(selectedText, (List)rangeMarkers, document2, arg_0));
            }
            String newText = c + selectedText + c;
            boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
            for (RangeMarker marker : rangeMarkers) {
                if (!marker.isValid()) continue;
                document2.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)newText);
                if (!multipleCarets) continue;
                int startOffset = marker.getStartOffset() + 1;
                int endOffset = startOffset + selectedText.length();
                selectionModel.setSelection(ltrSelection ? startOffset : endOffset, ltrSelection ? endOffset : startOffset);
                caretModel.moveToOffset(ltrSelection ? endOffset : startOffset);
            }
            if (!multipleCarets) {
                SmartList newCaretStates = new SmartList();
                for (RangeMarker marker : rangeMarkers) {
                    int startOffset = marker.getStartOffset() + 1;
                    int endOffset = startOffset + selectedText.length();
                    LogicalPosition selectionStart = editor.offsetToLogicalPosition(ltrSelection ? startOffset : endOffset);
                    LogicalPosition selectionEnd = editor.offsetToLogicalPosition(ltrSelection ? endOffset : startOffset);
                    LogicalPosition caretPosition = editor.offsetToLogicalPosition(ltrSelection ? endOffset : startOffset);
                    CaretState state = new CaretState(caretPosition, selectionStart, selectionEnd);
                    newCaretStates.add(state);
                }
                caretModel.setCaretsAndSelections((List)newCaretStates);
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.beforeSelectionRemoved(c, project2, editor, file);
    }

    private static /* synthetic */ boolean lambda$beforeSelectionRemoved$0(String selectedText, List rangeMarkers, Document document2, PsiElement element) {
        if (StructuralSearchUtil.isIdentifier(element) && element.getText().equals(selectedText)) {
            rangeMarkers.add(document2.createRangeMarker(element.getTextRange()));
        }
        return true;
    }
}

