/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.StructuralReplaceAction;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TooltipWithClickableLinks;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    private static final String MODIFY_EDITOR_CONTENT = SSRBundle.message("modify.editor.content.command.name", new Object[0]);
    @NonNls
    private static final String SS_GROUP = "structuralsearchgroup";
    public static final NotificationGroup SSR_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)SSRBundle.message("structural.search.title", new Object[0]), (String)ToolWindowId.FIND);
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";

    @NotNull
    public static Editor createEditor(Document doc, Project project2, boolean editable, @Nullable TemplateContextType contextType) {
        return UIUtil.createEditor(doc, project2, editable, false, contextType);
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project2, boolean editable, boolean addToolTipForVariableHandler, @Nullable TemplateContextType contextType) {
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project2) : EditorFactory.getInstance().createViewer(doc, project2);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color c = globalScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (c == null) {
                c = globalScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(c);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        if (addToolTipForVariableHandler) {
            SubstitutionShortInfoHandler.install(editor, null);
        }
        return editor;
    }

    public static JComponent createOptionLine(JComponent ... options) {
        JPanel tmp = new JPanel();
        tmp.setLayout(new BoxLayout(tmp, 0));
        for (int i = 0; i < options.length; ++i) {
            if (i != 0) {
                tmp.add(Box.createHorizontalStrut(10));
            }
            tmp.add(options[i]);
        }
        tmp.add(Box.createHorizontalGlue());
        return tmp;
    }

    public static void setContent(Editor editor, String text) {
        String value = text != null ? text : "";
        Document document2 = editor.getDocument();
        CommandProcessor.getInstance().executeCommand(editor.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> document2.replaceString(0, document2.getTextLength(), (CharSequence)value)), MODIFY_EDITOR_CONTENT, (Object)SS_GROUP);
    }

    public static void setContent(EditorTextField editor, String text) {
        String value = text != null ? text : "";
        Document document2 = editor.getDocument();
        CommandProcessor.getInstance().executeCommand(editor.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> document2.replaceString(0, document2.getTextLength(), (CharSequence)value)), MODIFY_EDITOR_CONTENT, (Object)SS_GROUP);
    }

    public static void invokeAction(Configuration config, SearchContext context) {
        if (config instanceof SearchConfiguration) {
            StructuralSearchAction.triggerAction(config, context);
        } else {
            StructuralReplaceAction.triggerAction(config, context);
        }
    }

    public static void updateHighlighter(Editor editor, StructuralSearchProfile profile2) {
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)profile2.getTemplateContextType());
    }

    public static MatchVariableConstraint getOrAddVariableConstraint(String varName, Configuration configuration) {
        MatchVariableConstraint varInfo = configuration.getMatchOptions().getVariableConstraint(varName);
        if (varInfo == null) {
            varInfo = new MatchVariableConstraint();
            varInfo.setName(varName);
            configuration.getMatchOptions().addVariableConstraint(varInfo);
        }
        return varInfo;
    }

    public static boolean isTarget(String varName, MatchOptions matchOptions) {
        if ("__context__".equals(varName)) {
            for (String name2 : matchOptions.getVariableConstraintNames()) {
                if (name2.equals("__context__") || !matchOptions.getVariableConstraint(name2).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint constraint = matchOptions.getVariableConstraint(varName);
        if (constraint == null) {
            return false;
        }
        return constraint.isPartOfSearchResults();
    }

    @NotNull
    public static JComponent createCompleteMatchInfo(Supplier<? extends Configuration> configurationProducer) {
        return UIUtil.installCompleteMatchInfo(new JLabel(AllIcons.Actions.ListFiles), configurationProducer, null);
    }

    @NotNull
    public static JComponent installCompleteMatchInfo(final JLabel completeMatchInfo, final Supplier<? extends Configuration> configurationProducer, final Consumer<String> linkConsumer) {
        completeMatchInfo.putClientProperty(IdeTooltip.TOOLTIP_DISMISS_DELAY_KEY, 20000);
        completeMatchInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent ignore) {
                Configuration configuration = (Configuration)configurationProducer.get();
                if (configuration == null) {
                    return;
                }
                MatchOptions matchOptions = configuration.getMatchOptions();
                if (matchOptions.getSearchPattern().isEmpty()) {
                    return;
                }
                MatchVariableConstraint constraint = UIUtil.getOrAddVariableConstraint("__context__", configuration);
                if (UIUtil.isTarget("__context__", matchOptions)) {
                    constraint.setPartOfSearchResults(true);
                }
                boolean link = linkConsumer != null && !"__context__".equals(configuration.getCurrentVariableName());
                String text = SSRBundle.message("complete.match.variable.tooltip.message", SubstitutionShortInfoHandler.getShortParamString(constraint, link));
                HyperlinkListener listener = e -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && linkConsumer != null) {
                        linkConsumer.accept("__context__");
                        IdeTooltipManager.getInstance().hideCurrentNow(true);
                    }
                };
                TooltipWithClickableLinks tooltip = new TooltipWithClickableLinks((JComponent)completeMatchInfo, text, listener);
                Rectangle bounds = completeMatchInfo.getBounds();
                tooltip.setHint(true).setExplicitClose(true).setPreferredPosition(Balloon.Position.below).setPoint(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height));
                IdeTooltipManager.getInstance().show((IdeTooltip)tooltip, true);
                if (linkConsumer == null) {
                    configuration.setCurrentVariableName("__context__");
                }
            }
        });
        return completeMatchInfo;
    }

    public static EditorTextField createTextComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.txt", project2);
    }

    public static EditorTextField createRegexComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.regexp", project2);
    }

    public static EditorTextField createScriptComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.groovy", project2);
    }

    @NotNull
    public static EditorTextField createEditorComponent(String text, String fileName, Project project2) {
        return new EditorTextField(text, project2, UIUtil.getFileType(fileName));
    }

    private static FileType getFileType(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        return fileType;
    }
}

