/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.plugin.ui.filters.Filter;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.SimpleColoredComponent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilterAction
extends AnAction
implements Filter {
    private static final AtomicInteger myFilterCount = new AtomicInteger();
    protected final SimpleColoredComponent myLabel = new SimpleColoredComponent();
    protected final FilterTable myTable;
    private final int myPosition;

    protected FilterAction(@Nullable String text, FilterTable table) {
        super(text);
        this.myTable = table;
        this.myPosition = myFilterCount.incrementAndGet();
    }

    @Override
    public final int position() {
        return this.myPosition;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        this.initFilter();
        this.myTable.addFilter(this);
    }

    public final SimpleColoredComponent getRenderer() {
        if (!this.hasFilter()) {
            this.myTable.removeFilter(this);
        }
        this.myLabel.clear();
        this.setLabel(this.myLabel);
        return this.myLabel;
    }

    protected abstract void setLabel(SimpleColoredComponent var1);

    public abstract boolean hasFilter();

    public void initFilter() {
    }

    public abstract void clearFilter();

    public abstract boolean isApplicable(List<PsiElement> var1, boolean var2, boolean var3);
}

