/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.jetbrains.annotations.NotNull;

public class ScriptFilter
extends FilterAction {
    public ScriptFilter(FilterTable filterTable) {
        super("Script", filterTable);
    }

    @Override
    public boolean hasFilter() {
        return !StringUtil.isEmpty((String)this.myTable.getConstraint().getScriptCodeConstraint());
    }

    @Override
    public void clearFilter() {
        this.myTable.getConstraint().setScriptCodeConstraint("");
    }

    @Override
    public boolean isApplicable(List<PsiElement> nodes, boolean completePattern, boolean target) {
        return true;
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        component.append("script=").append(StringUtil.unquoteString((String)this.myTable.getConstraint().getScriptCodeConstraint()));
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor(this.myTable.getConstraint(), this.myTable.getConstraintChangedCallback()){
            private final JLabel myLabel;
            private final EditorTextField myTextField;
            private ContextHelpLabel myHelpLabel;
            {
                this.myLabel = new JLabel("script=");
                this.myTextField = UIUtil.createScriptComponent("", ScriptFilter.this.myTable.getProject());
            }

            @Override
            protected void layoutComponents() {
                new ExpandableEditorSupport(this.myTextField){

                    @NotNull
                    protected ExpandableSupport.Content prepare(@NotNull EditorTextField field, @NotNull Function<? super String, String> onShow) {
                        ExpandableSupport.Content popup = super.prepare(field, onShow);
                        popup.getContentComponent().setPreferredSize(new Dimension(600, 150));
                        return popup;
                    }
                };
                CharSequence[] variableNames = new String[]{"__context__", "__log__"};
                this.myHelpLabel = ContextHelpLabel.create((String)("<p>Use GroovyScript IntelliJ API to filter the search results.<p>Available variables: " + String.join((CharSequence)", ", variableNames)));
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.myLabel).addComponent((Component)this.myTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLabel).addComponent((Component)this.myTextField).addComponent((Component)this.myHelpLabel));
            }

            @Override
            protected void loadValues() {
                this.myTextField.setText(StringUtil.unquoteString((String)this.myConstraint.getScriptCodeConstraint()));
            }

            @Override
            protected void saveValues() {
                this.myConstraint.setScriptCodeConstraint('\"' + this.myTextField.getText() + '\"');
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }
}

