/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class TextFilter
extends FilterAction {
    boolean showHierarchy;

    public TextFilter(FilterTable filterTable) {
        super("Text", filterTable);
    }

    @Override
    public boolean hasFilter() {
        MatchVariableConstraint constraint = this.myTable.getConstraint();
        return !StringUtil.isEmpty((String)constraint.getRegExp()) || constraint.isWithinHierarchy();
    }

    @Override
    public void clearFilter() {
        MatchVariableConstraint constraint = this.myTable.getConstraint();
        constraint.setRegExp("");
        constraint.setWholeWordsOnly(false);
        constraint.setWithinHierarchy(false);
    }

    @Override
    public boolean isApplicable(List<PsiElement> nodes, boolean completePattern, boolean target) {
        StructuralSearchProfile profile2 = this.myTable.getProfile();
        this.showHierarchy = profile2.isApplicableConstraint("TEXT HIERARCHY", nodes, completePattern, target);
        return profile2.isApplicableConstraint("TEXT", nodes, completePattern, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint constraint = this.myTable.getConstraint();
        this.myLabel.append("text=");
        if (constraint.isInvertRegExp()) {
            this.myLabel.append("!");
        }
        this.myLabel.append(constraint.getRegExp());
        if (constraint.isWholeWordsOnly()) {
            this.myLabel.append(", whole words", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (constraint.isWithinHierarchy()) {
            this.myLabel.append(", within hierarchy", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor(this.myTable.getConstraint(), this.myTable.getConstraintChangedCallback()){
            private final EditorTextField myTextField;
            private final JCheckBox myWordsCheckBox;
            private final JCheckBox myHierarchyCheckBox;
            private final JLabel myTextLabel;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myTextField = UIUtil.createRegexComponent("", TextFilter.this.myTable.getProject());
                this.myWordsCheckBox = new JCheckBox("Words", false);
                this.myHierarchyCheckBox = new JCheckBox("Within type hierarchy", false);
                this.myTextLabel = new JLabel("text=");
                this.myHelpLabel = ContextHelpLabel.create((String)"<p>Text of the match is checked against the provided pattern.<p>Use \"!\" to invert the pattern.<p>Regular expressions are supported.");
            }

            @Override
            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myTextLabel).addComponent((Component)this.myTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel)).addGroup(layout.createSequentialGroup().addComponent(this.myWordsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myHierarchyCheckBox)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myTextLabel).addComponent((Component)this.myTextField).addComponent((Component)this.myHelpLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myWordsCheckBox).addComponent(this.myHierarchyCheckBox)));
            }

            @Override
            protected void loadValues() {
                this.myTextField.setText((this.myConstraint.isInvertRegExp() ? "!" : "") + this.myConstraint.getRegExp());
                this.myWordsCheckBox.setSelected(this.myConstraint.isWholeWordsOnly());
                this.myHierarchyCheckBox.setSelected(this.myConstraint.isWithinHierarchy());
                this.myHierarchyCheckBox.setVisible(TextFilter.this.showHierarchy);
            }

            @Override
            public void saveValues() {
                String text = this.myTextField.getText();
                if (text.startsWith("!")) {
                    this.myConstraint.setRegExp(text.substring(1));
                    this.myConstraint.setInvertRegExp(true);
                } else {
                    this.myConstraint.setRegExp(text);
                    this.myConstraint.setInvertRegExp(false);
                }
                this.myConstraint.setWholeWordsOnly(this.myWordsCheckBox.isSelected());
                this.myConstraint.setWithinHierarchy(this.myHierarchyCheckBox.isSelected());
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }
}

