/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;

public class SmartPsiPointer {
    private SmartPsiElementPointer pointer;

    public SmartPsiPointer(PsiElement element) {
        this.pointer = element != null ? SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element) : null;
    }

    public VirtualFile getFile() {
        return this.pointer != null ? this.pointer.getVirtualFile() : null;
    }

    public int getOffset() {
        PsiElement element = this.getElement();
        return element == null ? -1 : element.getTextRange().getStartOffset();
    }

    public int getLength() {
        PsiElement element = this.getElement();
        return element == null ? 0 : element.getTextRange().getEndOffset();
    }

    public PsiElement getElement() {
        return this.pointer != null ? this.pointer.getElement() : null;
    }

    public void clear() {
        this.pointer = null;
    }

    public Project getProject() {
        PsiElement element = this.getElement();
        return element == null ? null : element.getProject();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SmartPsiPointer)) {
            return false;
        }
        SmartPsiPointer ref = (SmartPsiPointer)o;
        return ref.pointer.equals(this.pointer);
    }

    public int hashCode() {
        PsiElement element = this.getElement();
        return element == null ? 0 : element.hashCode();
    }
}

