/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.task.EmptyCompileScopeBuildTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsProjectTaskRunner
extends ProjectTaskRunner {
    private static final Logger LOG = Logger.getInstance(JpsProjectTaskRunner.class);
    public static final Key<Object> EXECUTION_SESSION_ID_KEY = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY;

    public void run(@NotNull Project project2, final @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks2) {
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
                context.fileGenerated(outputRoot, relativePath);
            }
        });
        CompileStatusNotification compileNotification = (aborted, errors, warnings, compileContext) -> {
            context.putUserData(CompileContextImpl.CONTEXT_KEY, (Object)compileContext);
            if (callback != null) {
                callback.finished(new ProjectTaskResult(aborted, errors, warnings));
            }
            connection.disconnect();
        };
        Map<Class<? extends ProjectTask>, List<ProjectTask>> taskMap = JpsProjectTaskRunner.groupBy(tasks2);
        JpsProjectTaskRunner.runModulesResourcesBuildTasks(project2, context, compileNotification, taskMap);
        JpsProjectTaskRunner.runModulesBuildTasks(project2, context, compileNotification, taskMap);
        JpsProjectTaskRunner.runFilesBuildTasks(project2, compileNotification, taskMap);
        JpsProjectTaskRunner.runEmptyBuildTask(project2, context, compileNotification, taskMap);
        JpsProjectTaskRunner.runArtifactsBuildTasks(project2, context, compileNotification, taskMap);
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        return projectTask instanceof ModuleBuildTask || projectTask instanceof EmptyCompileScopeBuildTask || projectTask instanceof ProjectModelBuildTask && ((ProjectModelBuildTask)projectTask).getBuildableElement() instanceof Artifact;
    }

    public static Map<Class<? extends ProjectTask>, List<ProjectTask>> groupBy(@NotNull Collection<? extends ProjectTask> tasks2) {
        return tasks2.stream().collect(Collectors.groupingBy(o -> {
            if (o instanceof ModuleFilesBuildTask) {
                return ModuleFilesBuildTask.class;
            }
            if (o instanceof ModuleResourcesBuildTask) {
                return ModuleResourcesBuildTask.class;
            }
            if (o instanceof ModuleBuildTask) {
                return ModuleBuildTask.class;
            }
            if (o instanceof ProjectModelBuildTask) {
                return ProjectModelBuildTask.class;
            }
            if (o instanceof EmptyCompileScopeBuildTask) {
                return EmptyCompileScopeBuildTask.class;
            }
            return o.getClass();
        }));
    }

    private static void runModulesBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks = tasksMap.get(ModuleBuildTask.class);
        if (ContainerUtil.isEmpty((Collection)buildTasks)) {
            return;
        }
        ModulesBuildSettings modulesBuildSettings = JpsProjectTaskRunner.assembleModulesBuildSettings(buildTasks);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        if (modulesBuildSettings.isRebuild()) {
            compilerManager.rebuild(compileNotification);
        } else {
            CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, modulesBuildSettings.modules, modulesBuildSettings.includeDependentModules, modulesBuildSettings.includeRuntimeDependencies);
            if (modulesBuildSettings.isIncrementalBuild) {
                compilerManager.make(scope, compileNotification);
            } else {
                compilerManager.compile(scope, compileNotification);
            }
        }
    }

    private static void runEmptyBuildTask(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks = tasksMap.get(EmptyCompileScopeBuildTask.class);
        if (ContainerUtil.isEmpty((Collection)buildTasks)) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, Collections.EMPTY_SET, false, false);
        EmptyCompileScopeBuildTask task = (EmptyCompileScopeBuildTask)buildTasks.iterator().next();
        if (task.isIncrementalBuild()) {
            compilerManager.make(scope, compileNotification);
        } else {
            compilerManager.compile(scope, compileNotification);
        }
    }

    private static void runModulesResourcesBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks = tasksMap.get(ModuleResourcesBuildTask.class);
        if (ContainerUtil.isEmpty((Collection)buildTasks)) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        ModulesBuildSettings modulesBuildSettings = JpsProjectTaskRunner.assembleModulesBuildSettings(buildTasks);
        CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, modulesBuildSettings.modules, modulesBuildSettings.includeDependentModules, modulesBuildSettings.includeRuntimeDependencies);
        List moduleNames = ContainerUtil.map(modulesBuildSettings.modules, Module::getName);
        CompileScopeUtil.setResourcesScopeForExternalBuild(scope, moduleNames);
        if (modulesBuildSettings.isIncrementalBuild) {
            compilerManager.make(scope, compileNotification);
        } else {
            compilerManager.compile(scope, compileNotification);
        }
    }

    private static ModulesBuildSettings assembleModulesBuildSettings(Collection<? extends ProjectTask> buildTasks) {
        boolean includeRuntimeDependencies;
        SmartList modules = new SmartList();
        List incrementalTasks = ContainerUtil.newSmartList();
        List excludeDependentTasks = ContainerUtil.newSmartList();
        List excludeRuntimeTasks = ContainerUtil.newSmartList();
        for (ProjectTask projectTask : buildTasks) {
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            modules.add(moduleBuildTask.getModule());
            if (moduleBuildTask.isIncrementalBuild()) {
                incrementalTasks.add(moduleBuildTask);
            }
            if (!moduleBuildTask.isIncludeDependentModules()) {
                excludeDependentTasks.add(moduleBuildTask);
            }
            if (moduleBuildTask.isIncludeRuntimeDependencies()) continue;
            excludeRuntimeTasks.add(moduleBuildTask);
        }
        boolean isIncrementalBuild = incrementalTasks.size() == buildTasks.size();
        boolean bl = excludeDependentTasks.size() != buildTasks.size();
        boolean bl2 = includeRuntimeDependencies = excludeRuntimeTasks.size() != buildTasks.size();
        if (!isIncrementalBuild && !incrementalTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent(incrementalTasks, "will be built ignoring incremental build setting");
        }
        if (bl && !excludeDependentTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent(excludeDependentTasks, "will be built along with dependent modules");
        }
        if (includeRuntimeDependencies && !excludeRuntimeTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent(excludeRuntimeTasks, "will be built along with runtime dependencies");
        }
        return new ModulesBuildSettings(isIncrementalBuild, bl, includeRuntimeDependencies, (Collection<Module>)modules);
    }

    private static void assertModuleBuildSettingsConsistent(Collection<ModuleBuildTask> moduleBuildTasks, String warnMsg) {
        String moduleNames = StringUtil.join(moduleBuildTasks, task -> task.getModule().getName(), (String)", ");
        LOG.warn("Module" + (moduleBuildTasks.size() > 1 ? "s" : "") + " : '" + moduleNames + "' " + warnMsg);
    }

    private static CompileScope createScope(CompilerManager compilerManager, ProjectTaskContext context, Collection<Module> modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        RunConfiguration configuration;
        CompositeScope scope;
        CompositeScope compositeScope = scope = !modules.isEmpty() ? compilerManager.createModulesCompileScope(modules.toArray(Module.EMPTY_ARRAY), includeDependentModules, includeRuntimeDependencies) : new CompositeScope(CompileScope.EMPTY_ARRAY);
        if (context.isAutoRun()) {
            CompileDriver.setCompilationStartedAutomatically(scope);
        }
        if ((configuration = context.getRunConfiguration()) != null) {
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_KEY, configuration);
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY, configuration.getType().getId());
        }
        ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, context.getSessionId());
        return scope;
    }

    private static void runFilesBuildTasks(@NotNull Project project2, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection filesTargets = tasksMap.get(ModuleFilesBuildTask.class);
        if (!ContainerUtil.isEmpty((Collection)filesTargets)) {
            VirtualFile[] files = (VirtualFile[])filesTargets.stream().flatMap(target -> Stream.of(((ModuleFilesBuildTask)target).getFiles())).toArray(VirtualFile[]::new);
            CompilerManager.getInstance((Project)project2).compile(files, compileNotification);
        }
    }

    private static void runArtifactsBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks = tasksMap.get(ProjectModelBuildTask.class);
        if (!ContainerUtil.isEmpty((Collection)buildTasks)) {
            SmartList toMake = new SmartList();
            SmartList toCompile = new SmartList();
            for (ProjectTask buildProjectTask : buildTasks) {
                ProjectModelBuildTask buildTask = (ProjectModelBuildTask)buildProjectTask;
                ProjectModelBuildableElement buildableElement = buildTask.getBuildableElement();
                if (!(buildableElement instanceof Artifact)) continue;
                if (buildTask.isIncrementalBuild()) {
                    toMake.add((Artifact)buildableElement);
                    continue;
                }
                toCompile.add((Artifact)buildableElement);
            }
            JpsProjectTaskRunner.buildArtifacts(project2, (List<Artifact>)toMake, context.getSessionId(), compileNotification, false);
            JpsProjectTaskRunner.buildArtifacts(project2, (List<Artifact>)toCompile, context.getSessionId(), compileNotification, true);
        }
    }

    private static void buildArtifacts(@NotNull Project project2, @NotNull List<Artifact> artifacts, @Nullable Object sessionId, @Nullable CompileStatusNotification compileNotification, boolean forceArtifactBuild) {
        if (!artifacts.isEmpty()) {
            CompileScope scope = ArtifactCompileScope.createArtifactsScope(project2, artifacts, forceArtifactBuild);
            ArtifactsWorkspaceSettings.getInstance(project2).setArtifactsToBuild(artifacts);
            ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, sessionId);
            CompilerManager.getInstance((Project)project2).make(scope, compileNotification);
        }
    }

    private static class ModulesBuildSettings {
        final boolean isIncrementalBuild;
        final boolean includeDependentModules;
        final boolean includeRuntimeDependencies;
        final Collection<Module> modules;

        ModulesBuildSettings(boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies, Collection<Module> modules) {
            this.isIncrementalBuild = isIncrementalBuild;
            this.includeDependentModules = includeDependentModules;
            this.includeRuntimeDependencies = includeRuntimeDependencies;
            this.modules = modules;
        }

        boolean isRebuild() {
            if (!this.isIncrementalBuild && !this.modules.isEmpty()) {
                Module someModule = this.modules.iterator().next();
                Module[] projectModules = ModuleManager.getInstance((Project)someModule.getProject()).getModules();
                return projectModules.length == this.modules.size();
            }
            return false;
        }
    }
}

