/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestUtil {
    public static final String CARET_TAG = "<caret>";
    public static final String CARET_TAG_PREFIX = "<caret>".substring(0, "<caret>".length() - 1);
    public static final String SELECTION_START_TAG = "<selection>";
    public static final String SELECTION_END_TAG = "</selection>";
    public static final String BLOCK_SELECTION_START_TAG = "<block>";
    public static final String BLOCK_SELECTION_END_TAG = "</block>";
    public static final char BACKSPACE_FAKE_CHAR = '\uffff';
    public static final char SMART_ENTER_FAKE_CHAR = '\ufffe';
    public static final char SMART_LINE_SPLIT_CHAR = '\ufffd';

    public static void performTypingAction(Editor editor, char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        if (c == '\uffff') {
            EditorTestUtil.executeAction(editor, "EditorBackSpace");
        } else if (c == '\ufffe') {
            EditorTestUtil.executeAction(editor, "EditorCompleteStatement");
        } else if (c == '\ufffd') {
            EditorTestUtil.executeAction(editor, "EditorSplitLine");
        } else if (c == '\n') {
            EditorTestUtil.executeAction(editor, "EditorEnter");
        } else {
            TypedAction action = actionManager.getTypedAction();
            action.actionPerformed(editor, c, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        }
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId) {
        EditorTestUtil.executeAction(editor, actionId, false);
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId, boolean assertActionIsEnabled) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        AnAction action = actionManager.getAction(actionId);
        Assert.assertNotNull((Object)action);
        EditorTestUtil.executeAction(editor, assertActionIsEnabled, action);
    }

    public static void executeAction(@NotNull Editor editor, boolean assertActionIsEnabled, @NotNull AnAction action) {
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)EditorTestUtil.createEditorContext(editor));
        action.beforeActionPerformedUpdate(event);
        if (!event.getPresentation().isEnabled()) {
            Assert.assertFalse((String)("Action " + action + " is disabled"), (boolean)assertActionIsEnabled);
            return;
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.fireBeforeActionPerformed(action, event.getDataContext(), event);
        action.actionPerformed(event);
        actionManager.fireAfterActionPerformed(action, event.getDataContext(), event);
    }

    @NotNull
    private static DataContext createEditorContext(@NotNull Editor editor) {
        Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        Map map2 = ContainerUtil.newHashMap((Pair)Pair.create((Object)CommonDataKeys.HOST_EDITOR.getName(), (Object)hostEditor), (Pair[])new Pair[]{Pair.createNonNull((Object)CommonDataKeys.EDITOR.getName(), (Object)editor)});
        DataContext parent = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        return SimpleDataContext.getSimpleContext((Map)map2, (DataContext)parent);
    }

    public static void performReferenceCopy(Editor editor) {
        EditorTestUtil.executeAction(editor, "CopyReference", true);
    }

    public static void performPaste(Editor editor) {
        EditorTestUtil.executeAction(editor, "EditorPaste", true);
    }

    public static List<IElementType> getAllTokens(EditorHighlighter highlighter) {
        ArrayList<IElementType> tokens = new ArrayList<IElementType>();
        HighlighterIterator iterator2 = highlighter.createIterator(0);
        while (!iterator2.atEnd()) {
            tokens.add(iterator2.getTokenType());
            iterator2.advance();
        }
        return tokens;
    }

    public static int getCaretPosition(@NotNull String content) {
        return EditorTestUtil.getCaretAndSelectionPosition(content)[0];
    }

    public static int[] getCaretAndSelectionPosition(@NotNull String content) {
        String visualOffsetString;
        int caretPosInSourceFile = content.indexOf(CARET_TAG_PREFIX);
        int caretEndInSourceFile = content.indexOf(">", caretPosInSourceFile);
        int caretLength = caretEndInSourceFile - caretPosInSourceFile;
        int visualColumnOffset = 0;
        if (caretPosInSourceFile >= 0 && (visualOffsetString = content.substring(caretPosInSourceFile + CARET_TAG_PREFIX.length(), caretEndInSourceFile)).length() > 1) {
            visualColumnOffset = Integer.parseInt(visualOffsetString.substring(1));
        }
        int selectionStartInSourceFile = content.indexOf(SELECTION_START_TAG);
        int selectionEndInSourceFile = content.indexOf(SELECTION_END_TAG);
        if (selectionStartInSourceFile >= 0) {
            if (caretPosInSourceFile >= 0) {
                if (caretPosInSourceFile < selectionStartInSourceFile) {
                    selectionStartInSourceFile -= caretLength;
                    selectionEndInSourceFile -= caretLength;
                } else {
                    caretPosInSourceFile = caretPosInSourceFile < selectionEndInSourceFile ? (caretPosInSourceFile -= SELECTION_START_TAG.length()) : (caretPosInSourceFile -= SELECTION_START_TAG.length() + SELECTION_END_TAG.length());
                }
            }
            selectionEndInSourceFile -= SELECTION_START_TAG.length();
        }
        return new int[]{caretPosInSourceFile, visualColumnOffset, selectionStartInSourceFile, selectionEndInSourceFile};
    }

    public static boolean configureSoftWraps(Editor editor, int charCountToWrapAt) {
        int charWidthInPixels = 10;
        return EditorTestUtil.configureSoftWraps(editor, (charCountToWrapAt + 1) * charWidthInPixels + 1, charWidthInPixels);
    }

    public static boolean configureSoftWraps(Editor editor, int visibleWidth, final int charWidthInPixels) {
        editor.getSettings().setUseSoftWraps(true);
        SoftWrapModelImpl model = (SoftWrapModelImpl)editor.getSoftWrapModel();
        model.setSoftWrapPainter(new SoftWrapPainter(){

            public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
                return charWidthInPixels;
            }

            public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
                return charWidthInPixels;
            }

            public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
                return charWidthInPixels;
            }

            public boolean canUse() {
                return true;
            }

            public void reinit() {
            }
        });
        model.reinitSettings();
        SoftWrapApplianceManager applianceManager = model.getApplianceManager();
        applianceManager.setWidthProvider(() -> visibleWidth);
        model.setEditorTextRepresentationHelper((EditorTextRepresentationHelper)new DefaultEditorTextRepresentationHelper(editor){

            public int charWidth(int c, int fontType) {
                return charWidthInPixels;
            }
        });
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, visibleWidth, 1000);
        applianceManager.registerSoftWrapIfNecessary();
        return !model.getRegisteredSoftWraps().isEmpty();
    }

    public static void setEditorVisibleSize(Editor editor, int widthInChars, int heightInChars) {
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, widthInChars * EditorUtil.getSpaceWidth((int)0, (Editor)editor), heightInChars * editor.getLineHeight());
    }

    public static void setEditorVisibleSizeInPixels(Editor editor, int widthInPixels, int heightInPixels) {
        Dimension size = new Dimension(widthInPixels, heightInPixels);
        ((EditorEx)editor).getScrollPane().getViewport().setExtentSize(size);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document2) {
        return EditorTestUtil.extractCaretAndSelectionMarkers(document2, true);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document2, boolean processBlockSelection) {
        return (CaretAndSelectionState)WriteCommandAction.writeCommandAction(null).compute(() -> EditorTestUtil.extractCaretAndSelectionMarkersImpl(document2, processBlockSelection));
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkersImpl(@NotNull Document document2, boolean processBlockSelection) {
        ArrayList carets = ContainerUtil.newArrayList();
        String fileText = document2.getText();
        RangeMarker blockSelectionStartMarker = null;
        RangeMarker blockSelectionEndMarker = null;
        if (processBlockSelection) {
            int blockSelectionEnd;
            int blockSelectionStart = fileText.indexOf(BLOCK_SELECTION_START_TAG);
            if ((blockSelectionStart ^ (blockSelectionEnd = fileText.indexOf(BLOCK_SELECTION_END_TAG))) < 0) {
                throw new IllegalArgumentException("Both block selection opening and closing tag must be present");
            }
            if (blockSelectionStart >= 0) {
                blockSelectionStartMarker = document2.createRangeMarker(blockSelectionStart, blockSelectionStart);
                blockSelectionEndMarker = document2.createRangeMarker(blockSelectionEnd, blockSelectionEnd);
                document2.deleteString(blockSelectionStartMarker.getStartOffset(), blockSelectionStartMarker.getStartOffset() + BLOCK_SELECTION_START_TAG.length());
                document2.deleteString(blockSelectionEndMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset() + BLOCK_SELECTION_END_TAG.length());
            }
        }
        boolean multiCaret = StringUtil.getOccurrenceCount((String)document2.getText(), (String)CARET_TAG) > 1 || StringUtil.getOccurrenceCount((String)document2.getText(), (String)SELECTION_START_TAG) > 1;
        int pos = 0;
        while (pos < document2.getTextLength()) {
            RangeMarker selEndMarker;
            int selEndIndex;
            fileText = document2.getText();
            int caretIndex = fileText.indexOf(CARET_TAG, pos);
            int selStartIndex = fileText.indexOf(SELECTION_START_TAG, pos);
            if ((selStartIndex ^ (selEndIndex = fileText.indexOf(SELECTION_END_TAG, pos))) < 0) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (0 <= selEndIndex && selEndIndex < selStartIndex) {
                throw new IllegalArgumentException("Wrong order of selection opening and closing tags");
            }
            if (caretIndex < 0 && selStartIndex < 0 && selEndIndex < 0) break;
            if (multiCaret && 0 <= caretIndex && caretIndex < selStartIndex) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (multiCaret && caretIndex > selEndIndex && selEndIndex >= 0) {
                caretIndex = -1;
            }
            RangeMarker caretMarker = caretIndex >= 0 ? document2.createRangeMarker(caretIndex, caretIndex) : null;
            RangeMarker selStartMarker = selStartIndex >= 0 ? document2.createRangeMarker(selStartIndex, selStartIndex) : null;
            RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document2.createRangeMarker(selEndIndex, selEndIndex) : null;
            if (caretMarker != null) {
                document2.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_TAG.length());
            }
            if (selStartMarker != null) {
                document2.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_TAG.length());
            }
            if (selEndMarker != null) {
                document2.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_TAG.length());
            }
            LogicalPosition caretPosition = null;
            if (caretMarker != null) {
                int line = document2.getLineNumber(caretMarker.getStartOffset());
                int column = caretMarker.getStartOffset() - document2.getLineStartOffset(line);
                caretPosition = new LogicalPosition(line, column);
            }
            carets.add(new CaretInfo(caretPosition, selStartMarker == null || selEndMarker == null ? null : new TextRange(selStartMarker.getStartOffset(), selEndMarker.getEndOffset())));
            pos = Math.max(caretMarker == null ? -1 : caretMarker.getStartOffset(), selEndMarker == null ? -1 : selEndMarker.getEndOffset());
        }
        if (carets.isEmpty()) {
            carets.add(new CaretInfo(null, null));
        }
        TextRange blockSelection = null;
        if (blockSelectionStartMarker != null) {
            blockSelection = new TextRange(blockSelectionStartMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset());
        }
        return new CaretAndSelectionState(Arrays.asList(carets.toArray(new CaretInfo[0])), blockSelection);
    }

    public static void setCaretsAndSelection(Editor editor, CaretAndSelectionState caretsState) {
        CaretModel caretModel = editor.getCaretModel();
        ArrayList<CaretState> states = new ArrayList<CaretState>(caretsState.carets.size());
        for (CaretInfo caret : caretsState.carets) {
            states.add(new CaretState(caret.position == null ? null : editor.offsetToLogicalPosition(caret.getCaretOffset(editor.getDocument())), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getStartOffset()), caret.selection == null ? null : editor.offsetToLogicalPosition(caret.selection.getEndOffset())));
        }
        caretModel.setCaretsAndSelections(states);
        if (caretsState.blockSelection != null) {
            editor.getSelectionModel().setBlockSelection(editor.offsetToLogicalPosition(caretsState.blockSelection.getStartOffset()), editor.offsetToLogicalPosition(caretsState.blockSelection.getEndOffset()));
        }
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState) {
        EditorTestUtil.verifyCaretAndSelectionState(editor, caretState, null);
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretState, String message) {
        boolean hasChecks = false;
        for (int i = 0; i < caretState.carets.size(); ++i) {
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position == null && expected.selection == null) continue;
            hasChecks = true;
            break;
        }
        if (!hasChecks) {
            return;
        }
        String messageSuffix = message == null ? "" : message + ": ";
        CaretModel caretModel = editor.getCaretModel();
        ArrayList allCarets = new ArrayList(caretModel.getAllCarets());
        Assert.assertEquals((String)(messageSuffix + " Unexpected number of carets"), (long)caretState.carets.size(), (long)allCarets.size());
        for (int i = 0; i < caretState.carets.size(); ++i) {
            String caretDescription = caretState.carets.size() == 1 ? "" : "caret " + (i + 1) + "/" + caretState.carets.size() + " ";
            Caret currentCaret = (Caret)allCarets.get(i);
            int actualCaretLine = editor.getDocument().getLineNumber(currentCaret.getOffset());
            int actualCaretColumn = currentCaret.getOffset() - editor.getDocument().getLineStartOffset(actualCaretLine);
            LogicalPosition actualCaretPosition = new LogicalPosition(actualCaretLine, actualCaretColumn);
            int selectionStart = currentCaret.getSelectionStart();
            int selectionEnd = currentCaret.getSelectionEnd();
            LogicalPosition actualSelectionStart = editor.offsetToLogicalPosition(selectionStart);
            LogicalPosition actualSelectionEnd = editor.offsetToLogicalPosition(selectionEnd);
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position != null) {
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected caret position"), (Object)expected.position, (Object)actualCaretPosition);
            }
            if (expected.selection != null) {
                LogicalPosition expectedSelectionStart = editor.offsetToLogicalPosition(expected.selection.getStartOffset());
                LogicalPosition expectedSelectionEnd = editor.offsetToLogicalPosition(expected.selection.getEndOffset());
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection start"), (Object)expectedSelectionStart, (Object)actualSelectionStart);
                Assert.assertEquals((String)(messageSuffix + caretDescription + "unexpected selection end"), (Object)expectedSelectionEnd, (Object)actualSelectionEnd);
                continue;
            }
            Assert.assertFalse((String)(messageSuffix + caretDescription + "should has no selection, but was: (" + actualSelectionStart + ", " + actualSelectionEnd + ")"), (boolean)currentCaret.hasSelection());
        }
    }

    public static FoldRegion addFoldRegion(@NotNull Editor editor, int startOffset, int endOffset, String placeholder, boolean collapse) {
        FoldingModel foldingModel = editor.getFoldingModel();
        Ref ref = new Ref();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion region = foldingModel.addFoldRegion(startOffset, endOffset, placeholder);
            Assert.assertNotNull((Object)region);
            region.setExpanded(!collapse);
            ref.set((Object)region);
        });
        return (FoldRegion)ref.get();
    }

    public static Inlay addInlay(@NotNull Editor editor, int offset) {
        return EditorTestUtil.addInlay(editor, offset, false);
    }

    public static Inlay addInlay(@NotNull Editor editor, int offset, boolean relatesToPrecedingText) {
        return EditorTestUtil.addInlay(editor, offset, relatesToPrecedingText, 1);
    }

    public static Inlay addInlay(@NotNull Editor editor, int offset, boolean relatesToPrecedingText, final int widthInPixels) {
        return editor.getInlayModel().addInlineElement(offset, relatesToPrecedingText, new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Inlay inlay) {
                return widthInPixels;
            }

            public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            }
        });
    }

    public static Inlay addBlockInlay(@NotNull Editor editor, int offset) {
        return editor.getInlayModel().addBlockElement(offset, false, false, 0, new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Inlay inlay) {
                return 0;
            }

            public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            }
        });
    }

    public static void waitForLoading(Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (EditorUtil.isRealFileEditor((Editor)editor)) {
            UIUtil.dispatchAllInvocationEvents();
            while (!AsyncEditorLoader.isEditorLoaded((Editor)editor)) {
                LockSupport.parkNanos(100000000L);
                UIUtil.dispatchAllInvocationEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testUndoInEditor(@NotNull Editor editor, @NotNull Runnable runnable) {
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        Project project2 = editor.getProject();
        Assert.assertNotNull((Object)project2);
        UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)project2);
        CurrentEditorProvider savedProvider = undoManager.getEditorProvider();
        undoManager.setEditorProvider(() -> EditorTestUtil.lambda$testUndoInEditor$3((FileEditor)fileEditor));
        try {
            runnable.run();
        }
        finally {
            undoManager.setEditorProvider(savedProvider);
        }
    }

    @NotNull
    public static String getTextWithCaretsAndSelections(@NotNull Editor editor) {
        return EditorTestUtil.getTextWithCaretsAndSelections(editor, true, true);
    }

    @NotNull
    public static String getTextWithCaretsAndSelections(@NotNull Editor editor, boolean addCarets, boolean addSelections) {
        StringBuilder sb = new StringBuilder(editor.getDocument().getCharsSequence());
        ContainerUtil.reverse((List)editor.getCaretModel().getAllCarets()).forEach(caret -> ContainerUtil.reverse(EditorTestUtil.getCaretMacros(caret, addCarets, addSelections)).forEach(pair2 -> sb.insert((int)((Integer)pair2.first), (String)pair2.second)));
        return sb.toString();
    }

    @NotNull
    public static List<Pair<Integer, String>> getCaretMacros(@NotNull Caret caret, boolean position, boolean selection) {
        if (!position && !selection) {
            return Collections.emptyList();
        }
        boolean addSelection = selection && caret.hasSelection();
        ArrayList<Pair<Integer, String>> result = new ArrayList<Pair<Integer, String>>();
        if (addSelection) {
            result.add((Pair<Integer, String>)Pair.create((Object)caret.getSelectionStart(), (Object)SELECTION_START_TAG));
        }
        if (position) {
            result.add((Pair<Integer, String>)Pair.create((Object)caret.getOffset(), (Object)CARET_TAG));
        }
        if (addSelection) {
            result.add((Pair<Integer, String>)Pair.create((Object)caret.getSelectionEnd(), (Object)SELECTION_END_TAG));
        }
        return result;
    }

    private static /* synthetic */ FileEditor lambda$testUndoInEditor$3(FileEditor fileEditor) {
        return fileEditor;
    }

    public static class CaretInfo {
        @Nullable
        public final LogicalPosition position;
        @Nullable
        public final TextRange selection;

        public CaretInfo(@Nullable LogicalPosition position, @Nullable TextRange selection) {
            this.position = position;
            this.selection = selection;
        }

        public int getCaretOffset(Document document2) {
            return this.position == null ? -1 : document2.getLineStartOffset(this.position.line) + this.position.column;
        }
    }

    public static class CaretAndSelectionState {
        public final List<CaretInfo> carets;
        public final TextRange blockSelection;

        public CaretAndSelectionState(List<CaretInfo> carets, @Nullable TextRange blockSelection) {
            this.carets = carets;
            this.blockSelection = blockSelection;
        }

        public boolean hasExplicitCaret() {
            if (this.carets.isEmpty()) {
                return false;
            }
            if (this.blockSelection == null && this.carets.size() == 1) {
                CaretInfo caret = this.carets.get(0);
                return caret.position != null || caret.selection != null;
            }
            return true;
        }
    }
}

