/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ExpectedHighlightingData {
    public static final String EXPECTED_DUPLICATION_MESSAGE = "Expected duplication problem. Please remove this wrapper, if there is no such problem any more";
    private static final String ERROR_MARKER = "error";
    private static final String WARNING_MARKER = "warning";
    private static final String WEAK_WARNING_MARKER = "weak_warning";
    private static final String INFO_MARKER = "info";
    private static final String END_LINE_HIGHLIGHT_MARKER = "EOLError";
    private static final String END_LINE_WARNING_MARKER = "EOLWarning";
    private static final String INJECT_MARKER = "inject";
    private static final String SYMBOL_NAME_MARKER = "symbolName";
    private static final String LINE_MARKER = "lineMarker";
    private static final String ANY_TEXT = "*";
    private static final HighlightInfoType WHATEVER = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, HighlighterColors.TEXT);
    private static boolean isDuplicatedCheckDisabled = false;
    private static int failedDuplicationChecks = 0;
    private final Map<String, ExpectedHighlightingSet> myHighlightingTypes = new LinkedHashMap<String, ExpectedHighlightingSet>();
    private final Map<RangeMarker, LineMarkerInfo> myLineMarkerInfos = new THashMap();
    private final Document myDocument;
    private final PsiFile myFile;
    private final String myText;
    private boolean myIgnoreExtraHighlighting;
    private final ResourceBundle[] myMessageBundles;

    public ExpectedHighlightingData(@NotNull Document document2, boolean checkWarnings, boolean checkInfos) {
        this(document2, checkWarnings, false, checkInfos);
    }

    public ExpectedHighlightingData(@NotNull Document document2, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        this(document2, checkWarnings, checkWeakWarnings, checkInfos, null);
    }

    public ExpectedHighlightingData(@NotNull Document document2, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, @Nullable PsiFile file) {
        this(document2, checkWarnings, checkWeakWarnings, checkInfos, false, file, new ResourceBundle[0]);
    }

    public ExpectedHighlightingData(@NotNull Document document2, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, boolean ignoreExtraHighlighting, @Nullable PsiFile file, ResourceBundle ... messageBundles) {
        this(document2, file, messageBundles);
        this.myIgnoreExtraHighlighting = ignoreExtraHighlighting;
        if (checkWarnings) {
            this.checkWarnings();
        }
        if (checkWeakWarnings) {
            this.checkWeakWarnings();
        }
        if (checkInfos) {
            this.checkInfos();
        }
    }

    public ExpectedHighlightingData(@NotNull Document document2, @Nullable PsiFile file, ResourceBundle ... messageBundles) {
        this.myDocument = document2;
        this.myFile = file;
        this.myMessageBundles = messageBundles;
        this.myText = document2.getText();
        this.registerHighlightingType(ERROR_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, false, true));
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, false));
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, false));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, false));
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, false));
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, false));
        for (SeveritiesProvider provider2 : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (HighlightInfoType type : provider2.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity severity = type.getSeverity(null);
                this.registerHighlightingType(severity.getName(), new ExpectedHighlightingSet(severity, false, true));
            }
        }
        this.registerHighlightingType(END_LINE_HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, true, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, false));
    }

    public boolean hasLineMarkers() {
        return !this.myLineMarkerInfos.isEmpty();
    }

    public void init() {
        WriteCommandAction.runWriteCommandAction(null, () -> {
            this.extractExpectedLineMarkerSet(this.myDocument);
            this.extractExpectedHighlightsSet(this.myDocument);
            this.refreshLineMarkers();
        });
    }

    public void checkWarnings() {
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, true));
    }

    public void checkWeakWarnings() {
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, true));
    }

    public void checkInfos() {
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, true));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, true));
    }

    public void checkSymbolNames() {
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, true));
    }

    public void registerHighlightingType(@NotNull String key, @NotNull ExpectedHighlightingSet highlightingSet) {
        this.myHighlightingTypes.put(key, highlightingSet);
    }

    private void refreshLineMarkers() {
        for (Map.Entry<RangeMarker, LineMarkerInfo> entry : this.myLineMarkerInfos.entrySet()) {
            RangeMarker rangeMarker = entry.getKey();
            int startOffset = rangeMarker.getStartOffset();
            int endOffset = rangeMarker.getEndOffset();
            LineMarkerInfo value = entry.getValue();
            PsiElement element = value.getElement();
            assert (element != null) : value;
            TextRange range = new TextRange(startOffset, endOffset);
            String tooltip = value.getLineMarkerTooltip();
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(element, range, value.updatePass, GutterIconRenderer.Alignment.RIGHT, tooltip);
            entry.setValue(markerInfo);
        }
    }

    private void extractExpectedLineMarkerSet(Document document2) {
        Matcher opening;
        String text = document2.getText();
        String pat = ".*?((<lineMarker)(?: descr=\"((?:[^\"\\\\]|\\\\\")*)\")?>)(.*)";
        Pattern openingTagRx = Pattern.compile(pat, 32);
        Pattern closingTagRx = Pattern.compile("(.*?)(</lineMarker>)(.*)", 32);
        while ((opening = openingTagRx.matcher(text)).matches()) {
            int startOffset = opening.start(1);
            String descr = opening.group(3) != null ? opening.group(3) : ANY_TEXT;
            String rest = opening.group(4);
            Matcher closing = closingTagRx.matcher(rest);
            if (!closing.matches()) {
                Assert.fail((String)"Cannot find closing </lineMarker>");
            }
            document2.replaceString(startOffset, opening.end(1), (CharSequence)"");
            String content = closing.group(1);
            int endOffset = startOffset + closing.start(3);
            String endTag = closing.group(2);
            document2.replaceString(startOffset, endOffset, (CharSequence)content);
            PsiElement leaf = Objects.requireNonNull(this.myFile.findElementAt(startOffset));
            TextRange range = new TextRange(startOffset, endOffset -= endTag.length());
            String tooltip = StringUtil.unescapeStringCharacters((String)descr);
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(leaf, range, 11, GutterIconRenderer.Alignment.RIGHT, tooltip);
            this.myLineMarkerInfos.put(document2.createRangeMarker(startOffset, endOffset), markerInfo);
            text = document2.getText();
        }
    }

    private void extractExpectedHighlightsSet(Document document2) {
        String text = document2.getText();
        Set<String> markers = this.myHighlightingTypes.keySet();
        String typesRx = "(?:" + StringUtil.join(markers, (String)")|(?:") + ")";
        String openingTagRx = "<(" + typesRx + ")(?:\\s+descr=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+type=\"([0-9A-Z_]+)\")?(?:\\s+foreground=\"([0-9xa-f]+)\")?(?:\\s+background=\"([0-9xa-f]+)\")?(?:\\s+effectcolor=\"([0-9xa-f]+)\")?(?:\\s+effecttype=\"([A-Z]+)\")?(?:\\s+fonttype=\"([0-9]+)\")?(?:\\s+textAttributesKey=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+bundleMsg=\"((?:[^\"]|\\\\\"|\\\\\\\\\")*)\")?(/)?>";
        Matcher matcher = Pattern.compile(openingTagRx).matcher(text);
        int pos = 0;
        Ref textOffset = Ref.create((Object)0);
        while (matcher.find(pos)) {
            textOffset.set((Object)((Integer)textOffset.get() + matcher.start() - pos));
            pos = this.extractExpectedHighlight(matcher, text, document2, (Ref<Integer>)textOffset);
        }
    }

    private int extractExpectedHighlight(Matcher matcher, String text, Document document2, Ref<Integer> textOffset) {
        int toContinueFrom;
        boolean closed;
        document2.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + matcher.end() - matcher.start());
        int groupIdx = 1;
        String marker = matcher.group(groupIdx++);
        String descr = matcher.group(groupIdx++);
        String typeString = matcher.group(groupIdx++);
        String foregroundColor = matcher.group(groupIdx++);
        String backgroundColor = matcher.group(groupIdx++);
        String effectColor = matcher.group(groupIdx++);
        String effectType = matcher.group(groupIdx++);
        String fontType = matcher.group(groupIdx++);
        String attrKey = matcher.group(groupIdx++);
        String bundleMessage = matcher.group(groupIdx++);
        boolean bl = closed = matcher.group(groupIdx) != null;
        if (descr == null) {
            descr = ANY_TEXT;
        } else if (descr.equals("null")) {
            descr = null;
        }
        if (descr != null) {
            descr = descr.replaceAll("\\\\\\\\\"", "\"");
            descr = descr.replaceAll("\\\\\"", "\"");
        }
        HighlightInfoType type = WHATEVER;
        if (typeString != null) {
            try {
                type = this.getTypeByName(typeString);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (type == null) {
                Assert.fail((String)("Wrong highlight type: " + typeString));
            }
        }
        TextAttributes forcedAttributes = null;
        if (foregroundColor != null) {
            int ft = Integer.parseInt(fontType);
            forcedAttributes = new TextAttributes(Color.decode(foregroundColor), Color.decode(backgroundColor), Color.decode(effectColor), EffectType.valueOf((String)effectType), ft);
        }
        int rangeStart = (Integer)textOffset.get();
        if (closed) {
            toContinueFrom = matcher.end();
        } else {
            int pos = matcher.end();
            Matcher closingTagMatcher = Pattern.compile("</" + marker + ">").matcher(text);
            while (true) {
                int nextTagStart;
                if (!closingTagMatcher.find(pos)) {
                    toContinueFrom = pos;
                    break;
                }
                int n = nextTagStart = matcher.find(pos) ? matcher.start() : text.length();
                if (closingTagMatcher.start() < nextTagStart) {
                    textOffset.set((Object)((Integer)textOffset.get() + closingTagMatcher.start() - pos));
                    document2.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + closingTagMatcher.end() - closingTagMatcher.start());
                    toContinueFrom = closingTagMatcher.end();
                    break;
                }
                textOffset.set((Object)((Integer)textOffset.get() + nextTagStart - pos));
                pos = this.extractExpectedHighlight(matcher, text, document2, textOffset);
            }
        }
        ExpectedHighlightingSet expectedHighlightingSet = this.myHighlightingTypes.get(marker);
        if (expectedHighlightingSet.enabled) {
            TextAttributesKey forcedTextAttributesKey = attrKey == null ? null : TextAttributesKey.createTextAttributesKey((String)attrKey);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(rangeStart, ((Integer)textOffset.get()).intValue()).severity(expectedHighlightingSet.severity);
            if (forcedAttributes != null) {
                builder.textAttributes(forcedAttributes);
            }
            if (forcedTextAttributesKey != null) {
                builder.textAttributes(forcedTextAttributesKey);
            }
            if (bundleMessage != null) {
                descr = this.extractDescrFromBundleMessage(bundleMessage);
            }
            if (descr != null) {
                builder.description(descr);
                builder.unescapedToolTip(descr);
            }
            if (expectedHighlightingSet.endOfLine) {
                builder.endOfLine();
            }
            HighlightInfo highlightInfo = builder.createUnconditionally();
            expectedHighlightingSet.infos.add(highlightInfo);
        }
        return toContinueFrom;
    }

    @NotNull
    private String extractDescrFromBundleMessage(String bundleMessage) {
        String descr = null;
        List split = StringUtil.split((String)bundleMessage, (String)"|");
        String key = (String)split.get(0);
        List keySplit = StringUtil.split((String)key, (String)"#");
        ResourceBundle[] bundles = this.myMessageBundles;
        if (keySplit.size() == 2) {
            key = (String)keySplit.get(1);
            bundles = new ResourceBundle[]{ResourceBundle.getBundle((String)keySplit.get(0))};
        } else {
            Assert.assertEquals((String)"Format for bundleMsg attribute is: [bundleName#] bundleKey [|argument]... ", (long)1L, (long)keySplit.size());
        }
        Assert.assertTrue((String)"messageBundles must be provided for bundleMsg tags in test data", (bundles.length > 0 ? 1 : 0) != 0);
        Object[] params = split.stream().skip(1L).toArray();
        for (ResourceBundle bundle : bundles) {
            String message = CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)key, null, (Object[])params);
            if (message == null) continue;
            if (descr != null) {
                Assert.fail((String)("Key " + key + " is not unique in bundles for expected highlighting data"));
            }
            descr = message;
        }
        if (descr == null) {
            Assert.fail((String)("Can't find bundle message " + bundleMessage));
        }
        return descr;
    }

    protected HighlightInfoType getTypeByName(String typeString) throws Exception {
        Field field = HighlightInfoType.class.getField(typeString);
        return (HighlightInfoType)field.get(null);
    }

    public void checkLineMarkers(@NotNull Collection<? extends LineMarkerInfo> markerInfos, @NotNull String text) {
        String fileName = this.myFile == null ? "" : this.myFile.getName() + ": ";
        StringBuilder failMessage = new StringBuilder();
        for (LineMarkerInfo lineMarkerInfo : markerInfos) {
            if (ExpectedHighlightingData.containsLineMarker(lineMarkerInfo, this.myLineMarkerInfos.values())) continue;
            if (failMessage.length() > 0) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("extra ").append(ExpectedHighlightingData.rangeString(text, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(lineMarkerInfo.getLineMarkerTooltip()).append('\'');
        }
        for (LineMarkerInfo lineMarkerInfo : this.myLineMarkerInfos.values()) {
            if (!markerInfos.isEmpty() && ExpectedHighlightingData.containsLineMarker(lineMarkerInfo, markerInfos)) continue;
            if (failMessage.length() > 0) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("missing ").append(ExpectedHighlightingData.rangeString(text, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(lineMarkerInfo.getLineMarkerTooltip()).append('\'');
        }
        if (failMessage.length() > 0) {
            Assert.fail((String)failMessage.toString());
        }
    }

    private static boolean containsLineMarker(LineMarkerInfo info, Collection<? extends LineMarkerInfo> where) {
        String infoTooltip = info.getLineMarkerTooltip();
        for (LineMarkerInfo lineMarkerInfo : where) {
            String markerInfoTooltip;
            if (lineMarkerInfo.startOffset != info.startOffset || lineMarkerInfo.endOffset != info.endOffset || !Comparing.equal((String)infoTooltip, (String)(markerInfoTooltip = lineMarkerInfo.getLineMarkerTooltip())) && !ANY_TEXT.equals(markerInfoTooltip) && !ANY_TEXT.equals(infoTooltip)) continue;
            return true;
        }
        return false;
    }

    public void checkResult(Collection<HighlightInfo> infos, String text) {
        this.checkResult(infos, text, null);
    }

    public void checkResult(Collection<HighlightInfo> infos, String text, @Nullable String filePath2) {
        StringBuilder failMessage = new StringBuilder();
        THashSet expectedFound = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<HighlightInfo>(){

            public int computeHashCode(HighlightInfo object) {
                return object.hashCode();
            }

            public boolean equals(HighlightInfo o1, HighlightInfo o2) {
                return ExpectedHighlightingData.haveSamePresentation(o1, o2, true);
            }
        });
        if (!this.myIgnoreExtraHighlighting) {
            for (HighlightInfo info : ExpectedHighlightingData.reverseCollection(infos)) {
                ThreeState state = this.expectedInfosContainsInfo(info);
                if (state == ThreeState.NO) {
                    this.reportProblem(failMessage, text, info, "extra ");
                    failMessage.append(" [").append(info.type).append(']');
                    continue;
                }
                if (state != ThreeState.YES) continue;
                if (expectedFound.contains(info)) {
                    if (isDuplicatedCheckDisabled) {
                        ++failedDuplicationChecks;
                    } else {
                        this.reportProblem(failMessage, text, info, "duplicated ");
                    }
                }
                expectedFound.add(info);
            }
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : ExpectedHighlightingData.reverseCollection(expectedHighlights)) {
            Set expInfos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : expInfos) {
                if (ExpectedHighlightingData.infosContainsExpectedInfo(infos, expectedInfo) || !highlightingSet.enabled) continue;
                this.reportProblem(failMessage, text, expectedInfo, "missing ");
            }
        }
        if (failMessage.length() > 0) {
            VirtualFile file;
            if (filePath2 == null && this.myFile != null && (file = this.myFile.getVirtualFile()) != null) {
                filePath2 = (String)file.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
            }
            failMessage.append('\n');
            this.compareTexts(infos, text, failMessage.toString(), filePath2);
        }
    }

    private void reportProblem(@NotNull StringBuilder failMessage, @NotNull String text, @NotNull HighlightInfo info, @NotNull String messageType) {
        String fileName = this.myFile == null ? "" : this.myFile.getName() + ": ";
        int startOffset = info.startOffset;
        int endOffset = info.endOffset;
        String s = text.substring(startOffset, endOffset);
        String desc = info.getDescription();
        if (failMessage.length() > 0) {
            failMessage.append('\n');
        }
        failMessage.append(fileName).append(messageType).append(ExpectedHighlightingData.rangeString(text, startOffset, endOffset)).append(": '").append(s).append('\'');
        if (desc != null) {
            failMessage.append(" (").append(desc).append(')');
        }
    }

    private static <T> List<T> reverseCollection(Collection<T> infos) {
        return ContainerUtil.reverse((List)(infos instanceof List ? (List<Object>)infos : new ArrayList<T>(infos)));
    }

    private void compareTexts(Collection<HighlightInfo> infos, String text, String failMessage, @Nullable String filePath2) {
        String actual = ExpectedHighlightingData.composeText(this.myHighlightingTypes, infos, text, this.myMessageBundles);
        if (filePath2 != null && !this.myText.equals(actual)) {
            throw new FileComparisonFailure(failMessage, this.myText, actual, filePath2);
        }
        Assert.assertEquals((String)(failMessage + "\n"), (Object)this.myText, (Object)actual);
        Assert.fail((String)failMessage);
    }

    private static String findTag(Map<String, ExpectedHighlightingSet> types, HighlightInfo info) {
        Map.Entry entry = (Map.Entry)ContainerUtil.find(types.entrySet(), e -> ((ExpectedHighlightingSet)e.getValue()).enabled && ((ExpectedHighlightingSet)e.getValue()).severity == info.getSeverity() && ((ExpectedHighlightingSet)e.getValue()).endOfLine == info.isAfterEndOfLine());
        return entry != null ? (String)entry.getKey() : null;
    }

    @NotNull
    public static String composeText(@NotNull Map<String, ExpectedHighlightingSet> types, @NotNull Collection<HighlightInfo> infos, @NotNull String text, ResourceBundle ... messageBundles) {
        List list = infos.stream().map(info -> Pair.pair((Object)ExpectedHighlightingData.findTag(types, info), (Object)info)).filter(p -> p.first != null).collect(Collectors.toList());
        boolean showAttributesKeys = types.values().stream().flatMap(set -> ((ExpectedHighlightingSet)set).infos.stream()).anyMatch(i -> i.forcedTextAttributesKey != null);
        Collections.sort(list, (o1, o2) -> {
            int bySeverity;
            HighlightInfo i1 = (HighlightInfo)o1.second;
            HighlightInfo i2 = (HighlightInfo)o2.second;
            int byEnds = i2.endOffset - i1.endOffset;
            if (byEnds != 0) {
                return byEnds;
            }
            if (!i1.isAfterEndOfLine() && !i2.isAfterEndOfLine()) {
                int byStarts = i1.startOffset - i2.startOffset;
                if (byStarts != 0) {
                    return byStarts;
                }
            } else {
                int byEOL = Comparing.compare((boolean)i2.isAfterEndOfLine(), (boolean)i1.isAfterEndOfLine());
                if (byEOL != 0) {
                    return byEOL;
                }
            }
            if ((bySeverity = i2.getSeverity().compareTo(i1.getSeverity())) != 0) {
                return bySeverity;
            }
            return Comparing.compare((Comparable)((Object)i1.getDescription()), (Comparable)((Object)i2.getDescription()));
        });
        StringBuilder sb = new StringBuilder();
        int[] offsets = ExpectedHighlightingData.composeText(sb, list, 0, text, text.length(), -1, showAttributesKeys, messageBundles);
        sb.insert(0, text.substring(0, offsets[1]));
        return sb.toString();
    }

    @Deprecated
    public static void expectedDuplicatedHighlighting(@NotNull Runnable check) {
        try {
            isDuplicatedCheckDisabled = true;
            failedDuplicationChecks = 0;
            check.run();
        }
        finally {
            isDuplicatedCheckDisabled = false;
        }
        if (failedDuplicationChecks == 0) {
            throw new IllegalStateException(EXPECTED_DUPLICATION_MESSAGE);
        }
    }

    private static int[] composeText(StringBuilder sb, List<? extends Pair<String, HighlightInfo>> list, int index, String text, int endPos, int startPos, boolean showAttributesKeys, ResourceBundle ... messageBundles) {
        int i;
        for (i = index; i < list.size(); ++i) {
            Pair<String, HighlightInfo> pair2 = list.get(i);
            HighlightInfo info = (HighlightInfo)pair2.second;
            if (info.endOffset <= startPos) break;
            String severity = (String)pair2.first;
            HighlightInfo prev = i < list.size() - 1 ? (HighlightInfo)list.get((int)(i + 1)).second : null;
            sb.insert(0, text.substring(info.endOffset, endPos));
            sb.insert(0, "</" + severity + '>');
            endPos = info.endOffset;
            if (prev != null && prev.endOffset > info.startOffset) {
                int[] offsets = ExpectedHighlightingData.composeText(sb, list, i + 1, text, endPos, info.startOffset, showAttributesKeys, messageBundles);
                i = offsets[0] - 1;
                endPos = offsets[1];
            }
            sb.insert(0, text.substring(info.startOffset, endPos));
            String str = '<' + severity + " ";
            String bundleMsg = ExpectedHighlightingData.composeBundleMsg(info, messageBundles);
            str = bundleMsg != null ? str + "bundleMsg=\"" + StringUtil.escapeQuotes((String)bundleMsg) + '\"' : str + "descr=\"" + StringUtil.escapeQuotes((String)String.valueOf(info.getDescription())) + '\"';
            if (showAttributesKeys) {
                str = str + " textAttributesKey=\"" + info.forcedTextAttributesKey + '\"';
            }
            str = str + '>';
            sb.insert(0, str);
            endPos = info.startOffset;
        }
        return new int[]{i, endPos};
    }

    private static String composeBundleMsg(HighlightInfo info, ResourceBundle ... messageBundles) {
        String bundleKey = null;
        Object[] bundleMsgParams = null;
        block0: for (ResourceBundle bundle : messageBundles) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                boolean matched;
                Object[] parse;
                String key = keys.nextElement();
                ParsePosition position = new ParsePosition(0);
                String value = bundle.getString(key);
                if (value.contains("{0")) {
                    parse = new MessageFormat(value).parse(info.getDescription(), position);
                    matched = parse != null && info.getDescription() != null && position.getIndex() == info.getDescription().length() && position.getErrorIndex() == -1;
                } else {
                    parse = ArrayUtil.EMPTY_OBJECT_ARRAY;
                    matched = value.equals(info.getDescription());
                }
                if (!matched) continue;
                if (bundleKey != null) {
                    bundleKey = null;
                    continue block0;
                }
                bundleKey = key;
                bundleMsgParams = parse;
            }
        }
        if (bundleKey == null) {
            return null;
        }
        String bundleMsg = bundleKey;
        if (bundleMsgParams.length > 0) {
            bundleMsg = bundleMsg + '|' + StringUtil.join((Collection)ContainerUtil.map(bundleMsgParams, Objects::toString), (String)"|");
        }
        return bundleMsg;
    }

    private static boolean infosContainsExpectedInfo(Collection<? extends HighlightInfo> infos, HighlightInfo expectedInfo) {
        for (HighlightInfo highlightInfo : infos) {
            if (!ExpectedHighlightingData.matchesPattern(expectedInfo, highlightInfo, false)) continue;
            return true;
        }
        return false;
    }

    private ThreeState expectedInfosContainsInfo(HighlightInfo info) {
        if (info.getTextAttributes(null, null) == TextAttributes.ERASE_MARKER) {
            return ThreeState.UNSURE;
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            if (highlightingSet.severity != info.getSeverity()) continue;
            if (!highlightingSet.enabled) {
                return ThreeState.UNSURE;
            }
            Set infos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : infos) {
                if (!ExpectedHighlightingData.matchesPattern(expectedInfo, info, false)) continue;
                return ThreeState.YES;
            }
        }
        return ThreeState.NO;
    }

    private static boolean matchesPattern(@NotNull HighlightInfo expectedInfo, @NotNull HighlightInfo info, boolean strictMatch) {
        if (expectedInfo == info) {
            return true;
        }
        boolean typeMatches = expectedInfo.type.equals(info.type) || !strictMatch && expectedInfo.type == WHATEVER;
        boolean textAttributesMatches = Comparing.equal((Object)expectedInfo.getTextAttributes(null, null), (Object)info.getTextAttributes(null, null)) || !strictMatch && expectedInfo.forcedTextAttributes == null;
        boolean attributesKeyMatches = !strictMatch && expectedInfo.forcedTextAttributesKey == null || Objects.equals(expectedInfo.forcedTextAttributesKey, info.forcedTextAttributesKey);
        return ExpectedHighlightingData.haveSamePresentation(info, expectedInfo, strictMatch) && info.getSeverity() == expectedInfo.getSeverity() && typeMatches && textAttributesMatches && attributesKeyMatches;
    }

    private static boolean haveSamePresentation(@NotNull HighlightInfo info1, @NotNull HighlightInfo info2, boolean strictMatch) {
        return info1.startOffset == info2.startOffset && info1.endOffset == info2.endOffset && info1.isAfterEndOfLine() == info2.isAfterEndOfLine() && (Comparing.strEqual((String)info1.getDescription(), (String)info2.getDescription()) || !strictMatch && Comparing.strEqual((String)ANY_TEXT, (String)info2.getDescription()));
    }

    private static String rangeString(String text, int startOffset, int endOffset) {
        LineColumn start = StringUtil.offsetToLineColumn((CharSequence)text, (int)startOffset);
        assert (start != null) : "textLength = " + text.length() + ", startOffset = " + startOffset;
        LineColumn end = StringUtil.offsetToLineColumn((CharSequence)text, (int)endOffset);
        assert (end != null) : "textLength = " + text.length() + ", endOffset = " + endOffset;
        if (start.line == end.line) {
            return String.format("(%d:%d/%d)", start.line + 1, start.column + 1, end.column - start.column);
        }
        return String.format("(%d:%d..%d:%d)", start.line + 1, end.line + 1, start.column + 1, end.column + 1);
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final String myTooltip;

        MyLineMarkerInfo(PsiElement element, TextRange range, int updatePass, GutterIconRenderer.Alignment alignment, String tooltip) {
            super(element, range, null, updatePass, null, null, alignment);
            this.myTooltip = tooltip;
        }

        public String getLineMarkerTooltip() {
            return this.myTooltip;
        }
    }

    public static class ExpectedHighlightingSet {
        private final HighlightSeverity severity;
        private final boolean endOfLine;
        private final boolean enabled;
        private final Set<HighlightInfo> infos;

        public ExpectedHighlightingSet(@NotNull HighlightSeverity severity, boolean endOfLine, boolean enabled) {
            this.severity = severity;
            this.endOfLine = endOfLine;
            this.enabled = enabled;
            this.infos = new THashSet();
        }
    }
}

