/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.FileBasedTestCaseHelper;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataPath;
import com.intellij.testFramework.VfsTestUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase {
    protected static Editor myEditor;
    protected static PsiFile myFile;
    protected static VirtualFile myVFile;
    @Parameterized.Parameter
    public String myFileSuffix;
    @Parameterized.Parameter(value=1)
    public String myTestDataPath;

    @Override
    protected void runTest() throws Throwable {
        if (this.isRunInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), () -> {
                this.doRunTest();
                return null;
            });
        } else {
            Ref e = new Ref();
            CommandProcessor.getInstance().executeCommand(LightPlatformCodeInsightTestCase.getProject(), () -> {
                try {
                    this.doRunTest();
                }
                catch (Throwable throwable) {
                    e.set((Object)throwable);
                }
            }, null, null);
            if (e.get() != null) {
                throw (Throwable)e.get();
            }
        }
    }

    protected void doRunTest() throws Throwable {
        super.runTest();
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    protected void configureByFile(@NonNls @NotNull String filePath2) {
        try {
            String fullPath = this.getTestDataPath() + filePath2;
            File ioFile = new File(fullPath);
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            String fileText = FileUtilRt.loadFile((File)ioFile, (String)"UTF-8", (boolean)true);
            LightPlatformCodeInsightTestCase.configureFromFileText(ioFile.getName(), fileText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkCaseSensitiveFS(String fullOrRelativePath, File ioFile) throws IOException {
        fullOrRelativePath = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)fullOrRelativePath));
        if (!ioFile.getCanonicalPath().endsWith(fullOrRelativePath)) {
            throw new RuntimeException("Search for: " + fullOrRelativePath + "; but found: " + ioFile.getCanonicalPath());
        }
    }

    @NonNls
    @NotNull
    protected String getTestDataPath() {
        if (this.myTestDataPath != null) {
            return this.myTestDataPath;
        }
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NonNls @NotNull String filePath2) {
        String fullPath = this.getTestDataPath() + filePath2;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        LightPlatformCodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        return vFile;
    }

    @NotNull
    protected static Document configureFromFileText(@NonNls @NotNull String fileName, @NonNls @NotNull String fileText) {
        return LightPlatformCodeInsightTestCase.configureFromFileText(fileName, fileText, false);
    }

    @NotNull
    protected static Document configureFromFileText(@NonNls @NotNull String fileName, @NonNls @NotNull String fileText, boolean checkCaret) {
        return (Document)WriteCommandAction.writeCommandAction(null).compute(() -> {
            Document document2;
            DocumentImpl fakeDocument = new DocumentImpl(fileText);
            EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers((Document)fakeDocument);
            if (checkCaret) {
                LightPlatformCodeInsightTestCase.assertTrue((String)("No caret specified in " + fileName), (boolean)caretsState.hasExplicitCaret());
            }
            String newFileText = fakeDocument.getText();
            try {
                document2 = LightPlatformCodeInsightTestCase.setupFileEditorAndDocument(fileName, newFileText);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EditorTestUtil.setCaretsAndSelection(myEditor, caretsState);
            LightPlatformCodeInsightTestCase.setupEditorForInjectedLanguage();
            return document2;
        });
    }

    @NotNull
    protected static Editor configureFromFileTextWithoutPSI(@NonNls @NotNull String fileText) {
        return (Editor)WriteCommandAction.writeCommandAction((Project)LightPlatformCodeInsightTestCase.getProject()).compute(() -> {
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            Document document2 = EditorFactory.getInstance().createDocument((CharSequence)newFileText);
            Editor editor = EditorFactory.getInstance().createEditor(document2, LightPlatformCodeInsightTestCase.getProject());
            ((EditorImpl)editor).setCaretActive();
            EditorTestUtil.setCaretsAndSelection(editor, caretsState);
            return editor;
        });
    }

    @NotNull
    protected static Editor createEditor(@NotNull VirtualFile file) {
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Editor editor = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).openTextEditor(new OpenFileDescriptor(LightPlatformCodeInsightTestCase.getProject(), file, 0), false);
        DaemonCodeAnalyzer.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).restart();
        LightPlatformCodeInsightTestCase.assertNotNull((Object)editor);
        ((EditorImpl)editor).setCaretActive();
        return editor;
    }

    @NotNull
    private static Document setupFileEditorAndDocument(@NotNull String fileName, @NotNull String fileText) throws IOException {
        EncodingProjectManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        EncodingProjectManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        PostprocessReformattingAspect.getInstance((Project)ourProject).doPostponedFormatting();
        LightPlatformCodeInsightTestCase.deleteVFile();
        myEditor = LightPlatformCodeInsightTestCase.createSaveAndOpenFile(fileName, fileText);
        myVFile = FileDocumentManager.getInstance().getFile(myEditor.getDocument());
        myFile = LightPlatformCodeInsightTestCase.getPsiManager().findFile(myVFile);
        return myEditor.getDocument();
    }

    @NotNull
    protected static Editor createSaveAndOpenFile(@NotNull String relativePath, @NotNull String fileText) {
        Editor editor = LightPlatformCodeInsightTestCase.createEditor(VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), relativePath, fileText));
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        return editor;
    }

    @NotNull
    protected static VirtualFile createAndSaveFile(@NotNull String relativePath, @NotNull String fileText) {
        return VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), relativePath, fileText);
    }

    protected static void setupEditorForInjectedLanguage() {
        if (myEditor != null) {
            Editor hostEditor = myEditor instanceof EditorWindow ? ((EditorWindow)myEditor).getDelegate() : myEditor;
            PsiFile hostFile = myFile == null ? null : InjectedLanguageManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getTopLevelFile((PsiElement)myFile);
            Ref editorWindowRef = new Ref();
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)hostEditor, (PsiFile)hostFile);
                if (caret == hostEditor.getCaretModel().getPrimaryCaret() && editor instanceof EditorWindow) {
                    editorWindowRef.set((Object)((EditorWindow)editor));
                }
            });
            if (!editorWindowRef.isNull()) {
                myEditor = (Editor)editorWindowRef.get();
                myFile = ((EditorWindow)editorWindowRef.get()).getInjectedFile();
                myVFile = myFile.getVirtualFile();
            }
        }
    }

    private static void deleteVFile() throws IOException {
        if (myVFile != null) {
            if (myVFile instanceof VirtualFileWindow) {
                myVFile = ((VirtualFileWindow)myVFile).getDelegate();
            }
            WriteAction.run(() -> {
                PsiDocumentManager.getInstance((Project)ourProject).commitAllDocuments();
                FileEditorManager.getInstance((Project)ourProject).closeFile(myVFile);
                myVFile.delete((Object)ourProject);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject());
            for (VirtualFile openFile : editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile);
            }
            LightPlatformCodeInsightTestCase.deleteVFile();
            myEditor = null;
            myFile = null;
            myVFile = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkResultByFile(@NonNls @NotNull String expectedFilePath) {
        this.checkResultByFile(null, expectedFilePath, false);
    }

    protected void checkResultByFile(@Nullable String message, @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) {
        String fileText;
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        PostprocessReformattingAspect.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            Editor editor = myEditor;
            TrailingSpacesStripper.strip((Document)editor.getDocument(), (boolean)false, (boolean)true);
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)editor);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + expectedFilePath;
        File ioFile = new File(fullPath);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message), (boolean)ioFile.exists());
        try {
            LightPlatformCodeInsightTestCase.checkCaseSensitiveFS(fullPath, ioFile);
            fileText = FileUtil.loadFile((File)ioFile, (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.checkResultByText(message, StringUtil.convertLineSeparators((String)fileText), ignoreTrailingSpaces, this.getTestDataPath() + "/" + expectedFilePath);
    }

    protected void checkResultByText(@NonNls @NotNull String expectedFileText) {
        this.checkResultByText(null, expectedFileText, false, null);
    }

    protected void checkResultByText(String message, @NotNull String expectedFileText, boolean ignoreTrailingSpaces) {
        this.checkResultByText(message, expectedFileText, ignoreTrailingSpaces, null);
    }

    protected void checkResultByText(String message, @NotNull String expectedFileText, boolean ignoreTrailingSpaces, String filePath2) {
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document2 = EditorFactory.getInstance().createDocument((CharSequence)expectedFileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)document2).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(document2);
            PostprocessReformattingAspect.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).doPostponedFormatting();
            String newFileText = document2.getText();
            PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
            String fileText1 = myFile.getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath2 != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath2);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(myEditor, carets, message);
        });
    }

    protected static void checkResultByTextWithoutPSI(String message, @NotNull Editor editor, @NotNull String fileText, boolean ignoreTrailingSpaces, String filePath2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)fakeDocument).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            String fileText1 = editor.getDocument().getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath2 != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath2);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(editor, carets, message);
        });
    }

    @NotNull
    private static String getMessage(@NonNls @NotNull String engineMessage, String userMessage) {
        if (userMessage == null) {
            return engineMessage;
        }
        return userMessage + " [" + engineMessage + "]";
    }

    protected static Editor getEditor() {
        return myEditor;
    }

    protected static PsiFile getFile() {
        return myFile;
    }

    protected static VirtualFile getVFile() {
        return myVFile;
    }

    protected static void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        if (myEditor instanceof EditorWindow) {
            Document document2 = ((DocumentWindow)myEditor.getDocument()).getDelegate();
            myFile = PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getPsiFile(document2);
            myEditor = ((EditorWindow)myEditor).getDelegate();
            myVFile = myFile.getVirtualFile();
        }
    }

    protected void caretRight() {
        LightPlatformCodeInsightTestCase.caretRight(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretRight(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction("EditorRight", editor);
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.caretUp(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretUp(@NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction("EditorUp", editor);
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void deleteLine(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteLine", editor, project2);
    }

    protected void type(@NonNls @NotNull String s) {
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void type(char c) {
        LightPlatformCodeInsightTestCase.type(c, LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void type(char c, @NotNull Editor editor, Project project2) {
        if (c == '\n') {
            LightPlatformCodeInsightTestCase.executeAction("EditorEnter", editor, project2);
        } else {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            DataContext dataContext = DataManager.getInstance().getDataContext();
            TypedAction action = actionManager.getTypedAction();
            action.actionPerformed(editor, c, dataContext);
        }
    }

    protected void backspace() {
        LightPlatformCodeInsightTestCase.backspace(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void backspace(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorBackSpace", editor, project2);
    }

    protected void ctrlShiftF7() {
        HighlightUsagesHandler.invoke((Project)LightPlatformCodeInsightTestCase.getProject(), (Editor)LightPlatformCodeInsightTestCase.getEditor(), (PsiFile)LightPlatformCodeInsightTestCase.getFile());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlW(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectWord", editor, project2);
    }

    public void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlD(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorDuplicate", editor, project2);
    }

    protected void delete() {
        LightPlatformCodeInsightTestCase.delete(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void delete(@NotNull Editor editor, Project project2) {
        LightPlatformCodeInsightTestCase.executeAction("EditorDelete", editor, project2);
    }

    protected static void home() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStart");
    }

    protected static void end() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEnd");
    }

    protected static void homeWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStartWithSelection");
    }

    protected static void endWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEndWithSelection");
    }

    protected static void copy() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCopy");
    }

    protected static void paste() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPaste");
    }

    protected static void moveCaretToPreviousWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWordWithSelection");
    }

    protected static void moveCaretToNextWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWordWithSelection");
    }

    protected static void previousWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWord");
    }

    protected static void nextWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWord");
    }

    protected static void cutLineBackward() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineBackward");
    }

    protected static void cutToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineEnd");
    }

    protected static void deleteToLineStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineStart");
    }

    protected static void deleteToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineEnd");
    }

    protected static void killToWordStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordStart");
    }

    protected static void killToWordEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordEnd");
    }

    protected static void killRegion() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRegion");
    }

    protected static void killRingSave() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRingSave");
    }

    protected static void unindent() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUnindentSelection");
    }

    protected static void selectLine() {
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectLine");
    }

    protected static void left() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeft");
    }

    protected static void right() {
        LightPlatformCodeInsightTestCase.executeAction("EditorRight");
    }

    protected static void leftWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeftWithSelection");
    }

    protected static void rightWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorRightWithSelection");
    }

    protected static void up() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUp");
    }

    protected static void down() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDown");
    }

    protected static void lineComment() {
        LightPlatformCodeInsightTestCase.executeAction("CommentByLineComment");
    }

    protected static void executeAction(@NonNls @NotNull String actionId) {
        LightPlatformCodeInsightTestCase.executeAction(actionId, LightPlatformCodeInsightTestCase.getEditor());
    }

    protected static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor) {
        LightPlatformCodeInsightTestCase.executeAction(actionId, editor, LightPlatformCodeInsightTestCase.getProject());
    }

    public static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor, Project project2) {
        CommandProcessor.getInstance().executeCommand(project2, () -> EditorTestUtil.executeAction(editor, actionId), "", null, editor.getDocument());
    }

    @NotNull
    protected static DataContext getCurrentEditorDataContext() {
        DataContext defaultContext = DataManager.getInstance().getDataContext();
        return dataId -> {
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getEditor();
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getProject();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getFile();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                PsiFile file = LightPlatformCodeInsightTestCase.getFile();
                if (file == null) {
                    return null;
                }
                Editor editor = LightPlatformCodeInsightTestCase.getEditor();
                if (editor == null) {
                    return null;
                }
                return file.findElementAt(editor.getCaretModel().getOffset());
            }
            return defaultContext.getData(dataId);
        };
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() {
        return Collections.emptyList();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params(@NotNull Class<?> klass) throws Throwable {
        LightPlatformCodeInsightTestCase testCase = (LightPlatformCodeInsightTestCase)((Object)klass.newInstance());
        if (!(testCase instanceof FileBasedTestCaseHelper)) {
            LightPlatformCodeInsightTestCase.fail((String)"Parameterized test should implement FileBasedTestCaseHelper");
        }
        try {
            PathManagerEx.replaceLookupStrategy(klass, Parameterized.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FileBasedTestCaseHelper fileBasedTestCase = (FileBasedTestCaseHelper)((Object)testCase);
        String testDataPath = testCase.getTestDataPath();
        File testDir = null;
        if (fileBasedTestCase instanceof FileBasedTestCaseHelperEx) {
            testDir = new File(testDataPath, ((FileBasedTestCaseHelperEx)fileBasedTestCase).getRelativeBasePath());
        } else {
            TestDataPath annotation = klass.getAnnotation(TestDataPath.class);
            if (annotation == null) {
                LightPlatformCodeInsightTestCase.fail((String)"TestCase should implement com.intellij.testFramework.FileBasedTestCaseHelperEx or be annotated with com.intellij.testFramework.TestDataPath");
            } else {
                String trimmedRoot = StringUtil.trimStart((String)StringUtil.trimStart((String)annotation.value(), (String)"$CONTENT_ROOT"), (String)"$PROJECT_ROOT");
                String lastPathComponent = new File(testDataPath).getName();
                int idx = trimmedRoot.indexOf(lastPathComponent);
                testDataPath = testDataPath.replace(File.separatorChar, '/') + (idx > 0 ? trimmedRoot.substring(idx + lastPathComponent.length()) : trimmedRoot);
                testDir = new File(testDataPath);
            }
        }
        File[] files = testDir.listFiles();
        if (files == null) {
            LightPlatformCodeInsightTestCase.fail((String)("Test files not found in " + testDir.getPath()));
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (File file : files) {
            String fileSuffix = fileBasedTestCase.getFileSuffix(file.getName());
            if (fileSuffix == null) continue;
            result.add(new Object[]{fileSuffix, testDataPath});
        }
        return result;
    }

    public String getName() {
        if (this.myFileSuffix != null) {
            return "test" + this.myFileSuffix;
        }
        return super.getName();
    }

    @Before
    public void before() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.setUp();
            }
            catch (Throwable e) {
                throwables[0] = e;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    @After
    public void after() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.tearDown();
            }
            catch (Throwable e) {
                throwables[0] = e;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected void runSingleTest(@NotNull Runnable testRunnable) throws Throwable {
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                testRunnable.run();
            }
            catch (Throwable e) {
                throwables[0] = e;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }
}

