/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.lang.Language;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    @NonNls
    private static final String LIGHT_PROJECT_MARK = "Light project: ";
    private static IdeaTestApplication ourApplication;
    protected static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    private static LightProjectDescriptor ourProjectDescriptor;
    private static SdkLeakTracker myOldSdks;
    private ThreadTracker myThreadTracker;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private static int ourTestCount;

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return ourModule;
    }

    @NotNull
    public static PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)ourProject);
        }
        return ourPsiManager;
    }

    @NotNull
    public static IdeaTestApplication initApplication() {
        ourApplication = IdeaTestApplication.getInstance();
        return ourApplication;
    }

    static void disposeApplication() {
        if (ourApplication != null) {
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)ourApplication));
            ourApplication = null;
        }
    }

    public static IdeaTestApplication getApplication() {
        return ourApplication;
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']", MockApplication.INSTANCES_CREATED));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']", ProjectManagerImpl.TEST_PROJECTS_CREATED));
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean mxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGcTime += mxBean.getCollectionTime();
        }
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']", totalGcTime));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount()));
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(@NotNull LightProjectDescriptor descriptor2) throws Exception {
        ourProjectDescriptor = descriptor2;
        if (ourProject != null) {
            LightPlatformTestCase.closeAndDeleteProject();
        }
        ApplicationManager.getApplication().runWriteAction(LightPlatformTestCase::cleanPersistedVFSContent);
        File projectFile = FileUtil.createTempFile((String)"light_temp", (String)".ipr");
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
        ourProject = PlatformTestCase.createProject(projectFile, LIGHT_PROJECT_MARK + buffer);
        ourPathToKeep = projectFile.getPath();
        ourPsiManager = null;
        try {
            ourProjectDescriptor.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

                @Override
                public void moduleCreated(@NotNull Module module2) {
                    ourModule = module2;
                }

                @Override
                public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                    ourSourceRoot = sourceRoot;
                }
            });
        }
        catch (Throwable e) {
            try {
                LightPlatformTestCase.closeAndDeleteProject();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw new RuntimeException(e);
        }
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            super.setUp();
            ApplicationInfoImpl.setInStressTest((boolean)this.isStressTest());
            if (this.isPerformanceTest()) {
                Timings.getStatistics();
            }
            LightPlatformTestCase.initApplication();
            ourApplication.setDataProvider(this);
            LightProjectDescriptor descriptor2 = this.getProjectDescriptor();
            LightPlatformTestCase.doSetup(descriptor2, this.configureLocalInspectionTools(), this.getTestRootDisposable());
            InjectedLanguageManagerImpl.pushInjectors((Project)LightPlatformTestCase.getProject());
            this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(() -> this.isStressTest() || ApplicationManager.getApplication() == null || ApplicationManager.getApplication() instanceof MockApplication ? null : CodeStyle.getDefaultSettings());
            CodeStyle.setTemporarySettings((Project)LightPlatformTestCase.getProject(), (CodeStyleSettings)new CodeStyleSettings());
            this.myThreadTracker = new ThreadTracker();
            ModuleRootManager.getInstance((Module)ourModule).orderEntries().getAllLibrariesAndSdkClassesRoots();
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        }));
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return new SimpleLightProjectDescriptor(this.getModuleType(), this.getProjectJDK());
    }

    public static void doSetup(@NotNull LightProjectDescriptor descriptor2, @NotNull LocalInspectionTool[] localInspectionTools, @NotNull Disposable parentDisposable) throws Exception {
        LightPlatformTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        ApplicationManager.getApplication().assertIsDispatchThread();
        myOldSdks = new SdkLeakTracker();
        boolean reusedProject = true;
        if (ourProject == null || ourProjectDescriptor == null || !ourProjectDescriptor.equals(descriptor2)) {
            LightPlatformTestCase.initProject(descriptor2);
            reusedProject = false;
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        try {
            projectManagerEx.openTestProject(ourProject);
        }
        catch (Throwable e) {
            ourProject = null;
            throw e;
        }
        if (reusedProject) {
            WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)LightPlatformTestCase.getProject()).makeRootsChange(EmptyRunnable.getInstance(), false, true));
        }
        MessageBusConnection connection = ourProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                TestCase.fail((String)"Adding modules is not permitted in light tests.");
            }
        });
        LightPlatformTestCase.clearUncommittedDocuments(LightPlatformTestCase.getProject());
        InspectionsKt.configureInspections((InspectionProfileEntry[])localInspectionTools, LightPlatformTestCase.getProject(), parentDisposable);
        LightPlatformTestCase.assertFalse((boolean)LightPlatformTestCase.getPsiManager().isDisposed());
        Boolean passed = null;
        try {
            passed = StartupManagerEx.getInstanceEx((Project)LightPlatformTestCase.getProject()).startupActivityPassed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LightPlatformTestCase.assertTrue((String)("open: " + LightPlatformTestCase.getProject().isOpen() + "; disposed:" + LightPlatformTestCase.getProject().isDisposed() + "; startup passed:" + passed + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)LightPlatformTestCase.getProject().isInitialized());
        FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager instanceof FileDocumentManagerImpl) {
            Document[] unsavedDocuments = manager.getUnsavedDocuments();
            manager.saveAllDocuments();
            ApplicationManager.getApplication().runWriteAction(() -> ((FileDocumentManagerImpl)((FileDocumentManagerImpl)manager)).dropAllUnsavedDocuments());
            LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(unsavedDocuments));
        }
        UIUtil.dispatchAllInvocationEvents();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected void enableInspectionTools(InspectionProfileEntry ... tools) {
        InspectionsKt.enableInspectionTools(LightPlatformTestCase.getProject(), this.getTestRootDisposable(), tools);
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper toolWrapper) {
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), toolWrapper, this.getTestRootDisposable());
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), tool, this.getTestRootDisposable());
    }

    @NotNull
    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = LightPlatformTestCase.getProject();
        new RunAll(() -> CodeStyle.dropTemporarySettings((Project)project2), () -> this.myCodeStyleSettingsTracker.checkForSettingsDamage(), () -> LightPlatformTestCase.doTearDown(project2, ourApplication), () -> LightPlatformTestCase.checkEditorsReleased(), () -> myOldSdks.checkForJdkTableLeaks(), () -> super.tearDown(), () -> this.myThreadTracker.checkLeak(), () -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2), () -> this.myVirtualFilePointerTracker.assertPointersAreDisposed()).run();
    }

    public static void doTearDown(@NotNull Project project2, @NotNull IdeaTestApplication application) {
        new RunAll(new ThrowableRunnable[0]).append(() -> ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue()).append(() -> CodeStyle.dropTemporarySettings((Project)project2)).append(() -> LightPlatformTestCase.checkJavaSwingTimersAreDisposed()).append(() -> UsefulTestCase.doPostponedFormatting(project2)).append(() -> LookupManager.hideActiveLookup((Project)project2)).append(() -> ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).prepareForNextTest()).append(() -> {
            if (ProjectManager.getInstance() == null) {
                throw new AssertionError((Object)"Application components damaged");
            }
        }).append(() -> WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            FileDocumentManager manager;
            if (ourSourceRoot != null) {
                try {
                    for (VirtualFile child : ourSourceRoot.getChildren()) {
                        child.delete(LightPlatformTestCase.class);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((manager = FileDocumentManager.getInstance()) instanceof FileDocumentManagerImpl) {
                ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
            }
        })).append(() -> LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed())).append(() -> {
            LightPlatformTestCase.clearEncodingManagerDocumentQueue();
            if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> LightPlatformTestCase.clearUncommittedDocuments(project2)).append(() -> ((HintManagerImpl)HintManager.getInstance()).cleanup()).append(() -> ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests()).append(() -> ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests()).append(() -> ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest()).append(() -> TemplateDataLanguageMappings.getInstance((Project)project2).cleanupForNextTest()).append(() -> ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest()).append(() -> ((StructureViewFactoryImpl)StructureViewFactory.getInstance((Project)project2)).cleanupForNextTest()).append(() -> PlatformTestCase.waitForProjectLeakingThreads(project2, 10L, TimeUnit.SECONDS)).append(() -> ProjectManagerEx.getInstanceEx().closeTestProject(project2)).append(() -> application.setDataProvider(null)).append(() -> {
            ourTestCase = null;
        }).append(() -> CompletionProgressIndicator.cleanupForNextTest()).append(() -> {
            if (ourTestCount++ % 100 == 0) {
                GCUtil.clearBeanInfoCache();
            }
        }).run();
    }

    public static void clearEncodingManagerDocumentQueue() {
        EncodingManager encodingManager = (EncodingManager)ServiceManager.getServiceIfCreated(EncodingManager.class);
        if (encodingManager instanceof EncodingManagerImpl) {
            ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
        }
    }

    private static void checkJavaSwingTimersAreDisposed() throws Exception {
        Method sharedInstance;
        Object timerQueue;
        Class<?> TimerQueueClass = Class.forName("javax.swing.TimerQueue");
        DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(TimerQueueClass, (Object)(timerQueue = (sharedInstance = ReflectionUtil.getMethod(TimerQueueClass, (String)"sharedInstance", (Class[])new Class[0])).invoke(null, new Object[0])), DelayQueue.class, (String)"queue");
        Object timer = delayQueue.peek();
        if (timer != null) {
            long delay = timer.getDelay(TimeUnit.MILLISECONDS);
            String text = "(delayed for " + delay + "ms)";
            Method getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
            Timer swingTimer = (Timer)getTimer.invoke(timer, new Object[0]);
            text = "Timer (listeners: " + Arrays.asList(swingTimer.getActionListeners()) + ") " + text;
            try {
                throw new AssertionFailedError("Not disposed java.swing.Timer: " + text + "; queue:" + timerQueue);
            }
            catch (Throwable throwable) {
                swingTimer.stop();
                throw throwable;
            }
        }
    }

    public static void clearUncommittedDocuments(@NotNull Project project2) {
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
        documentManager.clearUncommittedDocuments();
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)defaultProject)).clearUncommittedDocuments();
        }
    }

    public static void checkEditorsReleased() {
        new RunAll(() -> UIUtil.dispatchAllInvocationEvents(), () -> {
            RunAll runAll = new RunAll(new ThrowableRunnable[0]);
            for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                runAll = runAll.append(() -> EditorFactoryImpl.throwNotReleasedError((Editor)editor)).append(() -> EditorFactory.getInstance().releaseEditor(editor));
            }
            runAll.run();
        }).run();
    }

    @Override
    public final void runBare() throws Throwable {
        this.runBareImpl(this::startRunAndTear);
    }

    protected void runBareImpl(ThrowableRunnable<?> start) throws Exception {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            try {
                start.run();
            }
            finally {
                try {
                    Application application = ApplicationManager.getApplication();
                    if (application instanceof ApplicationEx) {
                        PlatformTestCase.cleanupApplicationCaches(ourProject);
                    }
                    this.resetAllFields();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }));
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(@NotNull String dataId) {
        return ourProject == null || ourProject.isDisposed() ? null : new TestDataProvider(ourProject).getData(dataId);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    @NotNull
    protected static PsiFile createFile(@NonNls @NotNull String fileName, @NonNls @NotNull String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
    }

    @NotNull
    protected static PsiFile createLightFile(@NonNls @NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
    }

    @Override
    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name2 = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + name2), (boolean)name2.startsWith("test"));
        name2 = name2.substring("test".length());
        if (!name2.isEmpty() && lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name2)) {
            name2 = Character.toLowerCase(name2.charAt(0)) + name2.substring(1);
        }
        return name2;
    }

    @NotNull
    protected static CodeStyleSettings getCurrentCodeStyleSettings() {
        return CodeStyle.getSettings((Project)LightPlatformTestCase.getProject());
    }

    @NotNull
    protected static CommonCodeStyleSettings getLanguageSettings(@NotNull Language language) {
        return LightPlatformTestCase.getCurrentCodeStyleSettings().getCommonSettings(language);
    }

    @NotNull
    protected static <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> settingsClass) {
        return (T)LightPlatformTestCase.getCurrentCodeStyleSettings().getCustomSettings(settingsClass);
    }

    protected static void commitDocument(@NotNull Document document2) {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitDocument(document2);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
    }

    protected static Document getDocument(@NotNull PsiFile file) {
        return PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).getDocument(file);
    }

    public static synchronized void closeAndDeleteProject() {
        File parent;
        if (ourProject == null) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeAndDeleteProject from under write action");
        }
        if (!ourProject.isDisposed()) {
            LightPlatformTestCase.assertEquals((Object)ourProject, (Object)ourModule.getProject());
            File ioFile = new File(ourProject.getProjectFilePath());
            if (ioFile.exists()) {
                File dir = ioFile.getParentFile();
                if (dir.getName().startsWith("unitTest_")) {
                    FileUtil.delete((File)dir);
                } else {
                    FileUtil.delete((File)ioFile);
                }
            }
        }
        LightPlatformTestCase.assertTrue((boolean)ProjectManagerEx.getInstanceEx().forceCloseProject(ourProject, true));
        LightPlatformTestCase.assertTrue((boolean)ourProject.isDisposed());
        if (ourPathToKeep != null && (parent = new File(ourPathToKeep).getParentFile()).getName().startsWith("unitTest_")) {
            parent.delete();
        }
        ourProject = null;
        LightPlatformTestCase.assertTrue((boolean)ourModule.isDisposed());
        ourModule = null;
        if (ourPsiManager != null) {
            LightPlatformTestCase.assertTrue((boolean)ourPsiManager.isDisposed());
            ourPsiManager = null;
        }
        ourPathToKeep = null;
    }

    static {
        PlatformTestUtil.registerProjectCleanup(LightPlatformTestCase::closeAndDeleteProject);
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final ModuleType myModuleType;
        @Nullable
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(@NotNull ModuleType moduleType, @Nullable Sdk sdk) {
            this.myModuleType = moduleType;
            this.mySdk = sdk;
        }

        @Override
        @NotNull
        public ModuleType getModuleType() {
            return this.myModuleType;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (!this.myModuleType.equals((Object)that.myModuleType)) {
                return false;
            }
            return this.areJdksEqual(that.getSdk());
        }

        public int hashCode() {
            return this.myModuleType.hashCode();
        }

        private boolean areJdksEqual(Sdk newSdk) {
            OrderRootType[] rootTypes;
            if (this.mySdk == null || newSdk == null) {
                return this.mySdk == newSdk;
            }
            for (OrderRootType rootType : rootTypes = new OrderRootType[]{OrderRootType.CLASSES, AnnotationOrderRootType.getInstance()}) {
                Object[] myUrls = this.mySdk.getRootProvider().getUrls(rootType);
                Object[] newUrls = newSdk.getRootProvider().getUrls(rootType);
                if (ContainerUtil.newHashSet((Object[])myUrls).equals(ContainerUtil.newHashSet((Object[])newUrls))) continue;
                return false;
            }
            return true;
        }
    }
}

