/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.DefaultLogger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LoggedErrorProcessor {
    private static final LoggedErrorProcessor DEFAULT;
    private static LoggedErrorProcessor ourInstance;

    @NotNull
    public static LoggedErrorProcessor getInstance() {
        return ourInstance;
    }

    public static void setNewInstance(@NotNull LoggedErrorProcessor newInstance) {
        ourInstance = newInstance;
    }

    public static void restoreDefaultProcessor() {
        ourInstance = DEFAULT;
    }

    public void processWarn(String message, Throwable t, @NotNull Logger logger) {
        logger.warn((Object)message, t);
    }

    public void processError(String message, Throwable t, String[] details, @NotNull Logger logger) {
        message = message + DefaultLogger.attachmentsToString((Throwable)t);
        logger.info((Object)message, t);
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
            if (details != null && details.length > 0) {
                System.err.println("details: ");
                for (String detail : details) {
                    System.err.println(detail);
                }
            }
        }
        throw new AssertionError(message, t);
    }

    public void disableStderrDumping(@NotNull Disposable parentDisposable) {
        DefaultLogger.disableStderrDumping((Disposable)parentDisposable);
    }

    static {
        ourInstance = DEFAULT = new LoggedErrorProcessor();
    }
}

