/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.ide.GeneratedSourceFileChangeTrackerImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TempFiles;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static IdeaTestApplication ourApplication;
    private static boolean ourReportedLeakedProjects;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected final Collection<File> myFilesToDelete = new THashSet();
    private final TempFiles myTempFiles = new TempFiles(this.myFilesToDelete);
    protected boolean myAssertionsInTestDetected;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    private static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    @Nullable
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private static final String[] PREFIX_CANDIDATES;

    @NotNull
    public TempFiles getTempDir() {
        return this.myTempFiles;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure() throws IOException {
        return PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, this.myFilesToDelete);
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(String rootPath) throws Exception {
        return PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, rootPath, this.myFilesToDelete);
    }

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourApplication == null;
        ourApplication = IdeaTestApplication.getInstance(null);
        ourApplication.setDataProvider(this);
        if (firstTime) {
            PlatformTestCase.cleanPersistedVFSContent();
        }
        this.myOldSdks = new SdkLeakTracker();
    }

    public static void doAutodetectPlatformPrefix() {
        if (Arrays.asList(PREFIX_CANDIDATES).contains(System.getProperty("idea.platform.prefix"))) {
            ourPlatformPrefixInitialized = true;
        }
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            String markerPath = candidate != null ? "META-INF/" + candidate + "Plugin.xml" : "idea/ApplicationInfo.xml";
            URL resource = PlatformTestCase.class.getClassLoader().getResource(markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            PlatformTestCase.setPlatformPrefix(candidate);
            break;
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File tempDir = new File(FileUtilRt.getTempDirectory());
        this.myFilesToDelete.add(tempDir);
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            PlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        this.setUpProject();
        boolean isTrackCodeStyleChanges = !this.isStressTest() && ApplicationManager.getApplication() != null && !(ApplicationManager.getApplication() instanceof MockApplication);
        this.myCodeStyleSettingsTracker = isTrackCodeStyleChanges ? new CodeStyleSettingsTracker(() -> CodeStyle.getDefaultSettings()) : null;
        ourTestCase = this;
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            CodeStyle.setTemporarySettings((Project)this.myProject, (CodeStyleSettings)new CodeStyleSettings());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).clearUncommittedDocuments();
        }
        UIUtil.dispatchAllInvocationEvents();
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        PlatformTestCase.assertNotNull((String)"Cannot instantiate ProjectManager component", (Object)this.myProjectManager);
        this.myProject = this.doCreateProject(this.getProjectDirOrFile());
        this.myProjectManager.openTestProject(this.myProject);
        LocalFileSystem.getInstance().refreshIoFiles(this.myFilesToDelete);
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            this.setUpModule();
            this.setUpJdk();
        }));
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        this.runStartupActivities();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    @NotNull
    protected Project doCreateProject(@NotNull Path projectFile) throws Exception {
        return PlatformTestCase.createProject(projectFile.toFile(), ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }

    @NotNull
    public static Project createProject(@NotNull File projectFile, @NotNull String creationPlace) {
        return PlatformTestCase.createProject(projectFile.getPath(), creationPlace);
    }

    @NotNull
    public static Project createProject(@NotNull String path, @NotNull String creationPlace) {
        String fileName = PathUtilRt.getFileName((String)path);
        try {
            String projectName = FileUtilRt.getNameWithoutExtension((String)fileName);
            Project project2 = ProjectManagerEx.getInstanceEx().newProject(projectName, path);
            project2.putUserData(CREATION_PLACE, (Object)creationPlace);
            return project2;
        }
        catch (TooManyProjectLeakedException e) {
            if (ourReportedLeakedProjects) {
                PlatformTestCase.fail((String)"Too many projects leaked, again.");
                return null;
            }
            ourReportedLeakedProjects = true;
            PlatformTestCase.reportLeakedProjects(e);
            return null;
        }
    }

    @NotNull
    public static String publishHeapDump(@NotNull String fileNamePrefix) {
        String fileName = fileNamePrefix + ".hprof.zip";
        File dumpFile = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), fileName);
        try {
            FileUtil.delete((File)dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped((File)dumpFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String dumpPath = dumpFile.getAbsolutePath();
        System.out.println("##teamcity[publishArtifacts '" + dumpPath + "']");
        return dumpPath;
    }

    @Contract(value="_ -> fail")
    public static void reportLeakedProjects(@NotNull TooManyProjectLeakedException e) {
        TIntHashSet hashCodes = new TIntHashSet();
        for (Project project2 : e.getLeakedProjects()) {
            hashCodes.add(System.identityHashCode(project2));
        }
        String dumpPath = PlatformTestCase.publishHeapDump("leakedProjects");
        StringBuilder leakers = new StringBuilder();
        leakers.append("Too many projects leaked: \n");
        LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, p -> hashCodes.contains(System.identityHashCode(p)), (leaked, backLink) -> {
            int hashCode = System.identityHashCode(leaked);
            leakers.append("Leaked project found:").append(leaked).append("; hash: ").append(hashCode).append("; place: ").append(PlatformTestCase.getCreationPlace((Project)leaked)).append("\n");
            leakers.append(backLink).append("\n");
            leakers.append(";-----\n");
            hashCodes.remove(hashCode);
            return !hashCodes.isEmpty();
        });
        PlatformTestCase.fail((String)(leakers + "\nPlease see '" + dumpPath + "' for a memory dump"));
    }

    @NotNull
    public static String getCreationPlace(@NotNull Project project2) {
        String base;
        try {
            base = project2.isDisposed() ? "" : project2.getBaseDir();
        }
        catch (Exception e) {
            base = " (" + e + " while getting base dir)";
        }
        String place = (String)project2.getUserData(CREATION_PLACE);
        return project2 + " " + (place == null ? "" : place) + base;
    }

    protected void runStartupActivities() {
        StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        startupManager.runStartupActivities();
        startupManager.startCacheUpdate();
        startupManager.runPostStartupActivities();
    }

    @NotNull
    protected Path getProjectDirOrFile() {
        return this.getProjectDirOrFile(false);
    }

    protected boolean isCreateProjectFileExplicitly() {
        return true;
    }

    @NotNull
    protected final Path getProjectDirOrFile(boolean isDirectoryBasedProject) {
        if (!isDirectoryBasedProject && this.isCreateProjectFileExplicitly()) {
            try {
                File tempFile = FileUtil.createTempFile((String)this.getName(), (String)".ipr");
                this.myFilesToDelete.add(tempFile);
                return tempFile.toPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Path tempFile = TemporaryDirectoryKt.generateTemporaryPath(FileUtil.sanitizeFileName((String)this.getName(), (boolean)false) + (isDirectoryBasedProject ? "" : ".ipr"));
        this.myFilesToDelete.add(tempFile.toFile());
        return tempFile;
    }

    protected void setUpModule() {
        try {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                this.myModule = this.createMainModule();
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        return this.createModule(this.myProject.getName());
    }

    @NotNull
    protected Module createModule(@NonNls @NotNull String moduleName) {
        return this.doCreateRealModule(moduleName);
    }

    @NotNull
    protected Module doCreateRealModule(@NotNull String moduleName) {
        return this.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
    }

    @NotNull
    protected Module doCreateRealModuleIn(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType moduleType) {
        return this.createModuleAt(moduleName, project2, moduleType, Objects.requireNonNull(project2.getBasePath()));
    }

    @NotNull
    protected Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType moduleType, @NotNull String path) {
        if (this.isCreateProjectFileExplicitly()) {
            File moduleFile = new File(FileUtil.toSystemDependentName((String)path), moduleName + ".iml");
            FileUtil.createIfDoesntExist((File)moduleFile);
            this.myFilesToDelete.add(moduleFile);
            return (Module)WriteAction.computeAndWait(() -> {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
                PlatformTestCase.assertNotNull((Object)virtualFile);
                Module module2 = ModuleManager.getInstance((Project)project2).newModule(virtualFile.getPath(), moduleType.getId());
                module2.getModuleFile();
                return module2;
            });
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        return (Module)WriteAction.computeAndWait(() -> moduleManager.newModule(path + File.separatorChar + moduleName + ".iml", moduleType.getId()));
    }

    @NotNull
    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(@Nullable Project project2) {
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        assert (projectManager != null) : "The ProjectManager is not initialized yet";
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)defaultProject)).cleanupForNextTest();
        }
        NonBlockingReadActionImpl.cancelAllTasks();
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).cleanupForNextTest();
        LocalFileSystemImpl localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance();
        if (localFileSystem != null) {
            localFileSystem.cleanupForNextTest();
        }
    }

    @NotNull
    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            return ourEternallyLivingFilesCache;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                PlatformTestCase.registerSurvivor(survivors, file);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        return survivors;
    }

    public static void addSurvivingFiles(@NotNull Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            PlatformTestCase.registerSurvivor(PlatformTestCase.eternallyLivingFiles(), virtualFile);
        }
    }

    private static void registerSurvivor(@NotNull Set<? super VirtualFile> survivors, @NotNull VirtualFile file) {
        PlatformTestCase.addSubTree(file, survivors);
        while (file != null && survivors.add((VirtualFile)file)) {
            file = file.getParent();
        }
    }

    private static void addSubTree(@NotNull VirtualFile root, @NotNull Set<? super VirtualFile> to) {
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add((VirtualFile)child);
                PlatformTestCase.addSubTree(child, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            AutoPopupController.getInstance((Project)project2).cancelAllRequests();
            PlatformTestCase.waitForProjectLeakingThreads(project2, 10L, TimeUnit.SECONDS);
        }
        new RunAll(new ThrowableRunnable[0]).append(() -> this.disposeRootDisposable()).append(() -> {
            if (project2 != null) {
                LightPlatformTestCase.doTearDown(project2, ourApplication);
            }
        }).append(() -> this.disposeProject()).append(() -> UIUtil.dispatchAllInvocationEvents()).append(() -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }).append(() -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }).append(() -> {
            JarFileSystemImpl.cleanupForNextTest();
            this.getTempDir().deleteAll();
            LocalFileSystem.getInstance().refreshIoFiles(this.myFilesToDelete);
            LaterInvocator.dispatchPendingFlushes();
        }).append(() -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> super.tearDown()).append(() -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }).append(() -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }).append(() -> LightPlatformTestCase.checkEditorsReleased()).append(() -> this.myOldSdks.checkForJdkTableLeaks()).append(() -> this.myVirtualFilePointerTracker.assertPointersAreDisposed()).append(() -> {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            this.myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        }).run();
    }

    private void disposeProject() {
        if (this.myProject != null) {
            PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.myProject);
            this.myProject = null;
        }
    }

    public static void closeAndDisposeProjectAndCheckThatNoOpenProjects(@NotNull Project projectToClose) {
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        for (Project project2 : projectManager.closeTestProject(projectToClose)) {
            runAll = runAll.append(() -> {
                throw new IllegalStateException("Test project is not disposed: " + project2 + ";\n created in: " + PlatformTestCase.getCreationPlace(project2));
            }).append(() -> projectManager.forceCloseProject(project2, true));
        }
        runAll.append(() -> WriteAction.run(() -> Disposer.dispose((Disposable)projectToClose))).run();
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    @NotNull
    protected final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        Disposer.register((Disposable)this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        try {
            PlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == PlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.runBareImpl();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    PlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                }));
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl() throws Throwable {
        ThrowableRunnable runnable = () -> {
            ourTestThread = Thread.currentThread();
            ourTestTime = 300L;
            try {
                try {
                    this.myAssertionsInTestDetected = true;
                    this.setUp();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw e;
                }
                Throwable exception = null;
                try {
                    this.myAssertionsInTestDetected = true;
                    this.runTest();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    block20: {
                        try {
                            this.tearDown();
                        }
                        catch (Throwable e) {
                            if (exception != null) break block20;
                            exception = e;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                ourTestThread = null;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        PlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        Exception[] e = new Exception[1];
        Runnable runnable1 = () -> {
            try {
                if (ApplicationManager.getApplication().isDispatchThread() && this.isRunInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(runnable);
                } else {
                    runnable.run();
                }
            }
            catch (Exception e1) {
                e[0] = e1;
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public Object getData(@NotNull String dataId) {
        return this.myProject == null ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix) throws IOException {
        return this.createTempDir(prefix, true);
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix, boolean refresh2) throws IOException {
        File tempDirectory = FileUtilRt.createTempDirectory((String)("idea_test_" + prefix), null, (boolean)false);
        this.myFilesToDelete.add(tempDirectory);
        if (refresh2) {
            PlatformTestCase.getVirtualFile(tempDirectory);
        }
        return tempDirectory;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @NotNull
    protected File createTempDirectory() throws IOException {
        return this.createTempDir("");
    }

    @NotNull
    protected File createTempDirectory(boolean refresh2) throws IOException {
        return this.createTempDir("", refresh2);
    }

    @NotNull
    protected File createTempFile(@NotNull String name2, @Nullable String text) throws IOException {
        File directory = this.createTempDirectory();
        File file = new File(directory, name2);
        if (!file.createNewFile()) {
            throw new IOException("Can't create " + file);
        }
        if (text != null) {
            FileUtil.writeToFile((File)file, (String)text);
        }
        return file;
    }

    public static void setContentOnDisk(@NotNull File file, @Nullable byte[] bom, @NotNull String content, @NotNull Charset charset) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
    }

    @NotNull
    public VirtualFile createTempFile(@NonNls @NotNull String ext, @Nullable byte[] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        File temp = FileUtil.createTempFile((String)"copy", (String)("." + ext));
        PlatformTestCase.setContentOnDisk(temp, bom, content, charset);
        this.myFilesToDelete.add(temp);
        VirtualFile file = PlatformTestCase.getVirtualFile(temp);
        assert (file != null) : temp;
        return file;
    }

    @Nullable
    protected PsiFile getPsiFile(@NotNull Document document2) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document2);
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    @NotNull
    protected static VirtualFile createChildData(@NotNull VirtualFile dir, @NotNull @NonNls String name2) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildData(null, name2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NotNull @NonNls String name2) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildDirectory(null, name2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void rename(@NotNull VirtualFile vFile1, @NotNull String newName) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.rename((Object)vFile1, newName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void delete(@NotNull VirtualFile vFile1) {
        VfsTestUtil.deleteFile(vFile1);
    }

    public static void move(@NotNull VirtualFile vFile1, @NotNull VirtualFile newFile) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.move((Object)vFile1, newFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile copy(@NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) {
        VirtualFile[] copy = new VirtualFile[1];
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                copy[0] = file.copy((Object)file, newParent, copyName);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return copy[0];
    }

    public static void copyDirContentsTo(@NotNull VirtualFile vTestRoot, @NotNull VirtualFile toDir) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                for (VirtualFile file : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)file, (VirtualFile)file, (VirtualFile)toDir);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileText(@NotNull VirtualFile file, @NotNull String text) {
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file, @NotNull byte[] content) {
        try {
            WriteAction.runAndWait(() -> file.setBinaryContent(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file, @NotNull byte[] content, long newModificationStamp, long newTimeStamp, Object requestor) {
        try {
            WriteAction.runAndWait(() -> file.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected VirtualFile getOrCreateProjectBaseDir() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir == null) {
            String basePath = this.myProject.getBasePath();
            try {
                FileUtil.ensureExists((File)new File(Objects.requireNonNull(basePath)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath);
        }
        return baseDir;
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module2) throws IOException {
        File moduleDir = new File(PathUtil.getParentPath((String)module2.getModuleFilePath()));
        FileUtil.ensureExists((File)moduleDir);
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir);
    }

    public static void waitForProjectLeakingThreads(@NotNull Project project2, long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        DaemonCodeAnalyzerImpl.waitForAllEditorsFinallyLoaded((Project)project2, (long)timeout, (TimeUnit)timeUnit);
        GeneratedSourceFileChangeTrackerImpl tracker = (GeneratedSourceFileChangeTrackerImpl)project2.getComponent(GeneratedSourceFileChangeTracker.class);
        if (tracker != null) {
            tracker.cancelAllAndWait(timeout, timeUnit);
        }
    }

    static {
        ourTestTime = 300L;
        PREFIX_CANDIDATES = new String[]{"AndroidStudio", "Idea"};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

