/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.io.Decompressor;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.Equality;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;

public class PlatformTestUtil {
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    private static final List<Runnable> ourProjectCleanups = new CopyOnWriteArrayList<Runnable>();
    private static final long MAX_WAIT_TIME = TimeUnit.MINUTES.toMillis(2L);
    private static final OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) {
        }
    };

    @NotNull
    public static String getTestName(@NotNull String name2, boolean lowercaseFirstLetter) {
        return StringUtil.isEmpty((String)(name2 = StringUtil.trimStart((String)name2, (String)"test"))) ? "" : PlatformTestUtil.lowercaseFirstLetter(name2, lowercaseFirstLetter);
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String name2, boolean lowercaseFirstLetter) {
        if (lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName(name2)) {
            name2 = Character.toLowerCase(name2.charAt(0)) + name2.substring(1);
        }
        return name2;
    }

    public static boolean isAllUppercaseName(@NotNull String name2) {
        int uppercaseChars = 0;
        for (int i = 0; i < name2.length(); ++i) {
            if (Character.isLowerCase(name2.charAt(i))) {
                return false;
            }
            if (!Character.isUpperCase(name2.charAt(i))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    public static <T> void maskExtensions(@NotNull ExtensionPointName<T> pointName, @NotNull List<T> newExtensions, @NotNull Disposable parentDisposable) {
        ((ExtensionPointImpl)pointName.getPoint(null)).maskAll(newExtensions, parentDisposable);
    }

    public static <T> void maskExtensions(@NotNull ProjectExtensionPointName<T> pointName, @NotNull Project project2, @NotNull List<T> newExtensions, @NotNull Disposable parentDisposable) {
        ((ExtensionPointImpl)pointName.getPoint((AreaInstance)project2)).maskAll(newExtensions, parentDisposable);
    }

    @Deprecated
    public static <T> void registerExtension(@NotNull ExtensionPointName<T> name2, @NotNull T t, @NotNull Disposable parentDisposable) {
        PlatformTestUtil.registerExtension(Extensions.getRootArea(), name2, t, parentDisposable);
    }

    public static <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull BaseExtensionPointName name2, @NotNull T t, @NotNull Disposable parentDisposable) {
        area.getExtensionPoint(name2.getName()).registerExtension(t, parentDisposable);
    }

    @Nullable
    public static String toString(@Nullable Object node, @Nullable Queryable.PrintInfo printInfo) {
        if (node instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node).toTestString(printInfo);
            }
            String presentation = ((AbstractTreeNode)node).getTestPresentation();
            return presentation;
        }
        return String.valueOf(node);
    }

    public static String print(JTree tree, boolean withSelection) {
        return PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, null);
    }

    public static String print(JTree tree, TreePath path, @Nullable Queryable.PrintInfo printInfo, boolean withSelection) {
        return PlatformTestUtil.print(tree, path, withSelection, printInfo, null);
    }

    public static String print(JTree tree, boolean withSelection, @Nullable Predicate<? super String> nodePrintCondition) {
        return PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, nodePrintCondition);
    }

    private static String print(JTree tree, TreePath path, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        return StringUtil.join(PlatformTestUtil.printAsList(tree, path, withSelection, printInfo, nodePrintCondition), (String)"\n");
    }

    private static Collection<String> printAsList(JTree tree, TreePath path, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        ArrayList<String> strings = new ArrayList<String>();
        PlatformTestUtil.printImpl(tree, path, strings, 0, withSelection, printInfo, nodePrintCondition);
        return strings;
    }

    private static void printImpl(JTree tree, TreePath path, Collection<? super String> strings, int level, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        Object pathComponent = path.getLastPathComponent();
        Object userObject = TreeUtil.getUserObject((Object)pathComponent);
        String nodeText = PlatformTestUtil.toString(userObject, printInfo);
        if (nodePrintCondition != null && !nodePrintCondition.test(nodeText)) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buff, (char)' ', (int)level);
        boolean expanded = tree.isExpanded(path);
        int childCount = tree.getModel().getChildCount(pathComponent);
        if (childCount > 0) {
            buff.append(expanded ? "-" : "+");
        }
        boolean selected = tree.getSelectionModel().isPathSelected(path);
        if (withSelection && selected) {
            buff.append("[");
        }
        buff.append(nodeText);
        if (withSelection && selected) {
            buff.append("]");
        }
        strings.add(buff.toString());
        if (expanded) {
            for (int i = 0; i < childCount; ++i) {
                TreePath childPath = path.pathByAddingChild(tree.getModel().getChild(pathComponent, i));
                PlatformTestUtil.printImpl(tree, childPath, strings, level + 1, withSelection, printInfo, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(JTree tree, @NonNls String expected) {
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqual(JTree tree, String expected, boolean checkSelected) {
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        Assert.assertEquals((Object)expected.trim(), (Object)treeStringPresentation.trim());
    }

    public static void expand(JTree tree, int ... rows) {
        for (int row : rows) {
            tree.expandRow(row);
            PlatformTestUtil.waitWhileBusy(tree);
        }
    }

    public static void expandAll(JTree tree) {
        PlatformTestUtil.waitForPromise(TreeUtil.promiseExpandAll((JTree)tree));
    }

    private static long getMillisSince(long startTimeMillis) {
        return System.currentTimeMillis() - startTimeMillis;
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis) {
        PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis, MAX_WAIT_TIME);
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis, long timeout) {
        assert (PlatformTestUtil.getMillisSince(startTimeMillis) <= timeout) : "the waiting takes too long";
    }

    private static void assertDispatchThreadWithoutWriteAccess() {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess(ApplicationManager.getApplication());
    }

    private static void assertDispatchThreadWithoutWriteAccess(Application application) {
        if (application != null) {
            assert (!application.isWriteAccessAllowed()) : "do not wait under the write action to avoid possible deadlock";
            assert (application.isDispatchThread());
        } else assert (EventQueue.isDispatchThread());
    }

    private static boolean isBusy(JTree tree, TreeModel model) {
        UIUtil.dispatchAllInvocationEvents();
        if (model instanceof AsyncTreeModel) {
            AsyncTreeModel async = (AsyncTreeModel)model;
            if (async.isProcessing()) {
                return true;
            }
            UIUtil.dispatchAllInvocationEvents();
            return async.isProcessing();
        }
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor((JTree)tree);
        if (builder == null) {
            return false;
        }
        AbstractTreeUi ui = builder.getUi();
        if (ui == null) {
            return false;
        }
        return ui.hasPendingWork();
    }

    public static void waitWhileBusy(JTree tree) {
        PlatformTestUtil.waitWhileBusy(tree, tree.getModel());
    }

    public static void waitWhileBusy(JTree tree, TreeModel model) {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long startTimeMillis = System.currentTimeMillis();
        while (PlatformTestUtil.isBusy(tree, model)) {
            PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis);
            TimeoutUtil.sleep((long)5L);
        }
    }

    public static void waitForCallback(@NotNull ActionCallback callback) {
        AsyncPromise promise = new AsyncPromise();
        callback.doWhenDone(() -> promise.setResult(null));
        PlatformTestUtil.waitForPromise(promise);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise, long timeout) {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        AtomicBoolean complete = new AtomicBoolean(false);
        promise.onProcessed(ignore -> complete.set(true));
        Object result = null;
        long start = System.currentTimeMillis();
        do {
            UIUtil.dispatchAllInvocationEvents();
            try {
                result = promise.blockingGet(20, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeout);
        } while (!complete.get());
        UIUtil.dispatchAllInvocationEvents();
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAlarm(int delay) {
        Application app = ApplicationManager.getApplication();
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        Disposable tempDisposable = Disposer.newDisposable();
        AtomicBoolean runnableInvoked = new AtomicBoolean();
        AtomicBoolean pooledRunnableInvoked = new AtomicBoolean();
        AtomicBoolean alarmInvoked1 = new AtomicBoolean();
        AtomicBoolean alarmInvoked2 = new AtomicBoolean();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Alarm pooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, tempDisposable);
        ModalityState initialModality = ModalityState.current();
        alarm.addRequest(() -> {
            alarmInvoked1.set(true);
            app.invokeLater(() -> {
                runnableInvoked.set(true);
                alarm.addRequest(() -> alarmInvoked2.set(true), delay);
            });
        }, delay);
        pooledAlarm.addRequest(() -> pooledRunnableInvoked.set(true), delay);
        UIUtil.dispatchAllInvocationEvents();
        long start = System.currentTimeMillis();
        try {
            boolean sleptAlready = false;
            while (!alarmInvoked2.get()) {
                AtomicBoolean laterInvoked = new AtomicBoolean();
                app.invokeLater(() -> laterInvoked.set(true));
                UIUtil.dispatchAllInvocationEvents();
                Assert.assertTrue((boolean)laterInvoked.get());
                TimeoutUtil.sleep((long)(sleptAlready ? 10L : (long)delay));
                sleptAlready = true;
                if (PlatformTestUtil.getMillisSince(start) <= MAX_WAIT_TIME) continue;
                String queue = ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).dumpQueue();
                throw new AssertionError((Object)("Couldn't await alarm; alarm passed=" + alarmInvoked1.get() + "; modality1=" + initialModality + "; modality2=" + ModalityState.current() + "; non-modal=" + (initialModality == ModalityState.NON_MODAL) + "; invokeLater passed=" + runnableInvoked.get() + "; pooled alarm passed=" + pooledRunnableInvoked.get() + "; app.disposed=" + app.isDisposed() + "; alarm.disposed=" + alarm.isDisposed() + "; alarm.requests=" + alarm.getActiveRequestCount() + "\n delayQueue=" + StringUtil.trimLog((String)queue, (int)1000) + "\n invocatorQueue=" + LaterInvocator.getLaterInvocatorQueue()));
            }
        }
        finally {
            Disposer.dispose((Disposable)tempDisposable);
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() {
        AWTEvent event;
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (!(event instanceof InvocationEvent)) continue;
                eventQueue.dispatchEvent(event);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void dispatchAllEventsInIdeEventQueue() throws InterruptedException {
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (PlatformTestUtil.dispatchNextEventIfAny(eventQueue) != null) {
        }
    }

    public static AWTEvent dispatchNextEventIfAny(@NotNull IdeEventQueue eventQueue) throws InterruptedException {
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        AWTEvent event = eventQueue.peekEvent();
        if (event == null) {
            return null;
        }
        AWTEvent event1 = eventQueue.getNextEvent();
        eventQueue.dispatchEvent(event1);
        return event1;
    }

    public static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator comparator, int maxRowCount, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        return PlatformTestUtil.print(structure, node, currentLevel, comparator, maxRowCount, paddingChar, (Object o) -> PlatformTestUtil.toString(o, printInfo));
    }

    public static String print(AbstractTreeStructure structure, Object node, Function<Object, String> nodePresenter) {
        return PlatformTestUtil.print(structure, node, 0, Comparator.comparing(nodePresenter), -1, ' ', nodePresenter).toString();
    }

    private static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator comparator, int maxRowCount, char paddingChar, Function<Object, String> nodePresenter) {
        StringBuilder buffer = new StringBuilder();
        PlatformTestUtil.doPrint(buffer, currentLevel, node, structure, comparator, maxRowCount, 0, paddingChar, nodePresenter);
        return buffer;
    }

    private static int doPrint(StringBuilder buffer, int currentLevel, Object node, AbstractTreeStructure structure, @Nullable Comparator comparator, int maxRowCount, int currentLine, char paddingChar, Function<Object, String> nodePresenter) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)paddingChar, (int)currentLevel);
        buffer.append(nodePresenter.apply(node)).append("\n");
        ++currentLine;
        Object[] children = structure.getChildElements(node);
        if (comparator != null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(children));
            Comparator c = comparator;
            Collections.sort(list, c);
            children = ArrayUtil.toObjectArray(list);
        }
        for (Object child : children) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator, maxRowCount, currentLine, paddingChar, nodePresenter);
        }
        return currentLine;
    }

    public static String print(Object[] objects) {
        return PlatformTestUtil.print(Arrays.asList(objects));
    }

    public static String print(Collection c) {
        StringBuilder result = new StringBuilder();
        Iterator iterator2 = c.iterator();
        while (iterator2.hasNext()) {
            Object each = iterator2.next();
            result.append(PlatformTestUtil.toString(each, null));
            if (!iterator2.hasNext()) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static String print(ListModel model) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            result.append(PlatformTestUtil.toString(model.getElementAt(i), null));
            result.append("\n");
        }
        return result.toString();
    }

    public static String print(JTree tree) {
        return PlatformTestUtil.print(tree, false);
    }

    public static void invokeNamedAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        Presentation presentation = new Presentation();
        DataContext context = DataManager.getInstance().getDataContext();
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)context);
        action.beforeActionPerformedUpdate(event);
        Assert.assertTrue((boolean)presentation.isEnabled());
        action.actionPerformed(event);
    }

    public static void assertTiming(String message, long expectedMs, long actual) {
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expectedMs * Timings.CPU_TIMING / 200L);
        String logMessage = message;
        if (actual > expectedOnMyMachine) {
            int percentage = (int)(100.0 * (double)(actual - expectedOnMyMachine) / (double)expectedOnMyMachine);
            logMessage = logMessage + ". Operation took " + percentage + "% longer than expected";
        }
        logMessage = logMessage + ". Expected on my machine: " + expectedOnMyMachine + ". Actual: " + actual + ". Expected on Standard machine: " + expectedMs + "; Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + ".";
        double acceptableChangeFactor = 1.1;
        if (actual < expectedOnMyMachine) {
            System.out.println(logMessage);
            TeamCityLogger.info((String)logMessage);
        } else if ((double)actual < (double)expectedOnMyMachine * 1.1) {
            TeamCityLogger.warning((String)logMessage, null);
        } else {
            throw new AssertionFailedError(logMessage);
        }
    }

    @Contract(pure=true)
    public static PerformanceTestInfo startPerformanceTest(@NonNls @NotNull String what, int expectedMs, @NotNull ThrowableRunnable test) {
        return new PerformanceTestInfo(test, expectedMs, what);
    }

    public static void assertPathsEqual(@Nullable String expected, @Nullable String actual) {
        if (expected != null) {
            expected = FileUtil.toSystemIndependentName((String)expected);
        }
        if (actual != null) {
            actual = FileUtil.toSystemIndependentName((String)actual);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @NotNull
    public static String getJavaExe() {
        return SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
    }

    @NotNull
    public static String getRtJarPath() {
        return SystemProperties.getJavaHome() + "/lib/rt.jar";
    }

    @NotNull
    public static URL getRtJarURL() {
        String home = SystemProperties.getJavaHome();
        try {
            return JavaVersion.current().feature >= 9 ? new URL("jrt:" + home) : new File(home + "/lib/rt.jar").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void forceCloseProjectWithoutSaving(@NotNull Project project2) {
        ProjectManagerEx.getInstanceEx().forceCloseProject(project2, false);
        ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)project2));
    }

    public static void saveProject(@NotNull Project project2) {
        PlatformTestUtil.saveProject(project2, false);
    }

    public static void saveProject(@NotNull Project project2, boolean isForceSavingAllSettings) {
        ProjectManagerEx.getInstanceEx().flushChangedProjectFileAlarm();
        StateStorageManagerKt.saveComponentManager((ComponentManager)project2, (boolean)isForceSavingAllSettings);
    }

    static void waitForAllBackgroundActivityToCalmDown() {
        CpuUsageData data;
        for (int i = 0; i < 50 && (data = CpuUsageData.measureCpuUsage(() -> TimeoutUtil.sleep((long)100L))).hasAnyActivityBesides(Thread.currentThread()); ++i) {
        }
    }

    public static void assertTiming(String message, long expected, @NotNull Runnable actionToMeasure) {
        PlatformTestUtil.assertTiming(message, expected, 4, actionToMeasure);
    }

    public static long measure(@NotNull Runnable actionToMeasure) {
        long start = System.currentTimeMillis();
        actionToMeasure.run();
        long finish = System.currentTimeMillis();
        return finish - start;
    }

    public static void assertTiming(String message, long expected, int attempts, @NotNull Runnable actionToMeasure) {
        while (true) {
            --attempts;
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            long duration = PlatformTestUtil.measure(actionToMeasure);
            try {
                PlatformTestUtil.assertTiming(message, expected, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                String s = e.getMessage() + "\n  " + attempts + " attempts remain";
                TeamCityLogger.warning((String)s, null);
                System.err.println(s);
                continue;
            }
            break;
        }
    }

    private static Map<String, VirtualFile> buildNameToFileMap(VirtualFile[] files, @Nullable VirtualFileFilter filter) {
        HashMap<String, VirtualFile> map2 = new HashMap<String, VirtualFile>();
        for (VirtualFile file : files) {
            if (filter != null && !filter.accept(file)) continue;
            map2.put(file.getName(), file);
        }
        return map2;
    }

    public static void assertDirectoriesEqual(VirtualFile dirExpected, VirtualFile dirActual) throws IOException {
        PlatformTestUtil.assertDirectoriesEqual(dirExpected, dirActual, null);
    }

    public static void assertDirectoriesEqual(VirtualFile dirExpected, VirtualFile dirActual, @Nullable VirtualFileFilter fileFilter) throws IOException {
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirExpected.getChildren();
        PlatformTestUtil.shallowCompare(dirExpected, childrenAfter);
        VirtualFile[] childrenBefore = dirActual.getChildren();
        PlatformTestUtil.shallowCompare(dirActual, childrenBefore);
        Map<String, VirtualFile> mapAfter = PlatformTestUtil.buildNameToFileMap(childrenAfter, fileFilter);
        Map<String, VirtualFile> mapBefore = PlatformTestUtil.buildNameToFileMap(childrenBefore, fileFilter);
        Set<String> keySetAfter = mapAfter.keySet();
        Set<String> keySetBefore = mapBefore.keySet();
        Assert.assertEquals((String)dirExpected.getPath(), keySetAfter, keySetBefore);
        for (String name2 : keySetAfter) {
            VirtualFile fileAfter = mapAfter.get(name2);
            VirtualFile fileBefore = mapBefore.get(name2);
            if (fileAfter.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(VirtualFile dir, VirtualFile[] vfs) {
        if (dir.isInLocalFileSystem() && dir.getFileSystem() != TempFileSystem.getInstance()) {
            String vfsPaths = Stream.of(vfs).map(VirtualFile::getPath).sorted().collect(Collectors.joining("\n"));
            File[] io = PlatformTestUtil.notNull(new File(dir.getPath()).listFiles());
            String ioPaths = Stream.of(io).map(f -> FileUtil.toSystemIndependentName((String)f.getPath())).sorted().collect(Collectors.joining("\n"));
            Assert.assertEquals((Object)vfsPaths, (Object)ioPaths);
        }
    }

    public static void assertFilesEqual(VirtualFile fileExpected, VirtualFile fileActual) throws IOException {
        block3: {
            try {
                PlatformTestUtil.assertJarFilesEqual(VfsUtilCore.virtualToIoFile((VirtualFile)fileExpected), VfsUtilCore.virtualToIoFile((VirtualFile)fileActual));
            }
            catch (IOException e) {
                String actual = PlatformTestUtil.fileText(fileActual);
                String expected = PlatformTestUtil.fileText(fileExpected);
                if (expected == null || actual == null) {
                    Assert.assertArrayEquals((String)fileExpected.getPath(), (byte[])fileExpected.contentsToByteArray(), (byte[])fileActual.contentsToByteArray());
                }
                if (StringUtil.equals((CharSequence)expected, (CharSequence)actual)) break block3;
                throw new FileComparisonFailure("Text mismatch in file " + fileExpected.getName(), expected, actual, fileExpected.getPath());
            }
        }
    }

    private static String fileText(VirtualFile file) throws IOException {
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        if (doc != null) {
            return doc.getText();
        }
        if (!file.getFileType().isBinary() || file.getFileType() == FileTypes.UNKNOWN) {
            return LoadTextUtil.getTextByBinaryPresentation((byte[])file.contentsToByteArray(false), (VirtualFile)file).toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertJarFilesEqual(File file1, File file2) throws IOException {
        File tempDir = FileUtilRt.createTempDirectory((String)"assert_jar_tmp", null, (boolean)false);
        try {
            File tempDirectory1 = new File(tempDir, "tmp1");
            File tempDirectory2 = new File(tempDir, "tmp2");
            FileUtilRt.createDirectory((File)tempDirectory1);
            FileUtilRt.createDirectory((File)tempDirectory2);
            try (JarFile jarFile1 = new JarFile(file1);
                 JarFile jarFile2 = new JarFile(file2);){
                new Decompressor.Zip(new File(jarFile1.getName())).extract(tempDirectory1);
                new Decompressor.Zip(new File(jarFile2.getName())).extract(tempDirectory2);
            }
            VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory1);
            Assert.assertNotNull((String)tempDirectory1.toString(), (Object)dirAfter);
            VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory2);
            Assert.assertNotNull((String)tempDirectory2.toString(), (Object)dirBefore);
            ApplicationManager.getApplication().runWriteAction(() -> {
                dirAfter.refresh(false, true);
                dirBefore.refresh(false, true);
            });
            PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore);
        }
        finally {
            FileUtilRt.delete((File)tempDir);
        }
    }

    public static String getCommunityPath() {
        String homePath = IdeaTestExecutionPolicy.getHomePathWithPolicy();
        if (new File(homePath, "community/.idea").isDirectory()) {
            return homePath + File.separatorChar + "community";
        }
        return homePath;
    }

    public static String getPlatformTestDataPath() {
        return PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/') + "/platform/platform-tests/testData/";
    }

    public static Comparator<AbstractTreeNode> createComparator(Queryable.PrintInfo printInfo) {
        return (o1, o2) -> {
            String displayText1 = o1.toTestString(printInfo);
            String displayText2 = o2.toTestString(printInfo);
            return Comparing.compare((Comparable)((Object)displayText1), (Comparable)((Object)displayText2));
        };
    }

    @NotNull
    public static <T> T notNull(@Nullable T t) {
        Assert.assertNotNull(t);
        return t;
    }

    @NotNull
    public static String loadFileText(@NotNull String fileName) throws IOException {
        return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(fileName)));
    }

    public static void withEncoding(@NotNull String encoding, @NotNull ThrowableRunnable r) {
        try {
            Charset oldCharset = Charset.defaultCharset();
            try {
                PlatformTestUtil.patchSystemFileEncoding(encoding);
                r.run();
            }
            finally {
                PlatformTestUtil.patchSystemFileEncoding(oldCharset.name());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void patchSystemFileEncoding(String encoding) {
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", encoding);
    }

    public static void withStdErrSuppressed(@NotNull Runnable r) {
        PrintStream std = System.err;
        System.setErr(new PrintStream(NULL));
        try {
            r.run();
        }
        finally {
            System.setErr(std);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine command) {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command.withRedirectErrorStream(true));
            Assert.assertEquals((String)output.getStdout(), (long)0L, (long)output.getExitCode());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static List<WebReference> collectWebReferences(@NotNull PsiElement element) {
        final ArrayList<WebReference> refs = new ArrayList<WebReference>();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                for (PsiReference ref : element.getReferences()) {
                    if (!(ref instanceof WebReference)) continue;
                    refs.add((WebReference)ref);
                }
                super.visitElement(element);
            }
        });
        return refs;
    }

    public static void registerProjectCleanup(@NotNull Runnable cleanup) {
        ourProjectCleanups.add(cleanup);
    }

    public static void cleanupAllProjects() {
        for (Runnable each : ourProjectCleanups) {
            each.run();
        }
        ourProjectCleanups.clear();
    }

    public static void disposeApplicationAndCheckForProjectLeaks() {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            try {
                LightPlatformTestCase.initApplication();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            PlatformTestUtil.cleanupAllProjects();
            UIUtil.dispatchAllInvocationEvents();
            ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
            System.out.println(application.writeActionStatistics());
            System.out.println(ActionUtil.ActionPauses.STAT.statistics());
            System.out.println(((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).statistics());
            System.out.println("ProcessIOExecutorService threads created: " + ((ProcessIOExecutorService)ProcessIOExecutorService.INSTANCE).getThreadCounter());
            try {
                LeakHunter.checkNonDefaultProjectLeak();
            }
            catch (AssertionError | Exception e) {
                PlatformTestUtil.captureMemorySnapshot();
                ExceptionUtil.rethrow((Throwable)e);
            }
            finally {
                application.setDisposeInProgress(true);
                LightPlatformTestCase.disposeApplication();
                UIUtil.dispatchAllInvocationEvents();
            }
        }));
    }

    public static void captureMemorySnapshot() {
        try {
            Method snapshot = ReflectionUtil.getMethod(Class.forName("com.intellij.util.ProfilingUtil"), (String)"captureMemorySnapshot", (Class[])new Class[0]);
            if (snapshot != null) {
                Object path = snapshot.invoke(null, new Object[0]);
                System.out.println("Memory snapshot captured to '" + path + "'");
            }
        }
        catch (ClassNotFoundException snapshot) {
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static <T> void assertComparisonContractNotViolated(@NotNull List<? extends T> values, @NotNull Comparator<? super T> comparator, @NotNull Equality<? super T> equality) {
        for (int i1 = 0; i1 < values.size(); ++i1) {
            for (int i2 = i1; i2 < values.size(); ++i2) {
                T value1 = values.get(i1);
                T value2 = values.get(i2);
                int result12 = comparator.compare(value1, value2);
                int result21 = comparator.compare(value2, value1);
                if (equality.equals(value1, value2)) {
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", value1, value2), (long)0L, (long)result12);
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", value2, value1), (long)0L, (long)result21);
                } else {
                    if (result12 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value2, value1));
                    }
                    if (Integer.signum(result12) == Integer.signum(result21)) {
                        Assert.fail((String)String.format("Not symmetrical: '%s' - '%s'", value1, value2));
                    }
                }
                for (int i3 = i2; i3 < values.size(); ++i3) {
                    int result31;
                    T value3 = values.get(i3);
                    int result23 = comparator.compare(value2, value3);
                    if (PlatformTestUtil.isTransitive(result12, result23, result31 = comparator.compare(value3, value1))) continue;
                    Assert.fail((String)String.format("Not transitive: '%s' - '%s' - '%s'", value1, value2, value3));
                }
            }
        }
    }

    private static boolean isTransitive(int result12, int result23, int result31) {
        if (result12 == 0 && result23 == 0 && result31 == 0) {
            return true;
        }
        if (result12 > 0 && result23 > 0 && result31 > 0) {
            return false;
        }
        if (result12 < 0 && result23 < 0 && result31 < 0) {
            return false;
        }
        if (result12 == 0 && Integer.signum(result23) * Integer.signum(result31) >= 0) {
            return false;
        }
        if (result23 == 0 && Integer.signum(result12) * Integer.signum(result31) >= 0) {
            return false;
        }
        return result31 != 0 || Integer.signum(result23) * Integer.signum(result12) < 0;
    }

    public static void setLongMeaninglessFileIncludeTemplateTemporarilyFor(@NotNull Project project2, @NotNull Disposable parentDisposable) {
        FileTemplateManagerImpl templateManager = (FileTemplateManagerImpl)FileTemplateManager.getInstance((Project)project2);
        templateManager.setDefaultFileIncludeTemplateTextTemporarilyForTest("File Header", "/**\n * Created by ${USER} on ${DATE}.\n */\n", parentDisposable);
    }
}

